; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+sse2 | FileCheck %s --check-prefixes=SSE
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+sse3 | FileCheck %s --check-prefixes=SSE
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+avx | FileCheck %s --check-prefixes=AVX
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+avx2 | FileCheck %s --check-prefixes=AVX
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512
;
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mcpu=slm | FileCheck %s --check-prefixes=SSE
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mcpu=goldmont | FileCheck %s --check-prefixes=SSE
; RUN: opt < %s -mtriple=x86_64-- -passes="print<cost-model>" 2>&1 -disable-output -cost-kind=code-size -mcpu=btver2 | FileCheck %s --check-prefixes=AVX

define i32 @cmp_float_oeq(i32 %arg) {
; SSE-LABEL: 'cmp_float_oeq'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp oeq float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp oeq <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp oeq <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp oeq <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp oeq <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp oeq double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp oeq <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp oeq <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp oeq <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp oeq <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_oeq'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp oeq float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp oeq <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp oeq <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp oeq <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp oeq <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp oeq double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp oeq <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp oeq <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp oeq <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp oeq <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_oeq'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp oeq float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp oeq <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp oeq <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp oeq <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp oeq <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp oeq double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp oeq <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp oeq <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp oeq <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp oeq <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp oeq float undef, undef
  %V2F32 = fcmp oeq <2 x float> undef, undef
  %V4F32 = fcmp oeq <4 x float> undef, undef
  %V8F32 = fcmp oeq <8 x float> undef, undef
  %V16F32 = fcmp oeq <16 x float> undef, undef

  %F64 = fcmp oeq double undef, undef
  %V2F64 = fcmp oeq <2 x double> undef, undef
  %V4F64 = fcmp oeq <4 x double> undef, undef
  %V8F64 = fcmp oeq <8 x double> undef, undef
  %V16F64 = fcmp oeq <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_one(i32 %arg) {
; SSE-LABEL: 'cmp_float_one'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp one float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2F32 = fcmp one <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4F32 = fcmp one <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8F32 = fcmp one <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V16F32 = fcmp one <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp one double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2F64 = fcmp one <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4F64 = fcmp one <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8F64 = fcmp one <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V16F64 = fcmp one <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_one'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp one float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp one <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp one <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp one <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp one <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp one double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp one <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp one <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp one <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp one <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_one'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp one float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp one <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp one <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp one <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp one <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp one double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp one <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp one <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp one <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp one <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp one float undef, undef
  %V2F32 = fcmp one <2 x float> undef, undef
  %V4F32 = fcmp one <4 x float> undef, undef
  %V8F32 = fcmp one <8 x float> undef, undef
  %V16F32 = fcmp one <16 x float> undef, undef

  %F64 = fcmp one double undef, undef
  %V2F64 = fcmp one <2 x double> undef, undef
  %V4F64 = fcmp one <4 x double> undef, undef
  %V8F64 = fcmp one <8 x double> undef, undef
  %V16F64 = fcmp one <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ord(i32 %arg) {
; SSE-LABEL: 'cmp_float_ord'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ord float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ord <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ord <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp ord <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp ord <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ord double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ord <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp ord <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp ord <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp ord <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_ord'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ord float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ord <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ord <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ord <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp ord <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ord double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ord <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ord <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp ord <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp ord <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ord'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ord float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ord <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ord <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ord <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp ord <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ord double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ord <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ord <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp ord <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp ord <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp ord float undef, undef
  %V2F32 = fcmp ord <2 x float> undef, undef
  %V4F32 = fcmp ord <4 x float> undef, undef
  %V8F32 = fcmp ord <8 x float> undef, undef
  %V16F32 = fcmp ord <16 x float> undef, undef

  %F64 = fcmp ord double undef, undef
  %V2F64 = fcmp ord <2 x double> undef, undef
  %V4F64 = fcmp ord <4 x double> undef, undef
  %V8F64 = fcmp ord <8 x double> undef, undef
  %V16F64 = fcmp ord <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_oge(i32 %arg) {
; SSE-LABEL: 'cmp_float_oge'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp oge float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp oge <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp oge <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp oge <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp oge <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp oge double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp oge <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp oge <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp oge <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp oge <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_oge'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp oge float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp oge <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp oge <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp oge <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp oge <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp oge double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp oge <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp oge <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp oge <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp oge <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_oge'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp oge float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp oge <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp oge <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp oge <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp oge <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp oge double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp oge <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp oge <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp oge <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp oge <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp oge float undef, undef
  %V2F32 = fcmp oge <2 x float> undef, undef
  %V4F32 = fcmp oge <4 x float> undef, undef
  %V8F32 = fcmp oge <8 x float> undef, undef
  %V16F32 = fcmp oge <16 x float> undef, undef

  %F64 = fcmp oge double undef, undef
  %V2F64 = fcmp oge <2 x double> undef, undef
  %V4F64 = fcmp oge <4 x double> undef, undef
  %V8F64 = fcmp oge <8 x double> undef, undef
  %V16F64 = fcmp oge <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ogt(i32 %arg) {
; SSE-LABEL: 'cmp_float_ogt'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ogt float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ogt <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ogt <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp ogt <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp ogt <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ogt double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ogt <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp ogt <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp ogt <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp ogt <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_ogt'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ogt float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ogt <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ogt <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ogt <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp ogt <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ogt double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ogt <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ogt <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp ogt <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp ogt <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ogt'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ogt float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ogt <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ogt <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ogt <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp ogt <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ogt double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ogt <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ogt <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp ogt <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp ogt <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp ogt float undef, undef
  %V2F32 = fcmp ogt <2 x float> undef, undef
  %V4F32 = fcmp ogt <4 x float> undef, undef
  %V8F32 = fcmp ogt <8 x float> undef, undef
  %V16F32 = fcmp ogt <16 x float> undef, undef

  %F64 = fcmp ogt double undef, undef
  %V2F64 = fcmp ogt <2 x double> undef, undef
  %V4F64 = fcmp ogt <4 x double> undef, undef
  %V8F64 = fcmp ogt <8 x double> undef, undef
  %V16F64 = fcmp ogt <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ole(i32 %arg) {
; SSE-LABEL: 'cmp_float_ole'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ole float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ole <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ole <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp ole <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp ole <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ole double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ole <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp ole <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp ole <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp ole <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_ole'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ole float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ole <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ole <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ole <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp ole <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ole double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ole <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ole <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp ole <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp ole <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ole'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ole float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ole <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ole <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ole <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp ole <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ole double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ole <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ole <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp ole <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp ole <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp ole float undef, undef
  %V2F32 = fcmp ole <2 x float> undef, undef
  %V4F32 = fcmp ole <4 x float> undef, undef
  %V8F32 = fcmp ole <8 x float> undef, undef
  %V16F32 = fcmp ole <16 x float> undef, undef

  %F64 = fcmp ole double undef, undef
  %V2F64 = fcmp ole <2 x double> undef, undef
  %V4F64 = fcmp ole <4 x double> undef, undef
  %V8F64 = fcmp ole <8 x double> undef, undef
  %V16F64 = fcmp ole <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_olt(i32 %arg) {
; SSE-LABEL: 'cmp_float_olt'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp olt float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp olt <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp olt <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp olt <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp olt <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp olt double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp olt <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp olt <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp olt <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp olt <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_olt'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp olt float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp olt <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp olt <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp olt <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp olt <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp olt double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp olt <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp olt <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp olt <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp olt <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_olt'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp olt float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp olt <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp olt <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp olt <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp olt <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp olt double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp olt <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp olt <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp olt <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp olt <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp olt float undef, undef
  %V2F32 = fcmp olt <2 x float> undef, undef
  %V4F32 = fcmp olt <4 x float> undef, undef
  %V8F32 = fcmp olt <8 x float> undef, undef
  %V16F32 = fcmp olt <16 x float> undef, undef

  %F64 = fcmp olt double undef, undef
  %V2F64 = fcmp olt <2 x double> undef, undef
  %V4F64 = fcmp olt <4 x double> undef, undef
  %V8F64 = fcmp olt <8 x double> undef, undef
  %V16F64 = fcmp olt <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ueq(i32 %arg) {
; SSE-LABEL: 'cmp_float_ueq'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ueq float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2F32 = fcmp ueq <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V4F32 = fcmp ueq <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V8F32 = fcmp ueq <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V16F32 = fcmp ueq <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ueq double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %V2F64 = fcmp ueq <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %V4F64 = fcmp ueq <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %V8F64 = fcmp ueq <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %V16F64 = fcmp ueq <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_ueq'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ueq float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ueq <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ueq <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ueq <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp ueq <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ueq double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ueq <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ueq <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp ueq <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp ueq <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ueq'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ueq float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ueq <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ueq <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ueq <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp ueq <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ueq double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ueq <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ueq <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp ueq <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp ueq <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp ueq float undef, undef
  %V2F32 = fcmp ueq <2 x float> undef, undef
  %V4F32 = fcmp ueq <4 x float> undef, undef
  %V8F32 = fcmp ueq <8 x float> undef, undef
  %V16F32 = fcmp ueq <16 x float> undef, undef

  %F64 = fcmp ueq double undef, undef
  %V2F64 = fcmp ueq <2 x double> undef, undef
  %V4F64 = fcmp ueq <4 x double> undef, undef
  %V8F64 = fcmp ueq <8 x double> undef, undef
  %V16F64 = fcmp ueq <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_une(i32 %arg) {
; SSE-LABEL: 'cmp_float_une'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp une float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp une <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp une <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp une <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp une <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp une double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp une <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp une <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp une <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp une <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_une'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp une float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp une <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp une <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp une <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp une <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp une double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp une <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp une <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp une <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp une <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_une'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp une float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp une <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp une <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp une <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp une <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp une double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp une <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp une <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp une <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp une <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp une float undef, undef
  %V2F32 = fcmp une <2 x float> undef, undef
  %V4F32 = fcmp une <4 x float> undef, undef
  %V8F32 = fcmp une <8 x float> undef, undef
  %V16F32 = fcmp une <16 x float> undef, undef

  %F64 = fcmp une double undef, undef
  %V2F64 = fcmp une <2 x double> undef, undef
  %V4F64 = fcmp une <4 x double> undef, undef
  %V8F64 = fcmp une <8 x double> undef, undef
  %V16F64 = fcmp une <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_uno(i32 %arg) {
; SSE-LABEL: 'cmp_float_uno'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp uno float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp uno <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp uno <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp uno <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp uno <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp uno double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp uno <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp uno <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp uno <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp uno <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_uno'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp uno float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp uno <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp uno <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp uno <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp uno <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp uno double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp uno <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp uno <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp uno <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp uno <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_uno'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp uno float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp uno <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp uno <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp uno <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp uno <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp uno double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp uno <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp uno <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp uno <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp uno <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp uno float undef, undef
  %V2F32 = fcmp uno <2 x float> undef, undef
  %V4F32 = fcmp uno <4 x float> undef, undef
  %V8F32 = fcmp uno <8 x float> undef, undef
  %V16F32 = fcmp uno <16 x float> undef, undef

  %F64 = fcmp uno double undef, undef
  %V2F64 = fcmp uno <2 x double> undef, undef
  %V4F64 = fcmp uno <4 x double> undef, undef
  %V8F64 = fcmp uno <8 x double> undef, undef
  %V16F64 = fcmp uno <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_uge(i32 %arg) {
; SSE-LABEL: 'cmp_float_uge'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp uge float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp uge <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp uge <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp uge <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp uge <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp uge double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp uge <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp uge <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp uge <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp uge <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_uge'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp uge float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp uge <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp uge <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp uge <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp uge <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp uge double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp uge <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp uge <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp uge <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp uge <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_uge'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp uge float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp uge <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp uge <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp uge <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp uge <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp uge double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp uge <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp uge <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp uge <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp uge <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp uge float undef, undef
  %V2F32 = fcmp uge <2 x float> undef, undef
  %V4F32 = fcmp uge <4 x float> undef, undef
  %V8F32 = fcmp uge <8 x float> undef, undef
  %V16F32 = fcmp uge <16 x float> undef, undef

  %F64 = fcmp uge double undef, undef
  %V2F64 = fcmp uge <2 x double> undef, undef
  %V4F64 = fcmp uge <4 x double> undef, undef
  %V8F64 = fcmp uge <8 x double> undef, undef
  %V16F64 = fcmp uge <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ugt(i32 %arg) {
; SSE-LABEL: 'cmp_float_ugt'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ugt float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ugt <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ugt <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp ugt <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp ugt <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ugt double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ugt <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp ugt <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp ugt <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp ugt <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_ugt'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ugt float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ugt <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ugt <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ugt <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp ugt <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ugt double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ugt <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ugt <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp ugt <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp ugt <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ugt'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ugt float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ugt <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ugt <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ugt <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp ugt <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ugt double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ugt <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ugt <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp ugt <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp ugt <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp ugt float undef, undef
  %V2F32 = fcmp ugt <2 x float> undef, undef
  %V4F32 = fcmp ugt <4 x float> undef, undef
  %V8F32 = fcmp ugt <8 x float> undef, undef
  %V16F32 = fcmp ugt <16 x float> undef, undef

  %F64 = fcmp ugt double undef, undef
  %V2F64 = fcmp ugt <2 x double> undef, undef
  %V4F64 = fcmp ugt <4 x double> undef, undef
  %V8F64 = fcmp ugt <8 x double> undef, undef
  %V16F64 = fcmp ugt <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ule(i32 %arg) {
; SSE-LABEL: 'cmp_float_ule'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ule float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ule <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ule <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp ule <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp ule <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ule double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ule <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp ule <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp ule <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp ule <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_ule'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ule float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ule <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ule <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ule <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp ule <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ule double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ule <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ule <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp ule <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp ule <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ule'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ule float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ule <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ule <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ule <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp ule <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ule double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ule <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ule <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp ule <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp ule <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp ule float undef, undef
  %V2F32 = fcmp ule <2 x float> undef, undef
  %V4F32 = fcmp ule <4 x float> undef, undef
  %V8F32 = fcmp ule <8 x float> undef, undef
  %V16F32 = fcmp ule <16 x float> undef, undef

  %F64 = fcmp ule double undef, undef
  %V2F64 = fcmp ule <2 x double> undef, undef
  %V4F64 = fcmp ule <4 x double> undef, undef
  %V8F64 = fcmp ule <8 x double> undef, undef
  %V16F64 = fcmp ule <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_ult(i32 %arg) {
; SSE-LABEL: 'cmp_float_ult'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ult float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ult <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ult <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp ult <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp ult <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ult double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ult <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp ult <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp ult <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp ult <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_ult'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ult float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ult <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ult <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ult <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp ult <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ult double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ult <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ult <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp ult <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp ult <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_ult'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp ult float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp ult <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp ult <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp ult <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp ult <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp ult double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp ult <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp ult <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp ult <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp ult <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp ult float undef, undef
  %V2F32 = fcmp ult <2 x float> undef, undef
  %V4F32 = fcmp ult <4 x float> undef, undef
  %V8F32 = fcmp ult <8 x float> undef, undef
  %V16F32 = fcmp ult <16 x float> undef, undef

  %F64 = fcmp ult double undef, undef
  %V2F64 = fcmp ult <2 x double> undef, undef
  %V4F64 = fcmp ult <4 x double> undef, undef
  %V8F64 = fcmp ult <8 x double> undef, undef
  %V16F64 = fcmp ult <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_false(i32 %arg) {
; SSE-LABEL: 'cmp_float_false'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp false float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp false <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp false <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp false <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp false <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp false double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp false <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp false <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp false <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp false <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_false'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp false float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp false <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp false <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp false <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp false <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp false double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp false <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp false <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp false <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp false <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_false'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp false float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp false <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp false <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp false <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp false <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp false double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp false <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp false <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp false <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp false <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp false float undef, undef
  %V2F32 = fcmp false <2 x float> undef, undef
  %V4F32 = fcmp false <4 x float> undef, undef
  %V8F32 = fcmp false <8 x float> undef, undef
  %V16F32 = fcmp false <16 x float> undef, undef

  %F64 = fcmp false double undef, undef
  %V2F64 = fcmp false <2 x double> undef, undef
  %V4F64 = fcmp false <4 x double> undef, undef
  %V8F64 = fcmp false <8 x double> undef, undef
  %V16F64 = fcmp false <16 x double> undef, undef

  ret i32 undef
}

define i32 @cmp_float_true(i32 %arg) {
; SSE-LABEL: 'cmp_float_true'
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp true float undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp true <2 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp true <4 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F32 = fcmp true <8 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F32 = fcmp true <16 x float> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp true double undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp true <2 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V4F64 = fcmp true <4 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V8F64 = fcmp true <8 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %V16F64 = fcmp true <16 x double> undef, undef
; SSE-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX-LABEL: 'cmp_float_true'
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp true float undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp true <2 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp true <4 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp true <8 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F32 = fcmp true <16 x float> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp true double undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp true <2 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp true <4 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V8F64 = fcmp true <8 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %V16F64 = fcmp true <16 x double> undef, undef
; AVX-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
; AVX512-LABEL: 'cmp_float_true'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F32 = fcmp true float undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F32 = fcmp true <2 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F32 = fcmp true <4 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F32 = fcmp true <8 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V16F32 = fcmp true <16 x float> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %F64 = fcmp true double undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V2F64 = fcmp true <2 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V4F64 = fcmp true <4 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %V8F64 = fcmp true <8 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %V16F64 = fcmp true <16 x double> undef, undef
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: ret i32 undef
;
  %F32 = fcmp true float undef, undef
  %V2F32 = fcmp true <2 x float> undef, undef
  %V4F32 = fcmp true <4 x float> undef, undef
  %V8F32 = fcmp true <8 x float> undef, undef
  %V16F32 = fcmp true <16 x float> undef, undef

  %F64 = fcmp true double undef, undef
  %V2F64 = fcmp true <2 x double> undef, undef
  %V4F64 = fcmp true <4 x double> undef, undef
  %V8F64 = fcmp true <8 x double> undef, undef
  %V16F64 = fcmp true <16 x double> undef, undef

  ret i32 undef
}
