; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse2 | FileCheck %s --check-prefixes=SSE2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+ssse3 | FileCheck %s --check-prefixes=SSSE3
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+sse4.2 | FileCheck %s --check-prefixes=SSE42
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx2 | FileCheck %s --check-prefixes=AVX2
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f | FileCheck %s --check-prefixes=AVX512,AVX512F
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX512,AVX512BW
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mattr=+avx512f,+avx512dq | FileCheck %s --check-prefixes=AVX512,AVX512DQ
;
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mcpu=slm | FileCheck %s --check-prefixes=SLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mcpu=goldmont | FileCheck %s --check-prefixes=GLM
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mcpu=btver2 | FileCheck %s --check-prefixes=AVX1
; RUN: opt < %s -passes="print<cost-model>" 2>&1 -disable-output -mtriple=x86_64-apple-macosx10.8.0 -mcpu=knl | FileCheck %s --check-prefixes=AVX512,AVX512F

;
; mul vXi8 -> mXi64
;

define void @mul_sext_vXi8(<2 x i8> %a2, <2 x i8> %b2, <4 x i8> %a4, <4 x i8> %b4, <8 x i8> %a8, <8 x i8> %b8, <16 x i8> %a16, <16 x i8> %b16, <32 x i8> %a32, <32 x i8> %b32, <64 x i8> %a64, <64 x i8> %b64)  {
; SSE2-LABEL: 'mul_sext_vXi8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_sext_vXi8'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_sext_vXi8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_sext_vXi8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_sext_vXi8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'mul_sext_vXi8'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512BW-LABEL: 'mul_sext_vXi8'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'mul_sext_vXi8'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_sext_vXi8'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_sext_vXi8'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i8> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i8> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i8> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i8> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i8> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i8> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = sext <2 x i8> %a2 to <2 x i64>
  %xb2 = sext <2 x i8> %b2 to <2 x i64>
  %xa4 = sext <4 x i8> %a4 to <4 x i64>
  %xb4 = sext <4 x i8> %b4 to <4 x i64>
  %xa8 = sext <8 x i8> %a8 to <8 x i64>
  %xb8 = sext <8 x i8> %b8 to <8 x i64>
  %xa16 = sext <16 x i8> %a16 to <16 x i64>
  %xb16 = sext <16 x i8> %b16 to <16 x i64>
  %xa32 = sext <32 x i8> %a32 to <32 x i64>
  %xb32 = sext <32 x i8> %b32 to <32 x i64>
  %xa64 = sext <64 x i8> %a64 to <64 x i64>
  %xb64 = sext <64 x i8> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

define void @mul_zext_vXi8(<2 x i8> %a2, <2 x i8> %b2, <4 x i8> %a4, <4 x i8> %b4, <8 x i8> %a8, <8 x i8> %b8, <16 x i8> %a16, <16 x i8> %b16, <32 x i8> %a32, <32 x i8> %b32, <64 x i8> %a64, <64 x i8> %b64)  {
; SSE2-LABEL: 'mul_zext_vXi8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_zext_vXi8'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_zext_vXi8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_zext_vXi8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_zext_vXi8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512-LABEL: 'mul_zext_vXi8'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_zext_vXi8'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_zext_vXi8'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i8> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i8> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i8> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i8> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i8> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i8> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = zext <2 x i8> %a2 to <2 x i64>
  %xb2 = zext <2 x i8> %b2 to <2 x i64>
  %xa4 = zext <4 x i8> %a4 to <4 x i64>
  %xb4 = zext <4 x i8> %b4 to <4 x i64>
  %xa8 = zext <8 x i8> %a8 to <8 x i64>
  %xb8 = zext <8 x i8> %b8 to <8 x i64>
  %xa16 = zext <16 x i8> %a16 to <16 x i64>
  %xb16 = zext <16 x i8> %b16 to <16 x i64>
  %xa32 = zext <32 x i8> %a32 to <32 x i64>
  %xb32 = zext <32 x i8> %b32 to <32 x i64>
  %xa64 = zext <64 x i8> %a64 to <64 x i64>
  %xb64 = zext <64 x i8> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

define void @mul_sext_zext_vXi8(<2 x i8> %a2, <2 x i8> %b2, <4 x i8> %a4, <4 x i8> %b4, <8 x i8> %a8, <8 x i8> %b8, <16 x i8> %a16, <16 x i8> %b16, <32 x i8> %a32, <32 x i8> %b32, <64 x i8> %a64, <64 x i8> %b64)  {
; SSE2-LABEL: 'mul_sext_zext_vXi8'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_sext_zext_vXi8'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 128 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_sext_zext_vXi8'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_sext_zext_vXi8'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 25 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 50 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_sext_zext_vXi8'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'mul_sext_zext_vXi8'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512BW-LABEL: 'mul_sext_zext_vXi8'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'mul_sext_zext_vXi8'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 15 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_sext_zext_vXi8'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_sext_zext_vXi8'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i8> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i8> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i8> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i8> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i8> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i8> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i8> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i8> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i8> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i8> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i8> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i8> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = sext <2 x i8> %a2 to <2 x i64>
  %xb2 = zext <2 x i8> %b2 to <2 x i64>
  %xa4 = sext <4 x i8> %a4 to <4 x i64>
  %xb4 = zext <4 x i8> %b4 to <4 x i64>
  %xa8 = sext <8 x i8> %a8 to <8 x i64>
  %xb8 = zext <8 x i8> %b8 to <8 x i64>
  %xa16 = sext <16 x i8> %a16 to <16 x i64>
  %xb16 = zext <16 x i8> %b16 to <16 x i64>
  %xa32 = sext <32 x i8> %a32 to <32 x i64>
  %xb32 = zext <32 x i8> %b32 to <32 x i64>
  %xa64 = sext <64 x i8> %a64 to <64 x i64>
  %xb64 = zext <64 x i8> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

;
; mul vXi16 -> mXi64
;

define void @mul_sext_vXi16(<2 x i16> %a2, <2 x i16> %b2, <4 x i16> %a4, <4 x i16> %b4, <8 x i16> %a8, <8 x i16> %b8, <16 x i16> %a16, <16 x i16> %b16, <32 x i16> %a32, <32 x i16> %b32, <64 x i16> %a64, <64 x i16> %b64)  {
; SSE2-LABEL: 'mul_sext_vXi16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_sext_vXi16'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_sext_vXi16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_sext_vXi16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_sext_vXi16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'mul_sext_vXi16'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512BW-LABEL: 'mul_sext_vXi16'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'mul_sext_vXi16'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_sext_vXi16'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_sext_vXi16'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i16> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i16> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i16> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i16> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i16> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i16> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = sext <2 x i16> %a2 to <2 x i64>
  %xb2 = sext <2 x i16> %b2 to <2 x i64>
  %xa4 = sext <4 x i16> %a4 to <4 x i64>
  %xb4 = sext <4 x i16> %b4 to <4 x i64>
  %xa8 = sext <8 x i16> %a8 to <8 x i64>
  %xb8 = sext <8 x i16> %b8 to <8 x i64>
  %xa16 = sext <16 x i16> %a16 to <16 x i64>
  %xb16 = sext <16 x i16> %b16 to <16 x i64>
  %xa32 = sext <32 x i16> %a32 to <32 x i64>
  %xb32 = sext <32 x i16> %b32 to <32 x i64>
  %xa64 = sext <64 x i16> %a64 to <64 x i64>
  %xb64 = sext <64 x i16> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

define void @mul_zext_vXi16(<2 x i16> %a2, <2 x i16> %b2, <4 x i16> %a4, <4 x i16> %b4, <8 x i16> %a8, <8 x i16> %b8, <16 x i16> %a16, <16 x i16> %b16, <32 x i16> %a32, <32 x i16> %b32, <64 x i16> %a64, <64 x i16> %b64)  {
; SSE2-LABEL: 'mul_zext_vXi16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_zext_vXi16'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_zext_vXi16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_zext_vXi16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_zext_vXi16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512-LABEL: 'mul_zext_vXi16'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_zext_vXi16'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_zext_vXi16'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i16> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i16> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i16> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i16> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i16> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i16> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = zext <2 x i16> %a2 to <2 x i64>
  %xb2 = zext <2 x i16> %b2 to <2 x i64>
  %xa4 = zext <4 x i16> %a4 to <4 x i64>
  %xb4 = zext <4 x i16> %b4 to <4 x i64>
  %xa8 = zext <8 x i16> %a8 to <8 x i64>
  %xb8 = zext <8 x i16> %b8 to <8 x i64>
  %xa16 = zext <16 x i16> %a16 to <16 x i64>
  %xb16 = zext <16 x i16> %b16 to <16 x i64>
  %xa32 = zext <32 x i16> %a32 to <32 x i64>
  %xb32 = zext <32 x i16> %b32 to <32 x i64>
  %xa64 = zext <64 x i16> %a64 to <64 x i64>
  %xb64 = zext <64 x i16> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

define void @mul_sext_zext_vXi16(<2 x i16> %a2, <2 x i16> %b2, <4 x i16> %a4, <4 x i16> %b4, <8 x i16> %a8, <8 x i16> %b8, <16 x i16> %a16, <16 x i16> %b16, <32 x i16> %a32, <32 x i16> %b32, <64 x i16> %a64, <64 x i16> %b64)  {
; SSE2-LABEL: 'mul_sext_zext_vXi16'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_sext_zext_vXi16'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_sext_zext_vXi16'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_sext_zext_vXi16'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 13 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 26 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 52 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_sext_zext_vXi16'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 36 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'mul_sext_zext_vXi16'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512BW-LABEL: 'mul_sext_zext_vXi16'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'mul_sext_zext_vXi16'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_sext_zext_vXi16'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_sext_zext_vXi16'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i16> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i16> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i16> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i16> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i16> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i16> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i16> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i16> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i16> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i16> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i16> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i16> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = sext <2 x i16> %a2 to <2 x i64>
  %xb2 = zext <2 x i16> %b2 to <2 x i64>
  %xa4 = sext <4 x i16> %a4 to <4 x i64>
  %xb4 = zext <4 x i16> %b4 to <4 x i64>
  %xa8 = sext <8 x i16> %a8 to <8 x i64>
  %xb8 = zext <8 x i16> %b8 to <8 x i64>
  %xa16 = sext <16 x i16> %a16 to <16 x i64>
  %xb16 = zext <16 x i16> %b16 to <16 x i64>
  %xa32 = sext <32 x i16> %a32 to <32 x i64>
  %xb32 = zext <32 x i16> %b32 to <32 x i64>
  %xa64 = sext <64 x i16> %a64 to <64 x i64>
  %xb64 = zext <64 x i16> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

;
; mul vXi32 -> mXi64
;

define void @mul_sext_vXi32(<2 x i32> %a2, <2 x i32> %b2, <4 x i32> %a4, <4 x i32> %b4, <8 x i32> %a8, <8 x i32> %b8, <16 x i32> %a16, <16 x i32> %b16, <32 x i32> %a32, <32 x i32> %b32, <64 x i32> %a64, <64 x i32> %b64)  {
; SSE2-LABEL: 'mul_sext_vXi32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_sext_vXi32'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_sext_vXi32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_sext_vXi32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_sext_vXi32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'mul_sext_vXi32'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512BW-LABEL: 'mul_sext_vXi32'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'mul_sext_vXi32'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_sext_vXi32'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_sext_vXi32'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = sext <2 x i32> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = sext <4 x i32> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = sext <8 x i32> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = sext <16 x i32> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = sext <32 x i32> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = sext <64 x i32> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = sext <2 x i32> %a2 to <2 x i64>
  %xb2 = sext <2 x i32> %b2 to <2 x i64>
  %xa4 = sext <4 x i32> %a4 to <4 x i64>
  %xb4 = sext <4 x i32> %b4 to <4 x i64>
  %xa8 = sext <8 x i32> %a8 to <8 x i64>
  %xb8 = sext <8 x i32> %b8 to <8 x i64>
  %xa16 = sext <16 x i32> %a16 to <16 x i64>
  %xb16 = sext <16 x i32> %b16 to <16 x i64>
  %xa32 = sext <32 x i32> %a32 to <32 x i64>
  %xb32 = sext <32 x i32> %b32 to <32 x i64>
  %xa64 = sext <64 x i32> %a64 to <64 x i64>
  %xb64 = sext <64 x i32> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

define void @mul_zext_vXi32(<2 x i32> %a2, <2 x i32> %b2, <4 x i32> %a4, <4 x i32> %b4, <8 x i32> %a8, <8 x i32> %b8, <16 x i32> %a16, <16 x i32> %b16, <32 x i32> %a32, <32 x i32> %b32, <64 x i32> %a64, <64 x i32> %b64)  {
; SSE2-LABEL: 'mul_zext_vXi32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_zext_vXi32'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_zext_vXi32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_zext_vXi32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_zext_vXi32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512-LABEL: 'mul_zext_vXi32'
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_zext_vXi32'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_zext_vXi32'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = zext <2 x i32> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = zext <4 x i32> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = zext <8 x i32> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = zext <16 x i32> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = zext <32 x i32> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = zext <64 x i32> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = zext <2 x i32> %a2 to <2 x i64>
  %xb2 = zext <2 x i32> %b2 to <2 x i64>
  %xa4 = zext <4 x i32> %a4 to <4 x i64>
  %xb4 = zext <4 x i32> %b4 to <4 x i64>
  %xa8 = zext <8 x i32> %a8 to <8 x i64>
  %xb8 = zext <8 x i32> %b8 to <8 x i64>
  %xa16 = zext <16 x i32> %a16 to <16 x i64>
  %xb16 = zext <16 x i32> %b16 to <16 x i64>
  %xa32 = zext <32 x i32> %a32 to <32 x i64>
  %xb32 = zext <32 x i32> %b32 to <32 x i64>
  %xa64 = zext <64 x i32> %a64 to <64 x i64>
  %xb64 = zext <64 x i32> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}

define void @mul_sext_zext_vXi32(<2 x i32> %a2, <2 x i32> %b2, <4 x i32> %a4, <4 x i32> %b4, <8 x i32> %a8, <8 x i32> %b8, <16 x i32> %a16, <16 x i32> %b16, <32 x i32> %a32, <32 x i32> %b32, <64 x i32> %a64, <64 x i32> %b64)  {
; SSE2-LABEL: 'mul_sext_zext_vXi32'
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SSE2-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE2-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE2-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE2-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE2-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE2-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSSE3-LABEL: 'mul_sext_zext_vXi32'
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 64 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 112 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 224 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSSE3-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SSE42-LABEL: 'mul_sext_zext_vXi32'
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SSE42-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SSE42-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SSE42-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SSE42-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SSE42-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SSE42-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SSE42-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX1-LABEL: 'mul_sext_zext_vXi32'
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 14 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 28 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 56 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX1-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX1-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX1-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX1-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX1-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX1-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX1-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX2-LABEL: 'mul_sext_zext_vXi32'
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 20 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 40 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX2-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX2-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX2-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX2-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX2-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX2-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512F-LABEL: 'mul_sext_zext_vXi32'
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512F-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512BW-LABEL: 'mul_sext_zext_vXi32'
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512BW-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; AVX512DQ-LABEL: 'mul_sext_zext_vXi32'
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; AVX512DQ-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; SLM-LABEL: 'mul_sext_zext_vXi32'
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; SLM-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; SLM-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; SLM-NEXT:  Cost Model: Found an estimated cost of 68 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; SLM-NEXT:  Cost Model: Found an estimated cost of 136 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; SLM-NEXT:  Cost Model: Found an estimated cost of 272 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; SLM-NEXT:  Cost Model: Found an estimated cost of 544 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; SLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; GLM-LABEL: 'mul_sext_zext_vXi32'
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xa2 = sext <2 x i32> %a2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %xb2 = zext <2 x i32> %b2 to <2 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xa4 = sext <4 x i32> %a4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %xb4 = zext <4 x i32> %b4 to <4 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xa8 = sext <8 x i32> %a8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %xb8 = zext <8 x i32> %b8 to <8 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xa16 = sext <16 x i32> %a16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 8 for instruction: %xb16 = zext <16 x i32> %b16 to <16 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xa32 = sext <32 x i32> %a32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 16 for instruction: %xb32 = zext <32 x i32> %b32 to <32 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xa64 = sext <64 x i32> %a64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 32 for instruction: %xb64 = zext <64 x i32> %b64 to <64 x i64>
; GLM-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %res2 = mul <2 x i64> %xa2, %xb2
; GLM-NEXT:  Cost Model: Found an estimated cost of 12 for instruction: %res4 = mul <4 x i64> %xa4, %xb4
; GLM-NEXT:  Cost Model: Found an estimated cost of 24 for instruction: %res8 = mul <8 x i64> %xa8, %xb8
; GLM-NEXT:  Cost Model: Found an estimated cost of 48 for instruction: %res16 = mul <16 x i64> %xa16, %xb16
; GLM-NEXT:  Cost Model: Found an estimated cost of 96 for instruction: %res32 = mul <32 x i64> %xa32, %xb32
; GLM-NEXT:  Cost Model: Found an estimated cost of 192 for instruction: %res64 = mul <64 x i64> %xa64, %xb64
; GLM-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %xa2 = sext <2 x i32> %a2 to <2 x i64>
  %xb2 = zext <2 x i32> %b2 to <2 x i64>
  %xa4 = sext <4 x i32> %a4 to <4 x i64>
  %xb4 = zext <4 x i32> %b4 to <4 x i64>
  %xa8 = sext <8 x i32> %a8 to <8 x i64>
  %xb8 = zext <8 x i32> %b8 to <8 x i64>
  %xa16 = sext <16 x i32> %a16 to <16 x i64>
  %xb16 = zext <16 x i32> %b16 to <16 x i64>
  %xa32 = sext <32 x i32> %a32 to <32 x i64>
  %xb32 = zext <32 x i32> %b32 to <32 x i64>
  %xa64 = sext <64 x i32> %a64 to <64 x i64>
  %xb64 = zext <64 x i32> %b64 to <64 x i64>
  %res2 = mul <2 x i64> %xa2, %xb2
  %res4 = mul <4 x i64> %xa4, %xb4
  %res8 = mul <8 x i64> %xa8, %xb8
  %res16 = mul <16 x i64> %xa16, %xb16
  %res32 = mul <32 x i64> %xa32, %xb32
  %res64 = mul <64 x i64> %xa64, %xb64
  ret void
}
