; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

%my_subtype = type <vscale x 2 x double>
%my_type = type [3 x %my_subtype]

define void @array_1D(ptr %addr) #0 {
; CHECK-LABEL: array_1D:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x0, #2, mul vl]
; CHECK-NEXT:    ld1d { z2.d }, p0/z, [x0, #1, mul vl]
; CHECK-NEXT:    st1d { z0.d }, p0, [sp]
; CHECK-NEXT:    st1d { z1.d }, p0, [sp, #2, mul vl]
; CHECK-NEXT:    st1d { z2.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %ret = alloca %my_type, align 8
  %val = load %my_type, ptr %addr
  store %my_type %val, ptr %ret, align 8
  ret void
}

define %my_subtype @array_1D_extract(ptr %addr) #0 {
; CHECK-LABEL: array_1D_extract:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %ret = alloca %my_type, align 8
  %val = load %my_type, ptr %addr
  %elt = extractvalue %my_type %val, 1
  ret %my_subtype %elt
}

define void @array_1D_insert(ptr %addr, %my_subtype %elt) #0 {
; CHECK-LABEL: array_1D_insert:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-3
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 24 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x0, #2, mul vl]
; CHECK-NEXT:    ld1d { z2.d }, p0/z, [x0]
; CHECK-NEXT:    st1d { z0.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    st1d { z1.d }, p0, [sp, #2, mul vl]
; CHECK-NEXT:    st1d { z2.d }, p0, [sp]
; CHECK-NEXT:    addvl sp, sp, #3
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %ret = alloca %my_type, align 8
  %val = load %my_type, ptr %addr
  %ins = insertvalue %my_type %val, %my_subtype %elt, 1
  store %my_type %ins, ptr %ret, align 8
  ret void
}

define void @array_2D(ptr %addr) #0 {
; CHECK-LABEL: array_2D:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x29, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    addvl sp, sp, #-6
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0c, 0x8f, 0x00, 0x11, 0x10, 0x22, 0x11, 0x30, 0x92, 0x2e, 0x00, 0x1e, 0x22 // sp + 16 + 48 * VG
; CHECK-NEXT:    .cfi_offset w29, -16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    ld1d { z1.d }, p0/z, [x0, #5, mul vl]
; CHECK-NEXT:    ld1d { z2.d }, p0/z, [x0, #1, mul vl]
; CHECK-NEXT:    ld1d { z3.d }, p0/z, [x0, #4, mul vl]
; CHECK-NEXT:    ld1d { z4.d }, p0/z, [x0, #2, mul vl]
; CHECK-NEXT:    ld1d { z5.d }, p0/z, [x0, #3, mul vl]
; CHECK-NEXT:    st1d { z0.d }, p0, [sp]
; CHECK-NEXT:    st1d { z1.d }, p0, [sp, #5, mul vl]
; CHECK-NEXT:    st1d { z3.d }, p0, [sp, #4, mul vl]
; CHECK-NEXT:    st1d { z5.d }, p0, [sp, #3, mul vl]
; CHECK-NEXT:    st1d { z4.d }, p0, [sp, #2, mul vl]
; CHECK-NEXT:    st1d { z2.d }, p0, [sp, #1, mul vl]
; CHECK-NEXT:    addvl sp, sp, #6
; CHECK-NEXT:    ldr x29, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %ret = alloca [2 x %my_type], align 8
  %val = load [2 x %my_type], ptr %addr
  store [2 x %my_type] %val, ptr %ret, align 8
  ret void
}

attributes #0 = { "target-features"="+sve" }
