; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; Disabling NEON used to incorrectly emit FABD instructions which resulted in
; an assertion in verifyInstructionPredicates() while emitting the output.
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16,+neon < %s | FileCheck %s --check-prefix NEON-ENABLED
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16,-neon < %s | FileCheck %s --check-prefix NEON-DISABLED
; Note: We need to use -filetype=obj to trigger verifyInstructionPredicates()
; checks since it is not called when emitting assembly output.
; RUN: llc -mtriple=aarch64 -mattr=+fullfp16,-neon -o /dev/null %s -filetype=obj

declare half @llvm.fabs.f16(half)
declare float @llvm.fabs.f32(float)
declare double @llvm.fabs.f64(double)

define half @fabd16(half %f1, half %f2) {
; NEON-ENABLED-LABEL: fabd16:
; NEON-ENABLED:       // %bb.0:
; NEON-ENABLED-NEXT:    fabd h0, h0, h1
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: fabd16:
; NEON-DISABLED:       // %bb.0:
; NEON-DISABLED-NEXT:    fsub h0, h0, h1
; NEON-DISABLED-NEXT:    fabs h0, h0
; NEON-DISABLED-NEXT:    ret
  %sub = fsub half %f1, %f2
  %abs = tail call half @llvm.fabs.f16(half %sub)
  ret half %abs
}

define float @fabd32(float %f1, float %f2) {
; NEON-ENABLED-LABEL: fabd32:
; NEON-ENABLED:       // %bb.0:
; NEON-ENABLED-NEXT:    fabd s0, s0, s1
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: fabd32:
; NEON-DISABLED:       // %bb.0:
; NEON-DISABLED-NEXT:    fsub s0, s0, s1
; NEON-DISABLED-NEXT:    fabs s0, s0
; NEON-DISABLED-NEXT:    ret
  %sub = fsub float %f1, %f2
  %abs = tail call float @llvm.fabs.f32(float %sub)
  ret float %abs
}

define double @fabd64(double %f1, double %f2) {
; NEON-ENABLED-LABEL: fabd64:
; NEON-ENABLED:       // %bb.0:
; NEON-ENABLED-NEXT:    fabd d0, d0, d1
; NEON-ENABLED-NEXT:    ret
;
; NEON-DISABLED-LABEL: fabd64:
; NEON-DISABLED:       // %bb.0:
; NEON-DISABLED-NEXT:    fsub d0, d0, d1
; NEON-DISABLED-NEXT:    fabs d0, d0
; NEON-DISABLED-NEXT:    ret
  %sub = fsub double %f1, %f2
  %abs = tail call double @llvm.fabs.f64(double %sub)
  ret double %abs
}
