; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6,GFX6-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GCN,GFX11,GFX11-SDAG %s

; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GFX6,GFX6-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefixes=GCN,GFX8,GFX8-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefixes=GCN,GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 < %s | FileCheck -check-prefixes=GCN,GFX11,GFX11-GISEL %s

define float @test_ldexp_f32_i32(ptr addrspace(1) %out, float %a, i32 %b) {
; GFX6-LABEL: test_ldexp_f32_i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v3
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_ldexp_f32_i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ldexp_f32 v0, v2, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_ldexp_f32_i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ldexp_f32 v0, v2, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_f32_i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = call float @llvm.ldexp.f32.i32(float %a, i32 %b)
  ret float %result
}

define <2 x float> @test_ldexp_v2f32_v2i32(ptr addrspace(1) %out, <2 x float> %a, <2 x i32> %b) {
; GFX6-LABEL: test_ldexp_v2f32_v2i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v4
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v3, v5
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_ldexp_v2f32_v2i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX8-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_ldexp_v2f32_v2i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX9-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_v2f32_v2i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v4
; GFX11-NEXT:    v_ldexp_f32 v1, v3, v5
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float> %a, <2 x i32> %b)
  ret <2 x float> %result
}

define <3 x float> @test_ldexp_v3f32_v3i32(ptr addrspace(1) %out, <3 x float> %a, <3 x i32> %b) {
; GFX6-LABEL: test_ldexp_v3f32_v3i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v5
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v3, v6
; GFX6-NEXT:    v_ldexp_f32_e32 v2, v4, v7
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_ldexp_v3f32_v3i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX8-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX8-NEXT:    v_ldexp_f32 v2, v4, v7
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_ldexp_v3f32_v3i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX9-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX9-NEXT:    v_ldexp_f32 v2, v4, v7
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_v3f32_v3i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v5
; GFX11-NEXT:    v_ldexp_f32 v1, v3, v6
; GFX11-NEXT:    v_ldexp_f32 v2, v4, v7
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x float> @llvm.ldexp.v3f32.v3i32(<3 x float> %a, <3 x i32> %b)
  ret <3 x float> %result
}

define <4 x float> @test_ldexp_v4f32_v4i32(ptr addrspace(1) %out, <4 x float> %a, <4 x i32> %b) {
; GFX6-LABEL: test_ldexp_v4f32_v4i32:
; GFX6:       ; %bb.0:
; GFX6-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-NEXT:    v_ldexp_f32_e32 v0, v2, v6
; GFX6-NEXT:    v_ldexp_f32_e32 v1, v3, v7
; GFX6-NEXT:    v_ldexp_f32_e32 v2, v4, v8
; GFX6-NEXT:    v_ldexp_f32_e32 v3, v5, v9
; GFX6-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_ldexp_v4f32_v4i32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX8-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX8-NEXT:    v_ldexp_f32 v2, v4, v8
; GFX8-NEXT:    v_ldexp_f32 v3, v5, v9
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_ldexp_v4f32_v4i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX9-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX9-NEXT:    v_ldexp_f32 v2, v4, v8
; GFX9-NEXT:    v_ldexp_f32 v3, v5, v9
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_v4f32_v4i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f32 v0, v2, v6
; GFX11-NEXT:    v_ldexp_f32 v1, v3, v7
; GFX11-NEXT:    v_ldexp_f32 v2, v4, v8
; GFX11-NEXT:    v_ldexp_f32 v3, v5, v9
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x float> @llvm.ldexp.v4f32.v4i32(<4 x float> %a, <4 x i32> %b)
  ret <4 x float> %result
}

define double @test_ldexp_f64_i32(double %a, i32 %b) {
; GCN-LABEL: test_ldexp_f64_i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call double @llvm.ldexp.f64.i32(double %a, i32 %b)
  ret double %result
}

define <2 x double> @test_ldexp_v2f64_v2i32(<2 x double> %a, <2 x i32> %b) {
; GCN-LABEL: test_ldexp_v2f64_v2i32:
; GCN:       ; %bb.0:
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; GCN-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v5
; GCN-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x double> @llvm.ldexp.v2f64.v2i32(<2 x double> %a, <2 x i32> %b)
  ret <2 x double> %result
}

; Broken for DAG
; define float @test_ldexp_f32_i16(float %a, i16 %b) {
;   %result = call float @llvm.ldexp.f32.i16(float %a, i16 %b)
;   ret float %result
; }

; FIXME: Should be able to truncate to i32
; define float @test_ldexp_f32_i64(float %a, i64 %b) {
;   %result = call float @llvm.ldexp.f32.i64(float %a, i64 %b)
;   ret float %result
; }

; define <2 x float> @test_ldexp_v2f32_v2i16(<2 x float> %a, <2 x i16> %b) {
;   %result = call <2 x float> @llvm.ldexp.v2f32.v2i16(<2 x float> %a, <2 x i16> %b)
;   ret <2 x float> %result
; }

; FIXME: Should be able to truncate to i32
; define <2 x float> @test_ldexp_v2f32_v2i64(<2 x float> %a, <2 x i64> %b) {
;   %result = call <2 x float> @llvm.ldexp.v2f32.v2i64(<2 x float> %a, <2 x i64> %b)
;   ret <2 x float> %result
; }

define half @test_ldexp_f16_i8(half %a, i8 %b) {
; GFX6-SDAG-LABEL: test_ldexp_f16_i8:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_ldexp_f16_i8:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_ldexp_f16_sdwa v0, v0, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_ldexp_f16_i8:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f16_sdwa v0, v0, sext(v1) dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:BYTE_0
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_ldexp_f16_i8:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_f16_i8:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_ldexp_f16_i8:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX8-GISEL-NEXT:    v_med3_i32 v1, v1, v2, v3
; GFX8-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_ldexp_f16_i8:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v1, v1, v2, v3
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_ldexp_f16_i8:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 8
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v2
; GFX11-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call half @llvm.ldexp.f16.i8(half %a, i8 %b)
  ret half %result
}

define half @test_ldexp_f16_i16(half %a, i16 %b) {
; GFX6-SDAG-LABEL: test_ldexp_f16_i16:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_ldexp_f16_i16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_ldexp_f16_i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_ldexp_f16_i16:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_f16_i16:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_bfe_i32 v1, v1, 0, 16
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call half @llvm.ldexp.f16.i16(half %a, i16 %b)
  ret half %result
}

define half @test_ldexp_f16_i32(half %a, i32 %b) {
; GFX6-SDAG-LABEL: test_ldexp_f16_i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_ldexp_f16_i32:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    s_movk_i32 s4, 0x8000
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX8-SDAG-NEXT:    v_med3_i32 v1, v1, s4, v2
; GFX8-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_ldexp_f16_i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x8000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX9-SDAG-NEXT:    v_med3_i32 v1, v1, s4, v2
; GFX9-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_ldexp_f16_i32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_movk_i32 s0, 0x8000
; GFX11-SDAG-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_med3_i32 v1, v1, s0, 0x7fff
; GFX11-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_f16_i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_ldexp_f16_i32:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX8-GISEL-NEXT:    v_med3_i32 v1, v1, v2, v3
; GFX8-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_ldexp_f16_i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v2, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v1, v1, v2, v3
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_ldexp_f16_i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v2, 0x7fff
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v2
; GFX11-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call half @llvm.ldexp.f16.i32(half %a, i32 %b)
  ret half %result
}

define <2 x half> @test_ldexp_v2f16_v2i32(<2 x half> %a, <2 x i32> %b) {
; GFX6-SDAG-LABEL: test_ldexp_v2f16_v2i32:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v1, v1, v3
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_ldexp_v2f16_v2i32:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    s_movk_i32 s4, 0x8000
; GFX8-SDAG-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX8-SDAG-NEXT:    v_med3_i32 v2, v2, s4, v3
; GFX8-SDAG-NEXT:    v_med3_i32 v1, v1, s4, v3
; GFX8-SDAG-NEXT:    v_ldexp_f16_sdwa v2, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_ldexp_v2f16_v2i32:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    s_movk_i32 s4, 0x8000
; GFX9-SDAG-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX9-SDAG-NEXT:    v_med3_i32 v2, v2, s4, v3
; GFX9-SDAG-NEXT:    v_med3_i32 v1, v1, s4, v3
; GFX9-SDAG-NEXT:    v_ldexp_f16_sdwa v2, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_ldexp_v2f16_v2i32:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    s_movk_i32 s0, 0x8000
; GFX11-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-SDAG-NEXT:    v_med3_i32 v2, v2, s0, 0x7fff
; GFX11-SDAG-NEXT:    v_med3_i32 v1, v1, s0, 0x7fff
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-SDAG-NEXT:    v_ldexp_f16_e32 v2, v3, v2
; GFX11-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_v2f16_v2i32:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v1, v1, v3
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_ldexp_v2f16_v2i32:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v3, 0xffff8000
; GFX8-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX8-GISEL-NEXT:    v_med3_i32 v1, v1, v3, v4
; GFX8-GISEL-NEXT:    v_med3_i32 v2, v2, v3, v4
; GFX8-GISEL-NEXT:    v_ldexp_f16_e32 v1, v0, v1
; GFX8-GISEL-NEXT:    v_ldexp_f16_sdwa v0, v0, v2 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v1, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_ldexp_v2f16_v2i32:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v3, 0xffff8000
; GFX9-GISEL-NEXT:    v_mov_b32_e32 v4, 0x7fff
; GFX9-GISEL-NEXT:    v_med3_i32 v1, v1, v3, v4
; GFX9-GISEL-NEXT:    v_med3_i32 v2, v2, v3, v4
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v1, v0, v1
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v0, 16, v1
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_ldexp_v2f16_v2i32:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mov_b32_e32 v3, 0x7fff
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_med3_i32 v1, 0xffff8000, v1, v3
; GFX11-GISEL-NEXT:    v_med3_i32 v2, 0xffff8000, v2, v3
; GFX11-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_ldexp_f16_e32 v1, v4, v2
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x half> @llvm.ldexp.v2f16.v2i32(<2 x half> %a, <2 x i32> %b)
  ret <2 x half> %result
}

define <2 x half> @test_ldexp_v2f16_v2i16(<2 x half> %a, <2 x i16> %b) {
; GFX6-SDAG-LABEL: test_ldexp_v2f16_v2i16:
; GFX6-SDAG:       ; %bb.0:
; GFX6-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-SDAG-NEXT:    v_bfe_i32 v3, v3, 0, 16
; GFX6-SDAG-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-SDAG-NEXT:    v_ldexp_f32_e32 v1, v1, v3
; GFX6-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_ldexp_v2f16_v2i16:
; GFX8-SDAG:       ; %bb.0:
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_ldexp_f16_sdwa v2, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX8-SDAG-NEXT:    v_or_b32_e32 v0, v0, v2
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_ldexp_v2f16_v2i16:
; GFX9-SDAG:       ; %bb.0:
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    v_ldexp_f16_sdwa v2, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX9-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v2
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_ldexp_v2f16_v2i16:
; GFX11-SDAG:       ; %bb.0:
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX11-SDAG-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-SDAG-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_ldexp_f16_e32 v2, v3, v2
; GFX11-SDAG-NEXT:    v_pack_b32_f16 v0, v0, v2
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX6-GISEL-LABEL: test_ldexp_v2f16_v2i16:
; GFX6-GISEL:       ; %bb.0:
; GFX6-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX6-GISEL-NEXT:    v_bfe_i32 v2, v2, 0, 16
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX6-GISEL-NEXT:    v_bfe_i32 v2, v3, 0, 16
; GFX6-GISEL-NEXT:    v_ldexp_f32_e32 v1, v1, v2
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX6-GISEL-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX6-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_ldexp_v2f16_v2i16:
; GFX8-GISEL:       ; %bb.0:
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_ldexp_f16_e32 v2, v0, v1
; GFX8-GISEL-NEXT:    v_ldexp_f16_sdwa v0, v0, v1 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX8-GISEL-NEXT:    v_or_b32_e32 v0, v2, v0
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_ldexp_v2f16_v2i16:
; GFX9-GISEL:       ; %bb.0:
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    v_ldexp_f16_e32 v2, v0, v1
; GFX9-GISEL-NEXT:    v_ldexp_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:WORD_1
; GFX9-GISEL-NEXT:    v_lshl_or_b32 v0, v0, 16, v2
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_ldexp_v2f16_v2i16:
; GFX11-GISEL:       ; %bb.0:
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v2, 16, v0
; GFX11-GISEL-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-GISEL-NEXT:    v_ldexp_f16_e32 v0, v0, v1
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-GISEL-NEXT:    v_ldexp_f16_e32 v1, v2, v3
; GFX11-GISEL-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_lshl_or_b32 v0, v1, 16, v0
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x half> @llvm.ldexp.v2f16.v2i16(<2 x half> %a, <2 x i16> %b)
  ret <2 x half> %result
}

declare float @llvm.ldexp.f32.i32(float, i32) #0
declare float @llvm.ldexp.f32.i16(float, i16) #0
declare float @llvm.ldexp.f32.i64(float, i64) #0
declare half @llvm.ldexp.f16.i8(half, i8) #0
declare half @llvm.ldexp.f16.i16(half, i16) #0
declare half @llvm.ldexp.f16.i32(half, i32) #0
declare <2 x half> @llvm.ldexp.v2f16.v2i16(<2 x half>, <2 x i16>) #0
declare <2 x half> @llvm.ldexp.v2f16.v2i32(<2 x half>, <2 x i32>) #0
declare <2 x float> @llvm.ldexp.v2f32.v2i32(<2 x float>, <2 x i32>) #0
declare <2 x float> @llvm.ldexp.v2f32.v2i16(<2 x float>, <2 x i16>) #0
declare <2 x float> @llvm.ldexp.v2f32.v2i64(<2 x float>, <2 x i64>) #0
declare <3 x float> @llvm.ldexp.v3f32.v3i32(<3 x float>, <3 x i32>) #0
declare <4 x float> @llvm.ldexp.v4f32.v4i32(<4 x float>, <4 x i32>) #0
declare double @llvm.ldexp.f64.i32(double, i32) #0
declare <2 x double> @llvm.ldexp.v2f64.v2i32(<2 x double>, <2 x i32>) #0

attributes #0 = { nounwind readnone }
