; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=hexagon < %s | FileCheck %s

define <128 x i8> @abs80(<128 x i8> %a0) #0 {
; CHECK-LABEL: abs80:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     v3:2.h = vsxt(v0.b)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     v3:2.b = vshuffoe(v3.b,v2.b)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     v1.b = vadd(v0.b,v3.b)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     v0 = vxor(v0,v1)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = sub <128 x i8> zeroinitializer, %a0
  %v1 = icmp sgt <128 x i8> %a0, zeroinitializer
  %v2 = select <128 x i1> %v1, <128 x i8> %a0, <128 x i8> %v0
  ret <128 x i8> %v2
}

define <128 x i8> @abs81(<128 x i8> %a0) #1 {
; CHECK-LABEL: abs81:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     v0.b = vabs(v0.b)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = sub <128 x i8> zeroinitializer, %a0
  %v1 = icmp sgt <128 x i8> %a0, zeroinitializer
  %v2 = select <128 x i1> %v1, <128 x i8> %a0, <128 x i8> %v0
  ret <128 x i8> %v2
}

define <64 x i16> @abs16(<64 x i16> %a0) #0 {
; CHECK-LABEL: abs16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     v0.h = vabs(v0.h)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = sub <64 x i16> zeroinitializer, %a0
  %v1 = icmp sgt <64 x i16> %a0, zeroinitializer
  %v2 = select <64 x i1> %v1, <64 x i16> %a0, <64 x i16> %v0
  ret <64 x i16> %v2
}

define <32 x i32> @abs32(<32 x i32> %a0) #0 {
; CHECK-LABEL: abs32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    {
; CHECK-NEXT:     v0.w = vabs(v0.w)
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
  %v0 = sub <32 x i32> zeroinitializer, %a0
  %v1 = icmp sgt <32 x i32> %a0, zeroinitializer
  %v2 = select <32 x i1> %v1, <32 x i32> %a0, <32 x i32> %v0
  ret <32 x i32> %v2
}

attributes #0 = { nounwind readnone "target-features"="+hvxv60,+hvx-length128b" }
attributes #1 = { nounwind readnone "target-features"="+hvxv62,+hvx-length128b" }
