; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr8 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P8-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr9 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P9-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr10 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P10-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr8 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P8-LE
; RUN: llc -verify-machineinstrs -mcpu=pwr9 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P9-LE
; RUN: llc -verify-machineinstrs -mcpu=pwr10 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P10-LE

define dso_local void @foo1_int_be_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo1_int_be_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C0(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1543
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    li 4, 2057
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    sth 4, 20(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo1_int_be_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C0(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1543
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    li 4, 2057
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    sth 4, 20(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo1_int_be_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C0(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 67438087
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    li 4, 2057
; P10-BE-NEXT:    sth 4, 20(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo1_int_be_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI0_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI0_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 1798
; P8-LE-NEXT:    ori 4, 4, 1284
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    li 4, 2312
; P8-LE-NEXT:    sth 4, 20(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo1_int_be_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI0_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI0_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 1798
; P9-LE-NEXT:    ori 4, 4, 1284
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    li 4, 2312
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    sth 4, 20(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo1_int_be_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI0_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 117835012
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    li 4, 2312
; P10-LE-NEXT:    sth 4, 20(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15>, ptr %a, align 1
  %arrayidx16 = getelementptr inbounds i8, ptr %a, i64 16
  store i8 4, ptr %arrayidx16, align 1
  %arrayidx17 = getelementptr inbounds i8, ptr %a, i64 17
  store i8 5, ptr %arrayidx17, align 1
  %arrayidx18 = getelementptr inbounds i8, ptr %a, i64 18
  store i8 6, ptr %arrayidx18, align 1
  %arrayidx19 = getelementptr inbounds i8, ptr %a, i64 19
  store i8 7, ptr %arrayidx19, align 1
  %arrayidx20 = getelementptr inbounds i8, ptr %a, i64 20
  store i8 8, ptr %arrayidx20, align 1
  %arrayidx21 = getelementptr inbounds i8, ptr %a, i64 21
  store i8 9, ptr %arrayidx21, align 1
  ret void
}

define dso_local void @foo2_int_le_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo2_int_le_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C1(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 2057
; P8-BE-NEXT:    ori 4, 4, 2571
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    li 4, 3085
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    sth 4, 20(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo2_int_le_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C1(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 2057
; P9-BE-NEXT:    ori 4, 4, 2571
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    li 4, 3085
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    sth 4, 20(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo2_int_le_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C1(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 134810123
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    li 4, 3085
; P10-BE-NEXT:    sth 4, 20(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo2_int_le_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI1_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI1_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 2826
; P8-LE-NEXT:    ori 4, 4, 2312
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    li 4, 3340
; P8-LE-NEXT:    sth 4, 20(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo2_int_le_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI1_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI1_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 2826
; P9-LE-NEXT:    ori 4, 4, 2312
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    li 4, 3340
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    sth 4, 20(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo2_int_le_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI1_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 185207048
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    li 4, 3340
; P10-LE-NEXT:    sth 4, 20(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15>, ptr %a, align 1
  %arrayidx16 = getelementptr inbounds i8, ptr %a, i64 16
  store i8 8, ptr %arrayidx16, align 1
  %arrayidx17 = getelementptr inbounds i8, ptr %a, i64 17
  store i8 9, ptr %arrayidx17, align 1
  %arrayidx18 = getelementptr inbounds i8, ptr %a, i64 18
  store i8 10, ptr %arrayidx18, align 1
  %arrayidx19 = getelementptr inbounds i8, ptr %a, i64 19
  store i8 11, ptr %arrayidx19, align 1
  %arrayidx20 = getelementptr inbounds i8, ptr %a, i64 20
  store i8 12, ptr %arrayidx20, align 1
  %arrayidx21 = getelementptr inbounds i8, ptr %a, i64 21
  store i8 13, ptr %arrayidx21, align 1
  ret void
}

define dso_local void @foo3_int_be_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo3_int_be_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C2(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1543
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    li 4, 2057
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    sth 4, 20(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo3_int_be_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C2(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1543
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    li 4, 2057
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    sth 4, 20(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo3_int_be_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C2(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 67438087
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    li 4, 2057
; P10-BE-NEXT:    sth 4, 20(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo3_int_be_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI2_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI2_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 1543
; P8-LE-NEXT:    ori 4, 4, 1029
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    li 4, 2057
; P8-LE-NEXT:    sth 4, 20(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo3_int_be_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI2_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI2_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 1543
; P9-LE-NEXT:    ori 4, 4, 1029
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    li 4, 2057
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    sth 4, 20(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo3_int_be_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI2_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 101123077
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    li 4, 2057
; P10-LE-NEXT:    sth 4, 20(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 1, i16 515, i16 1029, i16 1543, i16 2057, i16 2571, i16 3085, i16 3599>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 1029, ptr %arrayidx8, align 2
  %arrayidx9 = getelementptr inbounds i16, ptr %a, i64 9
  store i16 1543, ptr %arrayidx9, align 2
  %arrayidx10 = getelementptr inbounds i16, ptr %a, i64 10
  store i16 2057, ptr %arrayidx10, align 2
  ret void
}

define dso_local void @foo4_int_le_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo4_int_le_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C3(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 2057
; P8-BE-NEXT:    ori 4, 4, 2571
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    li 4, 3085
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    sth 4, 20(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo4_int_le_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C3(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 2057
; P9-BE-NEXT:    ori 4, 4, 2571
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    li 4, 3085
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    sth 4, 20(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo4_int_le_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C3(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 134810123
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    li 4, 3085
; P10-BE-NEXT:    sth 4, 20(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo4_int_le_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI3_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI3_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 2571
; P8-LE-NEXT:    ori 4, 4, 2057
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    li 4, 3085
; P8-LE-NEXT:    sth 4, 20(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo4_int_le_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI3_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI3_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 2571
; P9-LE-NEXT:    ori 4, 4, 2057
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    li 4, 3085
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    sth 4, 20(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo4_int_le_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI3_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 168495113
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    li 4, 3085
; P10-LE-NEXT:    sth 4, 20(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 1, i16 515, i16 1029, i16 1543, i16 2057, i16 2571, i16 3085, i16 3599>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 2057, ptr %arrayidx8, align 2
  %arrayidx9 = getelementptr inbounds i16, ptr %a, i64 9
  store i16 2571, ptr %arrayidx9, align 2
  %arrayidx10 = getelementptr inbounds i16, ptr %a, i64 10
  store i16 3085, ptr %arrayidx10, align 2
  ret void
}

define dso_local void @foo5_int_be_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo5_int_be_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C4(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1543
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo5_int_be_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C4(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1543
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo5_int_be_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C4(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 67438087
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo5_int_be_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI4_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI4_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 1029
; P8-LE-NEXT:    ori 4, 4, 1543
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo5_int_be_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI4_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI4_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 1029
; P9-LE-NEXT:    ori 4, 4, 1543
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo5_int_be_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI4_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 67438087
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 66051, i32 67438087, i32 134810123, i32 202182159>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 67438087, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo6_int_le_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo6_int_le_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C5(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 2057
; P8-BE-NEXT:    ori 4, 4, 2571
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo6_int_le_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C5(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 2057
; P9-BE-NEXT:    ori 4, 4, 2571
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo6_int_le_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C5(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 134810123
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo6_int_le_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI5_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI5_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 2057
; P8-LE-NEXT:    ori 4, 4, 2571
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo6_int_le_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI5_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI5_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 2057
; P9-LE-NEXT:    ori 4, 4, 2571
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo6_int_le_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI5_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 134810123
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 66051, i32 67438087, i32 134810123, i32 202182159>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 134810123, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo7_int_be_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo7_int_be_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C6(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1
; P8-BE-NEXT:    ori 4, 4, 515
; P8-BE-NEXT:    rldic 4, 4, 32, 15
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1543
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo7_int_be_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C6(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1
; P9-BE-NEXT:    ori 4, 4, 515
; P9-BE-NEXT:    rldic 4, 4, 32, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1543
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo7_int_be_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C6(2) # %const.0
; P10-BE-NEXT:    pli 5, 67438087
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 66051
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo7_int_be_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI6_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI6_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 449
; P8-LE-NEXT:    ori 4, 4, 33089
; P8-LE-NEXT:    rldic 4, 4, 34, 5
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 770
; P8-LE-NEXT:    ori 4, 4, 256
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo7_int_be_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI6_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI6_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 449
; P9-LE-NEXT:    ori 4, 4, 33089
; P9-LE-NEXT:    rldic 4, 4, 34, 5
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 770
; P9-LE-NEXT:    ori 4, 4, 256
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo7_int_be_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI6_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 117835012
; P10-LE-NEXT:    pli 5, 50462976
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15>, ptr %a, align 1
  %arrayidx16 = getelementptr inbounds i8, ptr %a, i64 16
  store i8 0, ptr %arrayidx16, align 1
  %arrayidx17 = getelementptr inbounds i8, ptr %a, i64 17
  store i8 1, ptr %arrayidx17, align 1
  %arrayidx18 = getelementptr inbounds i8, ptr %a, i64 18
  store i8 2, ptr %arrayidx18, align 1
  %arrayidx19 = getelementptr inbounds i8, ptr %a, i64 19
  store i8 3, ptr %arrayidx19, align 1
  %arrayidx20 = getelementptr inbounds i8, ptr %a, i64 20
  store i8 4, ptr %arrayidx20, align 1
  %arrayidx21 = getelementptr inbounds i8, ptr %a, i64 21
  store i8 5, ptr %arrayidx21, align 1
  %arrayidx22 = getelementptr inbounds i8, ptr %a, i64 22
  store i8 6, ptr %arrayidx22, align 1
  %arrayidx23 = getelementptr inbounds i8, ptr %a, i64 23
  store i8 7, ptr %arrayidx23, align 1
  ret void
}

define dso_local void @foo8_int_le_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo8_int_le_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C7(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 2057
; P8-BE-NEXT:    ori 4, 4, 2571
; P8-BE-NEXT:    rldic 4, 4, 32, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 3085
; P8-BE-NEXT:    ori 4, 4, 3599
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo8_int_le_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C7(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 2057
; P9-BE-NEXT:    ori 4, 4, 2571
; P9-BE-NEXT:    rldic 4, 4, 32, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 3085
; P9-BE-NEXT:    ori 4, 4, 3599
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo8_int_le_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C7(2) # %const.0
; P10-BE-NEXT:    pli 5, 202182159
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 134810123
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo8_int_le_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI7_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI7_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 963
; P8-LE-NEXT:    ori 4, 4, 33603
; P8-LE-NEXT:    rldic 4, 4, 34, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 2826
; P8-LE-NEXT:    ori 4, 4, 2312
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo8_int_le_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI7_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI7_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 963
; P9-LE-NEXT:    ori 4, 4, 33603
; P9-LE-NEXT:    rldic 4, 4, 34, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 2826
; P9-LE-NEXT:    ori 4, 4, 2312
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo8_int_le_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI7_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 252579084
; P10-LE-NEXT:    pli 5, 185207048
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <16 x i8> <i8 0, i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15>, ptr %a, align 1
  %arrayidx16 = getelementptr inbounds i8, ptr %a, i64 16
  store i8 8, ptr %arrayidx16, align 1
  %arrayidx17 = getelementptr inbounds i8, ptr %a, i64 17
  store i8 9, ptr %arrayidx17, align 1
  %arrayidx18 = getelementptr inbounds i8, ptr %a, i64 18
  store i8 10, ptr %arrayidx18, align 1
  %arrayidx19 = getelementptr inbounds i8, ptr %a, i64 19
  store i8 11, ptr %arrayidx19, align 1
  %arrayidx20 = getelementptr inbounds i8, ptr %a, i64 20
  store i8 12, ptr %arrayidx20, align 1
  %arrayidx21 = getelementptr inbounds i8, ptr %a, i64 21
  store i8 13, ptr %arrayidx21, align 1
  %arrayidx22 = getelementptr inbounds i8, ptr %a, i64 22
  store i8 14, ptr %arrayidx22, align 1
  %arrayidx23 = getelementptr inbounds i8, ptr %a, i64 23
  store i8 15, ptr %arrayidx23, align 1
  ret void
}

define dso_local void @foo9_int_be_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo9_int_be_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C8(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1
; P8-BE-NEXT:    ori 4, 4, 515
; P8-BE-NEXT:    rldic 4, 4, 32, 15
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1543
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo9_int_be_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C8(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1
; P9-BE-NEXT:    ori 4, 4, 515
; P9-BE-NEXT:    rldic 4, 4, 32, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1543
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo9_int_be_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C8(2) # %const.0
; P10-BE-NEXT:    pli 5, 67438087
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 66051
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo9_int_be_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI8_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI8_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 1543
; P8-LE-NEXT:    ori 4, 4, 1029
; P8-LE-NEXT:    rldic 4, 4, 32, 5
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 515
; P8-LE-NEXT:    ori 4, 4, 1
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo9_int_be_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI8_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI8_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 1543
; P9-LE-NEXT:    ori 4, 4, 1029
; P9-LE-NEXT:    rldic 4, 4, 32, 5
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 515
; P9-LE-NEXT:    ori 4, 4, 1
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo9_int_be_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI8_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 101123077
; P10-LE-NEXT:    pli 5, 33751041
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 1, i16 515, i16 1029, i16 1543, i16 2057, i16 2571, i16 3085, i16 3599>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 1, ptr %arrayidx8, align 2
  %arrayidx9 = getelementptr inbounds i16, ptr %a, i64 9
  store i16 515, ptr %arrayidx9, align 2
  %arrayidx10 = getelementptr inbounds i16, ptr %a, i64 10
  store i16 1029, ptr %arrayidx10, align 2
  %arrayidx11 = getelementptr inbounds i16, ptr %a, i64 11
  store i16 1543, ptr %arrayidx11, align 2
  ret void
}

define dso_local void @foo10_int_le_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo10_int_le_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C9(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 2057
; P8-BE-NEXT:    ori 4, 4, 2571
; P8-BE-NEXT:    rldic 4, 4, 32, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 3085
; P8-BE-NEXT:    ori 4, 4, 3599
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo10_int_le_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C9(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 2057
; P9-BE-NEXT:    ori 4, 4, 2571
; P9-BE-NEXT:    rldic 4, 4, 32, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 3085
; P9-BE-NEXT:    ori 4, 4, 3599
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo10_int_le_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C9(2) # %const.0
; P10-BE-NEXT:    pli 5, 202182159
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 134810123
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo10_int_le_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI9_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI9_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 3599
; P8-LE-NEXT:    ori 4, 4, 3085
; P8-LE-NEXT:    rldic 4, 4, 32, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 2571
; P8-LE-NEXT:    ori 4, 4, 2057
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo10_int_le_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI9_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI9_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 3599
; P9-LE-NEXT:    ori 4, 4, 3085
; P9-LE-NEXT:    rldic 4, 4, 32, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 2571
; P9-LE-NEXT:    ori 4, 4, 2057
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo10_int_le_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI9_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 235867149
; P10-LE-NEXT:    pli 5, 168495113
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 1, i16 515, i16 1029, i16 1543, i16 2057, i16 2571, i16 3085, i16 3599>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 2057, ptr %arrayidx8, align 2
  %arrayidx9 = getelementptr inbounds i16, ptr %a, i64 9
  store i16 2571, ptr %arrayidx9, align 2
  %arrayidx10 = getelementptr inbounds i16, ptr %a, i64 10
  store i16 3085, ptr %arrayidx10, align 2
  %arrayidx11 = getelementptr inbounds i16, ptr %a, i64 11
  store i16 3599, ptr %arrayidx11, align 2
  ret void
}

define dso_local void @foo11_int_be_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo11_int_be_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C10(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1
; P8-BE-NEXT:    ori 4, 4, 515
; P8-BE-NEXT:    rldic 4, 4, 32, 15
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1543
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo11_int_be_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C10(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1
; P9-BE-NEXT:    ori 4, 4, 515
; P9-BE-NEXT:    rldic 4, 4, 32, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1543
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo11_int_be_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C10(2) # %const.0
; P10-BE-NEXT:    pli 5, 67438087
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 66051
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo11_int_be_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI10_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI10_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 1029
; P8-LE-NEXT:    ori 4, 4, 1543
; P8-LE-NEXT:    rldic 4, 4, 32, 5
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 1
; P8-LE-NEXT:    ori 4, 4, 515
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo11_int_be_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI10_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI10_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 1029
; P9-LE-NEXT:    ori 4, 4, 1543
; P9-LE-NEXT:    rldic 4, 4, 32, 5
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 1
; P9-LE-NEXT:    ori 4, 4, 515
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo11_int_be_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI10_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 67438087
; P10-LE-NEXT:    pli 5, 66051
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 66051, i32 67438087, i32 134810123, i32 202182159>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 66051, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %a, i64 5
  store i32 67438087, ptr %arrayidx5, align 4
  ret void
}

define dso_local void @foo12_int_le_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo12_int_le_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C11(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 2057
; P8-BE-NEXT:    ori 4, 4, 2571
; P8-BE-NEXT:    rldic 4, 4, 32, 4
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 3085
; P8-BE-NEXT:    ori 4, 4, 3599
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo12_int_le_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C11(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 2057
; P9-BE-NEXT:    ori 4, 4, 2571
; P9-BE-NEXT:    rldic 4, 4, 32, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 3085
; P9-BE-NEXT:    ori 4, 4, 3599
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo12_int_le_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C11(2) # %const.0
; P10-BE-NEXT:    pli 5, 202182159
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 134810123
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo12_int_le_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI11_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI11_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 3085
; P8-LE-NEXT:    ori 4, 4, 3599
; P8-LE-NEXT:    rldic 4, 4, 32, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 2057
; P8-LE-NEXT:    ori 4, 4, 2571
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo12_int_le_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI11_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI11_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 3085
; P9-LE-NEXT:    ori 4, 4, 3599
; P9-LE-NEXT:    rldic 4, 4, 32, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 2057
; P9-LE-NEXT:    ori 4, 4, 2571
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo12_int_le_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI11_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 202182159
; P10-LE-NEXT:    pli 5, 134810123
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 66051, i32 67438087, i32 134810123, i32 202182159>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 134810123, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %a, i64 5
  store i32 202182159, ptr %arrayidx5, align 4
  ret void
}

define dso_local void @foo13_int_be_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo13_int_be_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C12(2) # %const.0
; P8-BE-NEXT:    lxvd2x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1
; P8-BE-NEXT:    ori 4, 4, 515
; P8-BE-NEXT:    rldic 4, 4, 32, 15
; P8-BE-NEXT:    stxvd2x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1543
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo13_int_be_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C12(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1
; P9-BE-NEXT:    ori 4, 4, 515
; P9-BE-NEXT:    rldic 4, 4, 32, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1543
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo13_int_be_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C12(2) # %const.0
; P10-BE-NEXT:    pli 5, 67438087
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 66051
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo13_int_be_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI12_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI12_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 1
; P8-LE-NEXT:    ori 4, 4, 515
; P8-LE-NEXT:    rldic 4, 4, 32, 15
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 1029
; P8-LE-NEXT:    ori 4, 4, 1543
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo13_int_be_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI12_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI12_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 1
; P9-LE-NEXT:    ori 4, 4, 515
; P9-LE-NEXT:    rldic 4, 4, 32, 15
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 1029
; P9-LE-NEXT:    ori 4, 4, 1543
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo13_int_be_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI12_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 66051
; P10-LE-NEXT:    pli 5, 67438087
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <2 x i64> <i64 283686952306183, i64 579005069656919567>, ptr %a, align 8
  %arrayidx2 = getelementptr inbounds i64, ptr %a, i64 2
  store i64 283686952306183, ptr %arrayidx2, align 8
  ret void
}

define dso_local void @foo14_int_le_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo14_int_le_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C13(2) # %const.0
; P8-BE-NEXT:    lxvd2x 0, 0, 4
; P8-BE-NEXT:    lis 4, 2057
; P8-BE-NEXT:    ori 4, 4, 2571
; P8-BE-NEXT:    rldic 4, 4, 32, 4
; P8-BE-NEXT:    stxvd2x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 3085
; P8-BE-NEXT:    ori 4, 4, 3599
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo14_int_le_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C13(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 2057
; P9-BE-NEXT:    ori 4, 4, 2571
; P9-BE-NEXT:    rldic 4, 4, 32, 4
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 3085
; P9-BE-NEXT:    ori 4, 4, 3599
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo14_int_le_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C13(2) # %const.0
; P10-BE-NEXT:    pli 5, 202182159
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 134810123
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo14_int_le_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI13_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI13_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 2057
; P8-LE-NEXT:    ori 4, 4, 2571
; P8-LE-NEXT:    rldic 4, 4, 32, 4
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 3085
; P8-LE-NEXT:    ori 4, 4, 3599
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo14_int_le_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI13_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI13_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 2057
; P9-LE-NEXT:    ori 4, 4, 2571
; P9-LE-NEXT:    rldic 4, 4, 32, 4
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 3085
; P9-LE-NEXT:    ori 4, 4, 3599
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo14_int_le_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI13_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 134810123
; P10-LE-NEXT:    pli 5, 202182159
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <2 x i64> <i64 283686952306183, i64 579005069656919567>, ptr %a, align 8
  %arrayidx2 = getelementptr inbounds i64, ptr %a, i64 2
  store i64 579005069656919567, ptr %arrayidx2, align 8
  ret void
}

define dso_local void @foo15_int_noreuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo15_int_noreuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C14(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1544
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo15_int_noreuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C14(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1544
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo15_int_noreuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C14(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 67438088
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo15_int_noreuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI14_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI14_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 1029
; P8-LE-NEXT:    ori 4, 4, 1544
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo15_int_noreuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI14_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI14_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 1029
; P9-LE-NEXT:    ori 4, 4, 1544
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo15_int_noreuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI14_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 67438088
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 66051, i32 67438087, i32 134810123, i32 202182159>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 67438088, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo16_int_noreuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo16_int_noreuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C15(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 1
; P8-BE-NEXT:    ori 4, 4, 515
; P8-BE-NEXT:    rldic 4, 4, 32, 15
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    oris 4, 4, 1029
; P8-BE-NEXT:    ori 4, 4, 1544
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo16_int_noreuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C15(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 1
; P9-BE-NEXT:    ori 4, 4, 515
; P9-BE-NEXT:    rldic 4, 4, 32, 15
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 1029
; P9-BE-NEXT:    ori 4, 4, 1544
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo16_int_noreuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C15(2) # %const.0
; P10-BE-NEXT:    pli 5, 67438088
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 66051
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo16_int_noreuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI15_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI15_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 128
; P8-LE-NEXT:    ori 4, 4, 41153
; P8-LE-NEXT:    rldic 4, 4, 35, 5
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    oris 4, 4, 1
; P8-LE-NEXT:    ori 4, 4, 515
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo16_int_noreuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI15_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI15_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 128
; P9-LE-NEXT:    ori 4, 4, 41153
; P9-LE-NEXT:    rldic 4, 4, 35, 5
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 1
; P9-LE-NEXT:    ori 4, 4, 515
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo16_int_noreuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI15_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 67438088
; P10-LE-NEXT:    pli 5, 66051
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 66051, i32 67438087, i32 134810123, i32 202182159>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 66051, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %a, i64 5
  store i32 67438088, ptr %arrayidx5, align 4
  ret void
}

define dso_local void @foo17_fp_be_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo17_fp_be_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C16(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 16673
; P8-BE-NEXT:    ori 4, 4, 39322
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo17_fp_be_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C16(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 16673
; P9-BE-NEXT:    ori 4, 4, 39322
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo17_fp_be_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C16(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 1092721050
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo17_fp_be_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI16_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI16_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 16673
; P8-LE-NEXT:    ori 4, 4, 39322
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo17_fp_be_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI16_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI16_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 16673
; P9-LE-NEXT:    ori 4, 4, 39322
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo17_fp_be_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI16_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 1092721050
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x float> <float 1.000000e+00, float 0x4024333340000000, float 0x3FF3333340000000, float 0x3FF4CCCCC0000000>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds float, ptr %a, i64 4
  store float 0x4024333340000000, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo18_fp_le_reuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo18_fp_le_reuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C17(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 16675
; P8-BE-NEXT:    ori 4, 4, 13107
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo18_fp_le_reuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C17(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 16675
; P9-BE-NEXT:    ori 4, 4, 13107
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo18_fp_le_reuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C17(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 1092825907
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo18_fp_le_reuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI17_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI17_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 16675
; P8-LE-NEXT:    ori 4, 4, 13107
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo18_fp_le_reuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI17_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI17_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 16675
; P9-LE-NEXT:    ori 4, 4, 13107
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo18_fp_le_reuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI17_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 1092825907
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x float> <float 1.000000e+00, float 0x3FF19999A0000000, float 0x4024666660000000, float 0x3FF4CCCCC0000000>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds float, ptr %a, i64 4
  store float 0x4024666660000000, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo19_fp_be_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo19_fp_be_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C18(2) # %const.0
; P8-BE-NEXT:    lxvd2x 0, 0, 4
; P8-BE-NEXT:    li 4, 4105
; P8-BE-NEXT:    rldic 4, 4, 50, 1
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    stxvd2x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo19_fp_be_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C18(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    li 4, 4105
; P9-BE-NEXT:    rldic 4, 4, 50, 1
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo19_fp_be_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C18(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    li 4, 4105
; P10-BE-NEXT:    rldic 4, 4, 50, 1
; P10-BE-NEXT:    std 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo19_fp_be_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI18_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI18_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 4105
; P8-LE-NEXT:    rldic 4, 4, 50, 1
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo19_fp_be_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI18_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI18_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    li 4, 4105
; P9-LE-NEXT:    rldic 4, 4, 50, 1
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo19_fp_be_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI18_0@PCREL(0), 1
; P10-LE-NEXT:    li 4, 4105
; P10-LE-NEXT:    rldic 4, 4, 50, 1
; P10-LE-NEXT:    std 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <2 x double> <double 1.000000e+01, double 1.100000e+00>, ptr %a, align 8
  %arrayidx2 = getelementptr inbounds double, ptr %a, i64 2
  store double 1.000000e+01, ptr %arrayidx2, align 8
  ret void
}

define dso_local void @foo20_fp_le_reuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo20_fp_le_reuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C19(2) # %const.0
; P8-BE-NEXT:    lxvd2x 0, 0, 4
; P8-BE-NEXT:    lis 4, 16420
; P8-BE-NEXT:    ori 4, 4, 13107
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    stxvd2x 0, 0, 3
; P8-BE-NEXT:    rlwimi 4, 4, 16, 0, 15
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo20_fp_le_reuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C19(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 16420
; P9-BE-NEXT:    ori 4, 4, 13107
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    rlwimi 4, 4, 16, 0, 15
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo20_fp_le_reuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C19(2) # %const.0
; P10-BE-NEXT:    pli 5, 858993459
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 1076114227
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo20_fp_le_reuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI19_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI19_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 16420
; P8-LE-NEXT:    ori 4, 4, 13107
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    rlwimi 4, 4, 16, 0, 15
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo20_fp_le_reuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI19_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI19_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 16420
; P9-LE-NEXT:    ori 4, 4, 13107
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    rlwimi 4, 4, 16, 0, 15
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo20_fp_le_reuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI19_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 1076114227
; P10-LE-NEXT:    pli 5, 858993459
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <2 x double> <double 1.000000e+00, double 1.010000e+01>, ptr %a, align 8
  %arrayidx2 = getelementptr inbounds double, ptr %a, i64 2
  store double 1.010000e+01, ptr %arrayidx2, align 8
  ret void
}

define dso_local void @foo21_fp_noreuse4B(ptr nocapture noundef writeonly %a) local_unnamed_addr #0 {
; P8-BE-LABEL: foo21_fp_noreuse4B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C20(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 16268
; P8-BE-NEXT:    ori 4, 4, 52430
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo21_fp_noreuse4B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C20(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 16268
; P9-BE-NEXT:    ori 4, 4, 52430
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo21_fp_noreuse4B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C20(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    pli 4, 1066192078
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo21_fp_noreuse4B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI20_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI20_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 16268
; P8-LE-NEXT:    ori 4, 4, 52430
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo21_fp_noreuse4B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI20_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI20_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 16268
; P9-LE-NEXT:    ori 4, 4, 52430
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo21_fp_noreuse4B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI20_0@PCREL(0), 1
; P10-LE-NEXT:    pli 4, 1066192078
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x float> <float 1.000000e+00, float 0x3FF19999A0000000, float 0x3FF3333340000000, float 0x3FF4CCCCC0000000>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds float, ptr %a, i64 4
  store float 0x3FF19999C0000000, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo22_fp_noreuse8B(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo22_fp_noreuse8B:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C21(2) # %const.0
; P8-BE-NEXT:    lxvd2x 0, 0, 4
; P8-BE-NEXT:    li 4, 21503
; P8-BE-NEXT:    rotldi 4, 4, 52
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    stxvd2x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo22_fp_noreuse8B:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C21(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    li 4, 21503
; P9-BE-NEXT:    rotldi 4, 4, 52
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo22_fp_noreuse8B:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    ld 4, L..C21(2) # %const.0
; P10-BE-NEXT:    lxv 0, 0(4)
; P10-BE-NEXT:    li 4, 21503
; P10-BE-NEXT:    rotldi 4, 4, 52
; P10-BE-NEXT:    std 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo22_fp_noreuse8B:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI21_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI21_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 21503
; P8-LE-NEXT:    rotldi 4, 4, 52
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo22_fp_noreuse8B:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI21_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI21_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    li 4, 21503
; P9-LE-NEXT:    rotldi 4, 4, 52
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo22_fp_noreuse8B:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    plxv 0, .LCPI21_0@PCREL(0), 1
; P10-LE-NEXT:    li 4, 21503
; P10-LE-NEXT:    rotldi 4, 4, 52
; P10-LE-NEXT:    std 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <2 x double> <double 1.000000e+00, double 1.100000e+00>, ptr %a, align 8
  %arrayidx2 = getelementptr inbounds double, ptr %a, i64 2
  store double 0x3FF0000000000005, ptr %arrayidx2, align 8
  ret void
}
