; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -relocation-model=pic -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr9 < %s | FileCheck -check-prefix=CHECK-P9 %s
; RUN: llc -relocation-model=pic -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -mcpu=pwr8 < %s | FileCheck -check-prefix=CHECK-P8 %s

; As the constant could be represented as float, a float is
; loaded from constant pool.
define double @doubleConstant1() {
; CHECK-P9-LABEL: doubleConstant1:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    vspltisw 2, 14
; CHECK-P9-NEXT:    xvcvsxwdp 1, 34
; CHECK-P9-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: doubleConstant1:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    vspltisw 2, 14
; CHECK-P8-NEXT:    xvcvsxwdp 1, 34
; CHECK-P8-NEXT:    # kill: def $f1 killed $f1 killed $vsl1
; CHECK-P8-NEXT:    blr
  ret double 1.400000e+01
}

; As the constant couldn't be represented as float, a double is
; loaded from constant pool.
define double @doubleConstant2() {
; CHECK-P9-LABEL: doubleConstant2:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; CHECK-P9-NEXT:    lfd 1, .LCPI1_0@toc@l(3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: doubleConstant2:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    addis 3, 2, .LCPI1_0@toc@ha
; CHECK-P8-NEXT:    lfd 1, .LCPI1_0@toc@l(3)
; CHECK-P8-NEXT:    blr
  ret double 2.408904e+01
}

@FArr = hidden local_unnamed_addr global [10 x float] zeroinitializer, align 4

define float @floatConstantArray() local_unnamed_addr  {
; CHECK-P9-LABEL: floatConstantArray:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    addis 3, 2, FArr@toc@ha+12
; CHECK-P9-NEXT:    lfs 0, FArr@toc@l+12(3)
; CHECK-P9-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; CHECK-P9-NEXT:    lfs 1, .LCPI2_0@toc@l(3)
; CHECK-P9-NEXT:    xsaddsp 1, 0, 1
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: floatConstantArray:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    addis 3, 2, FArr@toc@ha+12
; CHECK-P8-NEXT:    lfs 0, FArr@toc@l+12(3)
; CHECK-P8-NEXT:    addis 3, 2, .LCPI2_0@toc@ha
; CHECK-P8-NEXT:    lfs 1, .LCPI2_0@toc@l(3)
; CHECK-P8-NEXT:    xsaddsp 1, 0, 1
; CHECK-P8-NEXT:    blr
  %1 = load float, ptr getelementptr inbounds ([10 x float], ptr @FArr, i64 0, i64 3), align 4
  %2 = fadd float %1, 0x400B333340000000
  ret float %2
}

define float @floatConstant() {
; CHECK-P9-LABEL: floatConstant:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; CHECK-P9-NEXT:    lfs 1, .LCPI3_0@toc@l(3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: floatConstant:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    addis 3, 2, .LCPI3_0@toc@ha
; CHECK-P8-NEXT:    lfs 1, .LCPI3_0@toc@l(3)
; CHECK-P8-NEXT:    blr
  ret float 0x400470A3E0000000
}

; llvm put the hidden globals into the TOC table.
; TODO - do some analysis and decide which globals could be put into TOC.
@d = hidden local_unnamed_addr global [200 x double] zeroinitializer, align 8

define double @doubleConstantArray()  {
; CHECK-P9-LABEL: doubleConstantArray:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    addis 3, 2, d@toc@ha+24
; CHECK-P9-NEXT:    lfd 0, d@toc@l+24(3)
; CHECK-P9-NEXT:    addis 3, 2, .LCPI4_0@toc@ha
; CHECK-P9-NEXT:    lfd 1, .LCPI4_0@toc@l(3)
; CHECK-P9-NEXT:    xsadddp 1, 0, 1
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: doubleConstantArray:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    addis 3, 2, d@toc@ha+24
; CHECK-P8-NEXT:    lfd 0, d@toc@l+24(3)
; CHECK-P8-NEXT:    addis 3, 2, .LCPI4_0@toc@ha
; CHECK-P8-NEXT:    lfd 1, .LCPI4_0@toc@l(3)
; CHECK-P8-NEXT:    xsadddp 1, 0, 1
; CHECK-P8-NEXT:    blr
  %1 = load double, ptr getelementptr inbounds ([200 x double], ptr @d, i64 0, i64 3), align 8
  %2 = fadd double %1, 6.880000e+00
  ret double %2
}

@arr = hidden local_unnamed_addr global [20000 x double] zeroinitializer, align 8

; Access an element with an offset that doesn't fit in the displacement field of LFD.
define double @doubleLargeConstantArray()  {
; CHECK-P9-LABEL: doubleLargeConstantArray:
; CHECK-P9:       # %bb.0:
; CHECK-P9-NEXT:    addis 3, 2, arr@toc@ha
; CHECK-P9-NEXT:    li 4, 0
; CHECK-P9-NEXT:    addi 3, 3, arr@toc@l
; CHECK-P9-NEXT:    ori 4, 4, 32768
; CHECK-P9-NEXT:    lfdx 0, 3, 4
; CHECK-P9-NEXT:    addis 3, 2, .LCPI5_0@toc@ha
; CHECK-P9-NEXT:    lfd 1, .LCPI5_0@toc@l(3)
; CHECK-P9-NEXT:    xsadddp 1, 0, 1
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: doubleLargeConstantArray:
; CHECK-P8:       # %bb.0:
; CHECK-P8-NEXT:    addis 3, 2, arr@toc@ha
; CHECK-P8-NEXT:    li 4, 0
; CHECK-P8-NEXT:    addi 3, 3, arr@toc@l
; CHECK-P8-NEXT:    ori 4, 4, 32768
; CHECK-P8-NEXT:    lfdx 0, 3, 4
; CHECK-P8-NEXT:    addis 3, 2, .LCPI5_0@toc@ha
; CHECK-P8-NEXT:    lfd 1, .LCPI5_0@toc@l(3)
; CHECK-P8-NEXT:    xsadddp 1, 0, 1
; CHECK-P8-NEXT:    blr
  %1 = load double, ptr getelementptr inbounds ([20000 x double], ptr @arr, i64 0, i64 4096), align 8
  %2 = fadd double %1, 6.880000e+00
  ret double %2
}

@vec_arr = global [10 x <4 x i32>] zeroinitializer, align 16

define <4 x i32> @vectorArray() #0 {
; CHECK-P9-LABEL: vectorArray:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-P9-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-P9-NEXT:    lxv 34, 32(3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: vectorArray:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis 3, 2, .LC0@toc@ha
; CHECK-P8-NEXT:    ld 3, .LC0@toc@l(3)
; CHECK-P8-NEXT:    addi 3, 3, 32
; CHECK-P8-NEXT:    lxvd2x 0, 0, 3
; CHECK-P8-NEXT:    xxswapd 34, 0
; CHECK-P8-NEXT:    blr
entry:
  %0 = load <4 x i32>, ptr getelementptr inbounds ([10 x <4 x i32>], ptr @vec_arr, i64 0, i64 2), align 16
  ret <4 x i32> %0
}
