; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+f -verify-machineinstrs < %s | FileCheck -check-prefix=RV32IF %s
; RUN: llc -mtriple=riscv64 -mattr=+f -verify-machineinstrs < %s | FileCheck -check-prefix=RV64IF %s

define i32 @func_01() {
; RV32IF-LABEL: func_01:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    frrm a0
; RV32IF-NEXT:    slli a0, a0, 2
; RV32IF-NEXT:    lui a1, 66
; RV32IF-NEXT:    addi a1, a1, 769
; RV32IF-NEXT:    srl a0, a1, a0
; RV32IF-NEXT:    andi a0, a0, 7
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: func_01:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    frrm a0
; RV64IF-NEXT:    slli a0, a0, 2
; RV64IF-NEXT:    lui a1, 66
; RV64IF-NEXT:    addiw a1, a1, 769
; RV64IF-NEXT:    srl a0, a1, a0
; RV64IF-NEXT:    andi a0, a0, 7
; RV64IF-NEXT:    ret
  %rm = call i32 @llvm.get.rounding()
  ret i32 %rm
}

define void @func_02(i32 %rm) {
; RV32IF-LABEL: func_02:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    slli a0, a0, 2
; RV32IF-NEXT:    lui a1, 66
; RV32IF-NEXT:    addi a1, a1, 769
; RV32IF-NEXT:    srl a0, a1, a0
; RV32IF-NEXT:    andi a0, a0, 7
; RV32IF-NEXT:    fsrm a0
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: func_02:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    slli a0, a0, 32
; RV64IF-NEXT:    srli a0, a0, 30
; RV64IF-NEXT:    lui a1, 66
; RV64IF-NEXT:    addiw a1, a1, 769
; RV64IF-NEXT:    srl a0, a1, a0
; RV64IF-NEXT:    andi a0, a0, 7
; RV64IF-NEXT:    fsrm a0
; RV64IF-NEXT:    ret
  call void @llvm.set.rounding(i32 %rm)
  ret void
}

define void @func_03() {
; RV32IF-LABEL: func_03:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fsrmi 1
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: func_03:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fsrmi 1
; RV64IF-NEXT:    ret
  call void @llvm.set.rounding(i32 0)
  ret void
}

define void @func_04() {
; RV32IF-LABEL: func_04:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fsrmi 0
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: func_04:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fsrmi 0
; RV64IF-NEXT:    ret
  call void @llvm.set.rounding(i32 1)
  ret void
}

define void @func_05() {
; RV32IF-LABEL: func_05:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fsrmi 3
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: func_05:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fsrmi 3
; RV64IF-NEXT:    ret
  call void @llvm.set.rounding(i32 2)
  ret void
}

define void @func_06() {
; RV32IF-LABEL: func_06:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fsrmi 2
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: func_06:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fsrmi 2
; RV64IF-NEXT:    ret
  call void @llvm.set.rounding(i32 3)
  ret void
}

define void @func_07() {
; RV32IF-LABEL: func_07:
; RV32IF:       # %bb.0:
; RV32IF-NEXT:    fsrmi 4
; RV32IF-NEXT:    ret
;
; RV64IF-LABEL: func_07:
; RV64IF:       # %bb.0:
; RV64IF-NEXT:    fsrmi 4
; RV64IF-NEXT:    ret
  call void @llvm.set.rounding(i32 4)
  ret void
}

declare void @llvm.set.rounding(i32)
declare i32 @llvm.get.rounding()
