; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=s390x-linux-gnu -no-integrated-as < %s | FileCheck %s
;

; Test i128 (tied) operands.

define i32 @fun0(ptr %p1, i32 signext %l1, ptr %p2, i32 signext %l2, i8 zeroext %pad) {
; CHECK-LABEL: fun0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lgr %r0, %r5
; CHECK-NEXT:    # kill: def $r4d killed $r4d def $r4q
; CHECK-NEXT:    lgr %r1, %r3
; CHECK-NEXT:    # kill: def $r2d killed $r2d def $r2q
; CHECK-NEXT:    sllg %r5, %r6, 24
; CHECK-NEXT:    rosbg %r5, %r0, 40, 63, 0
; CHECK-NEXT:    risbg %r3, %r1, 40, 191, 0
; CHECK-NEXT:    #APP
; CHECK-NEXT:    clcl %r2, %r4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    ogr %r3, %r5
; CHECK-NEXT:    risbg %r0, %r3, 40, 191, 0
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    afi %r2, -268435456
; CHECK-NEXT:    srl %r2, 31
; CHECK-NEXT:    br %r14
entry:
  %0 = ptrtoint ptr %p1 to i64
  %1 = ptrtoint ptr %p2 to i64
  %and5 = and i32 %l2, 16777215
  %2 = zext i32 %and5 to i64
  %conv7 = zext i8 %pad to i64
  %shl = shl nuw nsw i64 %conv7, 24
  %or = or i64 %shl, %2
  %u1.sroa.0.0.insert.ext = zext i64 %0 to i128
  %u1.sroa.0.0.insert.shift = shl nuw i128 %u1.sroa.0.0.insert.ext, 64
  %3 = and i32 %l1, 16777215
  %u1.sroa.0.0.insert.mask = zext i32 %3 to i128
  %u1.sroa.0.0.insert.insert = or i128 %u1.sroa.0.0.insert.shift, %u1.sroa.0.0.insert.mask
  %u2.sroa.5.0.insert.ext = zext i64 %or to i128
  %u2.sroa.0.0.insert.ext = zext i64 %1 to i128
  %u2.sroa.0.0.insert.shift = shl nuw i128 %u2.sroa.0.0.insert.ext, 64
  %u2.sroa.0.0.insert.insert = or i128 %u2.sroa.0.0.insert.shift, %u2.sroa.5.0.insert.ext
  %4 = tail call { i128, i128 } asm "clcl $0, $1", "=r,=r,0,1"(i128 %u1.sroa.0.0.insert.insert, i128 %u2.sroa.0.0.insert.insert)
  %asmresult = extractvalue { i128, i128 } %4, 0
  %asmresult11 = extractvalue { i128, i128 } %4, 1
  %5 = or i128 %asmresult, %asmresult11
  %6 = and i128 %5, 16777215
  %7 = icmp eq i128 %6, 0
  %land.ext = zext i1 %7 to i32
  ret i32 %land.ext
}

; Test a phys-reg def.
define void @fun1(ptr %Src, ptr %Dst) {
; CHECK-LABEL: fun1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    #APP
; CHECK-NEXT:    BLA %r4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    stg %r5, 8(%r3)
; CHECK-NEXT:    stg %r4, 0(%r3)
; CHECK-NEXT:    br %r14
entry:
   %IAsm = call i128 asm "BLA $0", "={r4}"()
  store volatile i128 %IAsm, ptr %Dst
  ret void
}

; Test a phys-reg use.
define void @fun2(ptr %Src, ptr %Dst) {
; CHECK-LABEL: fun2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lg %r5, 8(%r2)
; CHECK-NEXT:    lg %r4, 0(%r2)
; CHECK-NEXT:    #APP
; CHECK-NEXT:    BLA %r4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    br %r14
entry:
  %L = load i128, ptr %Src
  call void asm "BLA $0", "{r4}"(i128 %L)
  ret void
}

; Test phys-reg use and phys-reg def.
define void @fun3(ptr %Src, ptr %Dst) {
; CHECK-LABEL: fun3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lg %r1, 8(%r2)
; CHECK-NEXT:    lg %r0, 0(%r2)
; CHECK-NEXT:    #APP
; CHECK-NEXT:    BLA %r4, %r0
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    stg %r5, 8(%r3)
; CHECK-NEXT:    stg %r4, 0(%r3)
; CHECK-NEXT:    br %r14
entry:
  %L = load i128, ptr %Src
  %IAsm = call i128 asm "BLA $0, $1", "={r4},{r0}"(i128 %L)
  store volatile i128 %IAsm, ptr %Dst
  ret void
}

; Test a tied phys-reg.
define void @fun4(ptr %Src, ptr %Dst) {
; CHECK-LABEL: fun4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lg %r5, 8(%r2)
; CHECK-NEXT:    lg %r4, 0(%r2)
; CHECK-NEXT:    #APP
; CHECK-NEXT:    BLA %r4, %r4
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    stg %r5, 8(%r3)
; CHECK-NEXT:    stg %r4, 0(%r3)
; CHECK-NEXT:    br %r14
entry:
  %L = load i128, ptr %Src
  %IAsm = call i128 asm "BLA $0, $1", "={r4},0"(i128 %L)
  store volatile i128 %IAsm, ptr %Dst
  ret void
}

; Test access of the odd register using 'N'.
define i64 @fun5(i64 %b) {
; CHECK-LABEL: fun5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lgr %r1, %r2
; CHECK-NEXT:    lghi %r0, 0
; CHECK-NEXT:    #APP
; CHECK-NEXT:     lgr %r2,%r1
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    br %r14
entry:
  %Ins = zext i64 %b to i128
  %Res = tail call i64 asm "\09lgr\09$0,${1:N}", "=d,d"(i128 %Ins)
  ret i64 %Res
}

; Test 'N' with multiple accesses to the same operand and i128 result.
@V128 = global i128 0, align 16
define i32 @fun6() {
; CHECK-LABEL: fun6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lgrl %r1, V128@GOT
; CHECK-NEXT:    lg %r3, 8(%r1)
; CHECK-NEXT:    lg %r2, 0(%r1)
; CHECK-NEXT:    #APP
; CHECK-NEXT:    ltgr %r3,%r3
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    stg %r2, 0(%r1)
; CHECK-NEXT:    stg %r3, 8(%r1)
; CHECK-NEXT:    br %r14
entry:
  %0 = load i128, ptr @V128
  %1 = tail call i128 asm "ltgr ${0:N},${0:N}", "=&d,0"(i128 %0)
  store i128 %1, ptr @V128
  ret i32 undef
}
