; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=thumbv7m-none-eabi -o - |  FileCheck %s

; 0xff00ff00 = 4278255360
; 0x00ff00ff = 16711935
define i32 @rev16(i32 %a) {
; CHECK-LABEL: rev16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rev16 r0, r0
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 8
    %r8 = lshr i32 %a, 8
    %mask_l8 = and i32 %l8, 4278255360
    %mask_r8 = and i32 %r8, 16711935
    %tmp = or i32 %mask_l8, %mask_r8
    ret i32 %tmp
}

define i32 @not_rev16(i32 %a) {
; CHECK-LABEL: not_rev16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    mov.w r1, #65280
; CHECK-NEXT:    and.w r1, r1, r0, lsr #8
; CHECK-NEXT:    and r0, r0, #65280
; CHECK-NEXT:    orr.w r0, r1, r0, lsl #8
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 8
    %r8 = lshr i32 %a, 8
    %mask_r8 = and i32 %r8, 4278255360
    %mask_l8 = and i32 %l8, 16711935
    %tmp = or i32 %mask_r8, %mask_l8
    ret i32 %tmp
}

define i32 @extra_maskop_uses2(i32 %a) {
; CHECK-LABEL: extra_maskop_uses2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    mov.w r1, #-16711936
; CHECK-NEXT:    mov.w r2, #16711935
; CHECK-NEXT:    and.w r1, r1, r0, lsl #8
; CHECK-NEXT:    and.w r0, r2, r0, lsr #8
; CHECK-NEXT:    adds r2, r0, r1
; CHECK-NEXT:    muls r0, r1, r0
; CHECK-NEXT:    muls r0, r2, r0
; CHECK-NEXT:    bx lr
  %l8 = shl i32 %a, 8
  %r8 = lshr i32 %a, 8
  %mask_l8 = and i32 %l8, 4278255360
  %mask_r8 = and i32 %r8, 16711935
  %or = or i32 %mask_r8, %mask_l8
  %mul = mul i32 %mask_r8, %mask_l8   ; another use of the mask ops
  %r = mul i32 %mul, %or              ; and use that result
  ret i32 %r
}


define i32 @bswap_ror_commuted(i32 %a) {
; CHECK-LABEL: bswap_ror_commuted:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    rev16 r0, r0
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 8
    %r8 = lshr i32 %a, 8
    %mask_l8 = and i32 %l8, 4278255360
    %mask_r8 = and i32 %r8, 16711935
    %tmp = or i32 %mask_r8, %mask_l8
    ret i32 %tmp
}

define i32 @different_shift_amount(i32 %a) {
; CHECK-LABEL: different_shift_amount:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    mov.w r1, #16711935
; CHECK-NEXT:    movw r2, #65024
; CHECK-NEXT:    and.w r1, r1, r0, lsr #8
; CHECK-NEXT:    movt r2, #65280
; CHECK-NEXT:    and.w r0, r2, r0, lsl #9
; CHECK-NEXT:    add r0, r1
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 9
    %r8 = lshr i32 %a, 8
    %mask_l8 = and i32 %l8, 4278255360
    %mask_r8 = and i32 %r8, 16711935
    %tmp = or i32 %mask_l8, %mask_r8
    ret i32 %tmp
}

define i32 @different_constant(i32 %a) {
; CHECK-LABEL: different_constant:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    mov.w r1, #16711935
; CHECK-NEXT:    and.w r0, r1, r0, lsr #8
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 8
    %r8 = lshr i32 %a, 8
    %mask_l8 = and i32 %l8, 42
    %mask_r8 = and i32 %r8, 16711935
    %tmp = or i32 %mask_l8, %mask_r8
    ret i32 %tmp
}

define i32 @different_op(i32 %a) {
; CHECK-LABEL: different_op:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    mov.w r1, #16711935
; CHECK-NEXT:    movw r2, #256
; CHECK-NEXT:    and.w r1, r1, r0, lsr #8
; CHECK-NEXT:    movt r2, #255
; CHECK-NEXT:    add.w r0, r2, r0, lsl #8
; CHECK-NEXT:    orrs r0, r1
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 8
    %r8 = lshr i32 %a, 8
    %mask_l8 = sub i32 %l8, 4278255360
    %mask_r8 = and i32 %r8, 16711935
    %tmp = or i32 %mask_l8, %mask_r8
    ret i32 %tmp
}

define i32 @different_vars(i32 %a, i32 %b) {
; CHECK-LABEL: different_vars:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    mov.w r2, #16711935
; CHECK-NEXT:    and.w r1, r2, r1, lsr #8
; CHECK-NEXT:    mov.w r2, #-16711936
; CHECK-NEXT:    and.w r0, r2, r0, lsl #8
; CHECK-NEXT:    add r0, r1
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 8
    %r8 = lshr i32 %b, 8
    %mask_l8 = and i32 %l8, 4278255360
    %mask_r8 = and i32 %r8, 16711935
    %tmp = or i32 %mask_l8, %mask_r8
    ret i32 %tmp
}


; FIXME: this rev16 pattern is not matching

; 0xff000000 = 4278190080
; 0x00ff0000 = 16711680
; 0x0000ff00 = 65280
; 0x000000ff = 255
define i32 @f2(i32 %a) {
; CHECK-LABEL: f2:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    mov.w r1, #16711680
; CHECK-NEXT:    and r2, r0, #16711680
; CHECK-NEXT:    and.w r1, r1, r0, lsr #8
; CHECK-NEXT:    orr.w r1, r1, r2, lsl #8
; CHECK-NEXT:    ubfx r2, r0, #8, #8
; CHECK-NEXT:    bfi r2, r0, #8, #8
; CHECK-NEXT:    adds r0, r2, r1
; CHECK-NEXT:    bx lr
    %l8 = shl i32 %a, 8
    %r8 = lshr i32 %a, 8
    %masklo_l8 = and i32 %l8, 65280
    %maskhi_l8 = and i32 %l8, 4278190080
    %masklo_r8 = and i32 %r8, 255
    %maskhi_r8 = and i32 %r8, 16711680
    %tmp1 = or i32 %masklo_l8, %masklo_r8
    %tmp2 = or i32 %maskhi_l8, %maskhi_r8
    %tmp = or i32 %tmp1, %tmp2
    ret i32 %tmp
}
