; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; REQUIRES: asserts
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s --check-prefix=CHECK-64
; RUN: llc < %s -mtriple=x86_64-- -o /dev/null -stats  -info-output-file - | grep asm-printer  | grep 12
; RUN: llc < %s -mtriple=i686-- | FileCheck %s --check-prefix=CHECK-32

declare void @bar(double %x)
declare void @barf(float %x)

define double @foo() nounwind {
; CHECK-64-LABEL: foo:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    pushq %rax
; CHECK-64-NEXT:    xorps %xmm0, %xmm0
; CHECK-64-NEXT:    callq bar@PLT
; CHECK-64-NEXT:    xorps %xmm0, %xmm0
; CHECK-64-NEXT:    popq %rax
; CHECK-64-NEXT:    retq
;
; CHECK-32-LABEL: foo:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    subl $8, %esp
; CHECK-32-NEXT:    fldz
; CHECK-32-NEXT:    fstpl (%esp)
; CHECK-32-NEXT:    calll bar@PLT
; CHECK-32-NEXT:    fldz
; CHECK-32-NEXT:    addl $8, %esp
; CHECK-32-NEXT:    retl
  call void @bar(double 0.0)
  ret double 0.0
}


define float @foof() nounwind {
; CHECK-64-LABEL: foof:
; CHECK-64:       # %bb.0:
; CHECK-64-NEXT:    pushq %rax
; CHECK-64-NEXT:    xorps %xmm0, %xmm0
; CHECK-64-NEXT:    callq barf@PLT
; CHECK-64-NEXT:    xorps %xmm0, %xmm0
; CHECK-64-NEXT:    popq %rax
; CHECK-64-NEXT:    retq
;
; CHECK-32-LABEL: foof:
; CHECK-32:       # %bb.0:
; CHECK-32-NEXT:    pushl $0
; CHECK-32-NEXT:    calll barf@PLT
; CHECK-32-NEXT:    addl $4, %esp
; CHECK-32-NEXT:    fldz
; CHECK-32-NEXT:    retl
  call void @barf(float 0.0)
  ret float 0.0
}
