; RUN: llvm-mc -arch=amdgcn -mcpu=gfx1200 -show-encoding %s | FileCheck --check-prefix=GFX12 %s

flat_atomic_add_f32 v1, v[0:1], v2 offset:-8000000 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x15,0xec,0x01,0x00,0x10,0x01,0x00,0x00,0xee,0x85]

flat_atomic_add_f32 v1, v[0:1], v2 offset:8000000 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x15,0xec,0x01,0x00,0x10,0x01,0x00,0x00,0x12,0x7a]

flat_atomic_add_f32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x15,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_add_f32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x15,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_add_f32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x80,0x15,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_add_f32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x80,0x15,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_add_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_add_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_add_u32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x40,0x0d,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_add_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x40,0x0d,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_add_u32 v[3:4], v5
// GFX12: encoding: [0x7c,0x40,0x0d,0xec,0x00,0x00,0x80,0x02,0x03,0x00,0x00,0x00]

flat_atomic_add_u64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_add_u64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0xc0,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_add_u64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_add_u64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_and_b32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_and_b32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_and_b32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x00,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_and_b32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x00,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_and_b64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x40,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_and_b64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x40,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_and_b64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_and_b64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

flat_atomic_cmpswap_b32 v0, v[1:2], v[3:4] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

flat_atomic_cmpswap_b32 v1, v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_cmpswap_b32 v1, v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_cmpswap_b32 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_cmpswap_b32 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x00,0x0d,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_cmpswap_b64 v[0:1], v[2:5] offset:-64
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_cmpswap_b64 v[0:1], v[2:5] offset:64
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_cmpswap_b64 v[1:2], v[0:1], v[2:5] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_cmpswap_b64 v[1:2], v[0:1], v[2:5] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00]

flat_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00]

flat_atomic_cond_sub_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x14,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_cond_sub_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x14,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_cond_sub_u32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x00,0x14,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_cond_sub_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x00,0x14,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_dec_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_dec_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_dec_u32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x00,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_dec_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x00,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_dec_u64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x40,0x13,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_dec_u64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x40,0x13,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_dec_u64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x13,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_dec_u64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x13,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_inc_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_inc_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_inc_u32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0xc0,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_inc_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0xc0,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_inc_u64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x00,0x13,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_inc_u64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x00,0x13,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_inc_u64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x13,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_inc_u64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x13,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_num_f32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x14,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_num_f32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x14,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_num_f32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x80,0x14,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_num_f32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x80,0x14,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_i32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_i32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_i32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x80,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_i32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x80,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_i64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_i64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0xc0,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_i64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_i64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_u32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0xc0,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0xc0,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_u64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x00,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_u64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x00,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_max_u64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_max_u64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_num_f32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x14,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_num_f32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x14,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_num_f32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x40,0x14,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_num_f32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x40,0x14,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_i32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_i32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_i32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x00,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_i32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x00,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_i64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x40,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_i64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x40,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_i64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_i64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0e,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_u32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x40,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x40,0x0e,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_u64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x80,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_u64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x80,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_min_u64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_min_u64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_or_b32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_or_b32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_or_b32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x40,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_or_b32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x40,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_or_b64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x80,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_or_b64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x80,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_or_b64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_or_b64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_sub_clamp_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_sub_clamp_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_sub_clamp_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0xc0,0x0d,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_sub_u32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_sub_u32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0d,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_sub_u32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x80,0x0d,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_sub_u32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x80,0x0d,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_sub_u64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x00,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_sub_u64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x00,0x11,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_sub_u64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_sub_u64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x11,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

flat_atomic_swap_b32 v0, v[1:2], v3 offset:-2048 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x90,0x01,0x01,0x00,0xf8,0xff]

flat_atomic_swap_b32 v0, v[1:2], v3 offset:2048 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x90,0x01,0x01,0x00,0x08,0x00]

flat_atomic_swap_b32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_swap_b32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_swap_b32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_swap_b32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0xc0,0x0c,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_swap_b64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_swap_b64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_swap_b64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_swap_b64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00]

flat_atomic_swap_b64 v[1:2], v[3:4], v[5:6] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xec,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00]

flat_atomic_xor_b32 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_xor_b32 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0f,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_xor_b32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x80,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_xor_b32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x80,0x0f,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_xor_b64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_xor_b64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0xc0,0x12,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_xor_b64 v[1:2], v[0:1], v[2:3] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_xor_b64 v[1:2], v[0:1], v[2:3] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x12,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_pk_add_f16 v1, v[0:1], v2 offset:-8000000 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0x00,0xee,0x85]

flat_atomic_pk_add_f16 v1, v[0:1], v2 offset:8000000 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0x00,0x12,0x7a]

flat_atomic_pk_add_f16 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_pk_add_f16 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_pk_add_f16 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x40,0x16,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_pk_add_f16 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x40,0x16,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_pk_add_f16 v[0:1], v2
// GFX12: encoding: [0x7c,0x40,0x16,0xec,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00]

flat_atomic_pk_add_bf16 v1, v[0:1], v2 offset:-8000000 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0x00,0xee,0x85]

flat_atomic_pk_add_bf16 v1, v[0:1], v2 offset:8000000 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0x00,0x12,0x7a]

flat_atomic_pk_add_bf16 v1, v[0:1], v2 offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_pk_add_bf16 v1, v[0:1], v2 offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x16,0xec,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

flat_atomic_pk_add_bf16 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x80,0x16,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_atomic_pk_add_bf16 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x80,0x16,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_atomic_pk_add_bf16 v[0:1], v2
// GFX12: encoding: [0x7c,0x80,0x16,0xec,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00]

flat_load_b128 v[1:4], v[0:1] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_b128 v[1:4], v[0:1] offset:64
// GFX12: encoding: [0x7c,0xc0,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_b128 v[1:4], v[5:6]
// GFX12: encoding: [0x7c,0xc0,0x05,0xec,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00]

flat_load_b32 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_b32 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_b32 v1, v[3:4] offset:2047
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0xff,0x07,0x00]

flat_load_b32 v1, v[3:4] offset:-2048
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0xf8,0xff]

flat_load_b32 v1, v[3:4] offset:2048
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x08,0x00]

flat_load_b32 v1, v[3:4] offset:-4
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0xfc,0xff,0xff]

flat_load_b32 v1, v[3:4] offset:4
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0x04,0x00,0x00]

flat_load_b32 v1, v[3:4] offset:-4
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0xfc,0xff,0xff]

flat_load_b32 v1, v[3:4] offset:4
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0x04,0x00,0x00]

flat_load_b32 v1, v[3:4] offset:-4
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0xfc,0xff,0xff]

flat_load_b32 v1, v[3:4] offset:4
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0x04,0x00,0x00]

flat_load_b32 v1, v[3:4]
// GFX12: encoding: [0x7c,0x00,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_b64 v[1:2], v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x40,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_b64 v[1:2], v[0:1] offset:64
// GFX12: encoding: [0x7c,0x40,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_b64 v[1:2], v[3:4]
// GFX12: encoding: [0x7c,0x40,0x05,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_b96 v[1:3], v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x80,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_b96 v[1:3], v[0:1] offset:64
// GFX12: encoding: [0x7c,0x80,0x05,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_b96 v[1:3], v[5:6]
// GFX12: encoding: [0x7c,0x80,0x05,0xec,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00]

flat_load_d16_b16 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x00,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_d16_b16 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x00,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_d16_b16 v1, v[3:4]
// GFX12: encoding: [0x7c,0x00,0x08,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_d16_hi_b16 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_d16_hi_b16 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0xc0,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_d16_hi_b16 v1, v[3:4]
// GFX12: encoding: [0x7c,0xc0,0x08,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_d16_hi_i8 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x80,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_d16_hi_i8 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x80,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_d16_hi_i8 v1, v[3:4]
// GFX12: encoding: [0x7c,0x80,0x08,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_d16_hi_u8 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x40,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_d16_hi_u8 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x40,0x08,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_d16_hi_u8 v1, v[3:4]
// GFX12: encoding: [0x7c,0x40,0x08,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_d16_i8 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x07,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_d16_i8 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0xc0,0x07,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_d16_i8 v1, v[3:4]
// GFX12: encoding: [0x7c,0xc0,0x07,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_d16_u8 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x80,0x07,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_d16_u8 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x80,0x07,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_d16_u8 v1, v[3:4]
// GFX12: encoding: [0x7c,0x80,0x07,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_i16 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_i16 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0xc0,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_i16 v1, v[3:4]
// GFX12: encoding: [0x7c,0xc0,0x04,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_i8 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x40,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_i8 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x40,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_i8 v1, v[3:4]
// GFX12: encoding: [0x7c,0x40,0x04,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_u16 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x80,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_u16 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x80,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_u16 v1, v[3:4]
// GFX12: encoding: [0x7c,0x80,0x04,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_load_u8 v1, v[0:1] offset:-64
// GFX12: encoding: [0x7c,0x00,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

flat_load_u8 v1, v[0:1] offset:64
// GFX12: encoding: [0x7c,0x00,0x04,0xec,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

flat_load_u8 v1, v[3:4]
// GFX12: encoding: [0x7c,0x00,0x04,0xec,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

flat_store_b128 v[0:1], v[2:5] offset:-64
// GFX12: encoding: [0x7c,0x40,0x07,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_b128 v[0:1], v[2:5] offset:64
// GFX12: encoding: [0x7c,0x40,0x07,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_b128 v[1:2], v[3:6]
// GFX12: encoding: [0x7c,0x40,0x07,0xec,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

flat_store_b16 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x40,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_b16 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x40,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_b16 v[3:4], v1
// GFX12: encoding: [0x7c,0x40,0x06,0xec,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

flat_store_b32 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x80,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_b32 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x80,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_b32 v[3:4], v1 offset:-16
// GFX12: encoding: [0x7c,0x80,0x06,0xec,0x00,0x00,0x80,0x00,0x03,0xf0,0xff,0xff]

flat_store_b32 v[3:4], v1 offset:16
// GFX12: encoding: [0x7c,0x80,0x06,0xec,0x00,0x00,0x80,0x00,0x03,0x10,0x00,0x00]

flat_store_b64 v[0:1], v[2:3] offset:-64
// GFX12: encoding: [0x7c,0xc0,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_b64 v[0:1], v[2:3] offset:64
// GFX12: encoding: [0x7c,0xc0,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_b64 v[1:2], v[3:4]
// GFX12: encoding: [0x7c,0xc0,0x06,0xec,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

flat_store_b8 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x00,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_b8 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x00,0x06,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_b8 v[3:4], v1
// GFX12: encoding: [0x7c,0x00,0x06,0xec,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

flat_store_b96 v[0:1], v[2:4] offset:-64
// GFX12: encoding: [0x7c,0x00,0x07,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_b96 v[0:1], v[2:4] offset:64
// GFX12: encoding: [0x7c,0x00,0x07,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_b96 v[1:2], v[3:5]
// GFX12: encoding: [0x7c,0x00,0x07,0xec,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

flat_store_d16_hi_b16 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x40,0x09,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_d16_hi_b16 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x40,0x09,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_d16_hi_b16 v[3:4], v1
// GFX12: encoding: [0x7c,0x40,0x09,0xec,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

flat_store_d16_hi_b8 v[0:1], v2 offset:-64
// GFX12: encoding: [0x7c,0x00,0x09,0xec,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

flat_store_d16_hi_b8 v[0:1], v2 offset:64
// GFX12: encoding: [0x7c,0x00,0x09,0xec,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

flat_store_d16_hi_b8 v[3:4], v1
// GFX12: encoding: [0x7c,0x00,0x09,0xec,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_atomic_add_f32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x15,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_f32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x15,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_f32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x15,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_f32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x15,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_f32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x15,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_f32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x15,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_f32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x15,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_f32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x15,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_add_u64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_add_u64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x40,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_and_b64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_and_b64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x00,0x0d,0xee,0x00,0x00,0x10,0x01,0x01,0x00,0x00,0x00]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x00,0x0d,0xee,0x00,0x00,0x10,0x01,0x01,0x00,0x00,0x00]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x00,0x0d,0xee,0x00,0x00,0x10,0x01,0x01,0xff,0x07,0x00]

global_atomic_cmpswap_b32 v0, v1, v[2:3], s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x00,0x0d,0xee,0x00,0x00,0x10,0x01,0x01,0xff,0x07,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

global_atomic_cmpswap_b32 v0, v[1:2], v[3:4], off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

global_atomic_cmpswap_b32 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cmpswap_b32 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_cmpswap_b32 v1, v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cmpswap_b32 v1, v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_cmpswap_b32 v1, v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cmpswap_b32 v1, v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_cmpswap_b32 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cmpswap_b32 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x00,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_cmpswap_b64 v0, v[2:5], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cmpswap_b64 v0, v[2:5], s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_cmpswap_b64 v[0:1], v[2:5], off offset:-64
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cmpswap_b64 v[0:1], v[2:5], off offset:64
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_cmpswap_b64 v[1:2], v0, v[2:5], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xf

global_atomic_cmpswap_b64 v[1:2], v0, v[2:5], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x

global_atomic_cmpswap_b64 v[1:2], v3, v[5:8], s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x

global_atomic_cmpswap_b64 v[1:2], v[0:1], v[2:5], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0x

global_atomic_cmpswap_b64 v[1:2], v[0:1], v[2:5], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x0

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0

global_atomic_cmpswap_b64 v[1:2], v[3:4], v[5:8], off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0

global_atomic_cond_sub_u32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cond_sub_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_cond_sub_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cond_sub_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_cond_sub_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cond_sub_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_cond_sub_u32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_cond_sub_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_clamp_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_clamp_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_clamp_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_clamp_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_clamp_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_clamp_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_f16 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_f16 v1, v0, v2, s[0:1] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0x00,0x00,0x00]

global_atomic_pk_add_f16 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_f16 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_f16 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_f16 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_f16 v0, v2, s[0:1]
// GFX12: encoding: [0x00,0x40,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00]

global_atomic_pk_add_f16 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_f16 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_f16 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_bf16 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_bf16 v1, v0, v2, s[0:1] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0x00,0x00,0x00]

global_atomic_pk_add_bf16 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_bf16 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_bf16 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x16,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_bf16 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_bf16 v0, v2, s[0:1]
// GFX12: encoding: [0x00,0x80,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00]

global_atomic_pk_add_bf16 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_pk_add_bf16 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_pk_add_bf16 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x16,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x40,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_dec_u64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_dec_u64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x00,0x13,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_inc_u64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_inc_u64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x13,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_num_f32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_num_f32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_num_f32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_num_f32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_num_f32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_num_f32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_num_f32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_num_f32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_i64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_i64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x00,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_max_u64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_max_u64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_num_f32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_num_f32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_num_f32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_num_f32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_num_f32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_num_f32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x14,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_num_f32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_num_f32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x14,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x40,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_i64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_i64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0e,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x0e,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x80,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x80,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_min_u64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_min_u64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x80,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x80,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_or_b64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_or_b64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_ordered_add_b64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x1c,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_ordered_add_b64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x1c,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_ordered_add_b64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x1c,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_ordered_add_b64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x1c,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_ordered_add_b64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x1c,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_ordered_add_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x1c,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_ordered_add_b64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x1c,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_ordered_add_b64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x1c,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0d,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x0d,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x00,0x11,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x00,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_sub_u64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_sub_u64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x00,0x11,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b32 v0, v1, v3, s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

global_atomic_swap_b32 v0, v1, v3, s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

global_atomic_swap_b32 v0, v1, v3, s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

global_atomic_swap_b32 v0, v1, v3, s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

global_atomic_swap_b32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x0c,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x0c,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0x00,0x00,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

global_atomic_swap_b32 v0, v[1:2], v3, off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x00,0x00,0x90,0x01,0x01,0xff,0x07,0x00]

global_atomic_swap_b32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0c,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x0c,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x0c,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x40,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00]

global_atomic_swap_b64 v[1:2], v3, v[5:6], s[2:3] offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x02,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00]

global_atomic_swap_b64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_swap_b64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0x00,0x00,0x00]

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00

global_atomic_swap_b64 v[1:2], v[3:4], v[5:6], off offset:2047 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x40,0x10,0xee,0x01,0x00,0x90,0x02,0x03,0xff,0x07,0x00

global_atomic_xor_b32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_xor_b32 v1, v0, v2, s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b32 v1, v0, v2, s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0x80,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_xor_b32 v1, v[0:1], v2, off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b32 v1, v[0:1], v2, off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0x80,0x0f,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_xor_b32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x0f,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_xor_b64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_xor_b64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x12,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_atomic_xor_b64 v[1:2], v0, v[2:3], s[0:1] offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b64 v[1:2], v0, v[2:3], s[0:1] offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x00,0xc0,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_atomic_xor_b64 v[1:2], v[0:1], v[2:3], off offset:-64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0xc0,0xff,0xff]

global_atomic_xor_b64 v[1:2], v[0:1], v[2:3], off offset:64 th:TH_ATOMIC_RETURN
// GFX12: encoding: [0x7c,0xc0,0x12,0xee,0x01,0x00,0x10,0x01,0x00,0x40,0x00,0x00]

global_load_addtid_b32 v1, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x0a,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_addtid_b32 v1, off offset:64
// GFX12: encoding: [0x7c,0x00,0x0a,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_addtid_b32 v1, off
// GFX12: encoding: [0x7c,0x00,0x0a,0xee,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

global_load_addtid_b32 v1, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x0a,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_addtid_b32 v1, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x0a,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_addtid_b32 v1, s[2:3]
// GFX12: encoding: [0x02,0x00,0x0a,0xee,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

global_load_b128 v[1:4], v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b128 v[1:4], v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b128 v[1:4], v5, s[2:3]
// GFX12: encoding: [0x02,0xc0,0x05,0xee,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00]

global_load_b128 v[1:4], v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b128 v[1:4], v[0:1], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b128 v[1:4], v[5:6], off
// GFX12: encoding: [0x7c,0xc0,0x05,0xee,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00]

global_load_b32 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b32 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b32 v1, v3, s[2:3] offset:2047
// GFX12: encoding: [0x02,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x03,0xff,0x07,0x00]

global_load_b32 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_b32 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b32 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b32 v1, v[3:4], off offset:2047
// GFX12: encoding: [0x7c,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x03,0xff,0x07,0x00]

global_load_b32 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x00,0x05,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_b64 v[1:2], v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b64 v[1:2], v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b64 v[1:2], v3, s[2:3]
// GFX12: encoding: [0x02,0x40,0x05,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_b64 v[1:2], v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b64 v[1:2], v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x40,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b64 v[1:2], v[3:4], off
// GFX12: encoding: [0x7c,0x40,0x05,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_b96 v[1:3], v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b96 v[1:3], v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b96 v[1:3], v5, s[2:3]
// GFX12: encoding: [0x02,0x80,0x05,0xee,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00]

global_load_b96 v[1:3], v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x80,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_b96 v[1:3], v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x80,0x05,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_b96 v[1:3], v[5:6], off
// GFX12: encoding: [0x7c,0x80,0x05,0xee,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00]

global_load_d16_b16 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_b16 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_b16 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x00,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_b16 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_b16 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x00,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_b16 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x00,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_hi_b16 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_hi_b16 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_hi_b16 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0xc0,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_hi_b16 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_hi_b16 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_hi_b16 v1, v[3:4], off
// GFX12: encoding: [0x7c,0xc0,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_hi_i8 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_hi_i8 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_hi_i8 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x80,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_hi_i8 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x80,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_hi_i8 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x80,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_hi_i8 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x80,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_hi_u8 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_hi_u8 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_hi_u8 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x40,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_hi_u8 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_hi_u8 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x40,0x08,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_hi_u8 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x40,0x08,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_i8 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_i8 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_i8 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0xc0,0x07,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_i8 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_i8 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_i8 v1, v[3:4], off
// GFX12: encoding: [0x7c,0xc0,0x07,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_u8 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_u8 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_u8 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x80,0x07,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_d16_u8 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x80,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_d16_u8 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x80,0x07,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_d16_u8 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x80,0x07,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_i16 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_i16 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_i16 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0xc0,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_i16 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_i16 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_i16 v1, v[3:4], off
// GFX12: encoding: [0x7c,0xc0,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_i8 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_i8 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_i8 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x40,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_i8 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_i8 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x40,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_i8 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x40,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_u16 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_u16 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_u16 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x80,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_u16 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x80,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_u16 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x80,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_u16 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x80,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_u8 v1, v0, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_u8 v1, v0, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_u8 v1, v3, s[2:3]
// GFX12: encoding: [0x02,0x00,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_load_u8 v1, v[0:1], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

global_load_u8 v1, v[0:1], off offset:64
// GFX12: encoding: [0x7c,0x00,0x04,0xee,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

global_load_u8 v1, v[3:4], off
// GFX12: encoding: [0x7c,0x00,0x04,0xee,0x01,0x00,0x00,0x00,0x03,0x00,0x00,0x00]

global_store_addtid_b32 v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x0a,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_addtid_b32 v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x0a,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_addtid_b32 v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x0a,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_addtid_b32 v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x0a,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b128 v0, v[2:5], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b128 v0, v[2:5], s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b128 v1, v[3:6], s[2:3]
// GFX12: encoding: [0x02,0x40,0x07,0xee,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

global_store_b128 v[0:1], v[2:5], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b128 v[0:1], v[2:5], off offset:64
// GFX12: encoding: [0x7c,0x40,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b128 v[1:2], v[3:6], off
// GFX12: encoding: [0x7c,0x40,0x07,0xee,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

global_store_b16 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b16 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b16 v3, v1, s[2:3]
// GFX12: encoding: [0x02,0x40,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_store_b16 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b16 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b16 v[3:4], v1, off
// GFX12: encoding: [0x7c,0x40,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_store_b32 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x80,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b32 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x80,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b32 v3, v1, s[2:3] offset:-16
// GFX12: encoding: [0x02,0x80,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0xf0,0xff,0xff]

global_store_b32 v3, v1, s[2:3] offset:16
// GFX12: encoding: [0x02,0x80,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0x10,0x00,0x00]

global_store_b32 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b32 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b32 v[3:4], v1, off offset:-16
// GFX12: encoding: [0x7c,0x80,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0xf0,0xff,0xff]

global_store_b32 v[3:4], v1, off offset:16
// GFX12: encoding: [0x7c,0x80,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0x10,0x00,0x00]

global_store_b64 v0, v[2:3], s[0:1] offset:-64
// GFX12: encoding: [0x00,0xc0,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b64 v0, v[2:3], s[0:1] offset:64
// GFX12: encoding: [0x00,0xc0,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b64 v1, v[2:3], s[2:3]
// GFX12: encoding: [0x02,0xc0,0x06,0xee,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00]

global_store_b64 v[0:1], v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b64 v[0:1], v[2:3], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b64 v[1:2], v[3:4], off
// GFX12: encoding: [0x7c,0xc0,0x06,0xee,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

global_store_b8 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b8 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b8 v3, v1, s[2:3]
// GFX12: encoding: [0x02,0x00,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_store_b8 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b8 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x06,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b8 v[3:4], v1, off
// GFX12: encoding: [0x7c,0x00,0x06,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_store_b96 v0, v[2:4], s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b96 v0, v[2:4], s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b96 v1, v[3:5], s[2:3]
// GFX12: encoding: [0x02,0x00,0x07,0xee,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

global_store_b96 v[0:1], v[2:4], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_b96 v[0:1], v[2:4], off offset:64
// GFX12: encoding: [0x7c,0x00,0x07,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_b96 v[1:2], v[3:5], off
// GFX12: encoding: [0x7c,0x00,0x07,0xee,0x00,0x00,0x80,0x01,0x01,0x00,0x00,0x00]

global_store_d16_hi_b16 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x40,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_d16_hi_b16 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x40,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_d16_hi_b16 v3, v1, s[2:3]
// GFX12: encoding: [0x02,0x40,0x09,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_store_d16_hi_b16 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_d16_hi_b16 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_d16_hi_b16 v[3:4], v1, off
// GFX12: encoding: [0x7c,0x40,0x09,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_store_d16_hi_b8 v0, v2, s[0:1] offset:-64
// GFX12: encoding: [0x00,0x00,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_d16_hi_b8 v0, v2, s[0:1] offset:64
// GFX12: encoding: [0x00,0x00,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_d16_hi_b8 v3, v1, s[2:3]
// GFX12: encoding: [0x02,0x00,0x09,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_store_d16_hi_b8 v[0:1], v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

global_store_d16_hi_b8 v[0:1], v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x09,0xee,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

global_store_d16_hi_b8 v[3:4], v1, off
// GFX12: encoding: [0x7c,0x00,0x09,0xee,0x00,0x00,0x80,0x00,0x03,0x00,0x00,0x00]

global_inv
// GFX12: encoding: [0x7c,0xc0,0x0a,0xee,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

global_inv scope:SCOPE_DEV
// GFX12: encoding: [0x7c,0xc0,0x0a,0xee,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00]

global_inv scope:SCOPE_SYS
// GFX12: encoding: [0x7c,0xc0,0x0a,0xee,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00]

global_wb
// GFX12: encoding: [0x7c,0x00,0x0b,0xee,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

global_wb scope:SCOPE_DEV
// GFX12: encoding: [0x7c,0x00,0x0b,0xee,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00]

global_wb scope:SCOPE_SYS
// GFX12: encoding: [0x7c,0x00,0x0b,0xee,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00]

global_wbinv
// GFX12: encoding: [0x7c,0xc0,0x13,0xee,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

global_wbinv scope:SCOPE_DEV
// GFX12: encoding: [0x7c,0xc0,0x13,0xee,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00]

global_wbinv scope:SCOPE_SYS
// GFX12: encoding: [0x7c,0xc0,0x13,0xee,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00]

scratch_load_b128 v[1:4], off, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b128 v[1:4], off, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b128 v[1:4], off, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b128 v[1:4], off, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b128 v[1:4], v0, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b128 v[1:4], v0, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b128 v[1:4], v0, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b128 v[1:4], v0, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b128 v[1:4], v2, s1
// GFX12: encoding: [0x01,0xc0,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_b32 v1, off, off offset:2047
// GFX12: encoding: [0x7c,0x00,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xff,0x07,0x00]

scratch_load_b32 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b32 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x00,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b32 v1, off, off
// GFX12: encoding: [0x7c,0x00,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00]

scratch_load_b32 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b32 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b32 v1, off, s1 offset:2047
// GFX12: encoding: [0x01,0x00,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xff,0x07,0x00]

scratch_load_b32 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b32 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b32 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b32 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b32 v1, v2, off offset:2047
// GFX12: encoding: [0x7c,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0xff,0x07,0x00]

scratch_load_b32 v1, v2, s1 offset:-61440
// GFX12: encoding: [0x01,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x10,0xff]

scratch_load_b32 v1, v2, s1 offset:61440
// GFX12: encoding: [0x01,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0xf0,0x00]

scratch_load_b32 v1, v2, s1 offset:2047
// GFX12: encoding: [0x01,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0xff,0x07,0x00]

scratch_load_b32 v1, v2, s1 offset:-4095
// GFX12: encoding: [0x01,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0x01,0xf0,0xff]

scratch_load_b32 v1, v2, s1 offset:4095
// GFX12: encoding: [0x01,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0xff,0x0f,0x00]

scratch_load_b32 v1, v2, s1
// GFX12: encoding: [0x01,0x00,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_b64 v[1:2], off, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b64 v[1:2], off, off offset:64
// GFX12: encoding: [0x7c,0x40,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b64 v[1:2], off, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b64 v[1:2], off, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b64 v[1:2], v0, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b64 v[1:2], v0, off offset:64
// GFX12: encoding: [0x7c,0x40,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b64 v[1:2], v0, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b64 v[1:2], v0, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b64 v[1:2], v2, s1
// GFX12: encoding: [0x01,0x40,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_b96 v[1:3], off, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b96 v[1:3], off, off offset:64
// GFX12: encoding: [0x7c,0x80,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b96 v[1:3], off, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b96 v[1:3], off, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x05,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_b96 v[1:3], v0, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b96 v[1:3], v0, off offset:64
// GFX12: encoding: [0x7c,0x80,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b96 v[1:3], v0, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_b96 v[1:3], v0, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x05,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_b96 v[1:3], v2, s1
// GFX12: encoding: [0x01,0x80,0x05,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_d16_b16 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_b16 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x00,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_b16 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_b16 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_b16 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_b16 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x00,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_b16 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_b16 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_b16 v1, v2, s1
// GFX12: encoding: [0x01,0x00,0x08,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_d16_hi_b16 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_b16 v1, off, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_b16 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_b16 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_b16 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_b16 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_b16 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_b16 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_b16 v1, v2, s1
// GFX12: encoding: [0x01,0xc0,0x08,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_d16_hi_i8 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_i8 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x80,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_i8 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_i8 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_i8 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_i8 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x80,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_i8 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_i8 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_i8 v1, v2, s1
// GFX12: encoding: [0x01,0x80,0x08,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_d16_hi_u8 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_u8 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x40,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_u8 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_u8 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x08,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_u8 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_u8 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x40,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_u8 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_hi_u8 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x08,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_hi_u8 v1, v2, s1
// GFX12: encoding: [0x01,0x40,0x08,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_d16_i8 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_i8 v1, off, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_i8 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_i8 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_i8 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_i8 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_i8 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_i8 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_i8 v1, v2, s1
// GFX12: encoding: [0x01,0xc0,0x07,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_d16_u8 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_u8 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x80,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_u8 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_u8 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x07,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_u8 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_u8 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x80,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_u8 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_d16_u8 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x07,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_d16_u8 v1, v2, s1
// GFX12: encoding: [0x01,0x80,0x07,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_i16 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i16 v1, off, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_i16 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i16 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_i16 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i16 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0xc0,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_i16 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i16 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_i16 v1, v2, s1
// GFX12: encoding: [0x01,0xc0,0x04,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_i8 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i8 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x40,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_i8 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i8 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_i8 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i8 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x40,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_i8 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_i8 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_i8 v1, v2, s1
// GFX12: encoding: [0x01,0x40,0x04,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_u16 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u16 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x80,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_u16 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u16 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_u16 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u16 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x80,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_u16 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u16 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_u16 v1, v2, s1
// GFX12: encoding: [0x01,0x80,0x04,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_load_u8 v1, off, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u8 v1, off, off offset:64
// GFX12: encoding: [0x7c,0x00,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_u8 v1, off, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u8 v1, off, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x04,0xed,0x01,0x00,0x00,0x00,0x00,0x40,0x00,0x00]

scratch_load_u8 v1, v0, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u8 v1, v0, off offset:64
// GFX12: encoding: [0x7c,0x00,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_u8 v1, v0, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0xc0,0xff,0xff]

scratch_load_u8 v1, v0, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x04,0xed,0x01,0x00,0x02,0x00,0x00,0x40,0x00,0x00]

scratch_load_u8 v1, v2, s1
// GFX12: encoding: [0x01,0x00,0x04,0xed,0x01,0x00,0x02,0x00,0x02,0x00,0x00,0x00]

scratch_store_b128 off, v[2:5], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b128 off, v[2:5], off offset:64
// GFX12: encoding: [0x7c,0x40,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b128 off, v[2:5], s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b128 off, v[2:5], s0 offset:64
// GFX12: encoding: [0x00,0x40,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b128 v0, v[2:5], off offset:-64
// GFX12: encoding: [0x7c,0x40,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b128 v0, v[2:5], off offset:64
// GFX12: encoding: [0x7c,0x40,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b128 v0, v[2:5], s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b128 v0, v[2:5], s0 offset:64
// GFX12: encoding: [0x00,0x40,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b128 v1, v[2:5], s3
// GFX12: encoding: [0x03,0x40,0x07,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]

scratch_store_b16 off, v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b16 off, v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b16 off, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b16 off, v2, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b16 v0, v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b16 v0, v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b16 v0, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b16 v0, v2, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b16 v1, v2, s3
// GFX12: encoding: [0x03,0x40,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]

scratch_store_b32 off, v2, off offset:2047
// GFX12: encoding: [0x7c,0x80,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xff,0x07,0x00]

scratch_store_b32 off, v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b32 off, v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b32 off, v2, off
// GFX12: encoding: [0x7c,0x80,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00]

scratch_store_b32 off, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b32 off, v2, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b32 off, v2, s3 offset:2047
// GFX12: encoding: [0x03,0x80,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xff,0x07,0x00]

scratch_store_b32 v0, v2, off offset:-64
// GFX12: encoding: [0x7c,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b32 v0, v2, off offset:64
// GFX12: encoding: [0x7c,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b32 v0, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b32 v0, v2, s0 offset:64
// GFX12: encoding: [0x00,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b32 v1, v2, off offset:2047
// GFX12: encoding: [0x7c,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0xff,0x07,0x00]

scratch_store_b32 v1, v2, s1 offset:-61440
// GFX12: encoding: [0x01,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x10,0xff]

scratch_store_b32 v1, v2, s1 offset:61440
// GFX12: encoding: [0x01,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0xf0,0x00]

scratch_store_b32 v1, v2, s1 offset:-4095
// GFX12: encoding: [0x01,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0x01,0xf0,0xff]

scratch_store_b32 v1, v2, s1 offset:4095
// GFX12: encoding: [0x01,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0xff,0x0f,0x00]

scratch_store_b32 v1, v2, s3 offset:2047
// GFX12: encoding: [0x03,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0xff,0x07,0x00]

scratch_store_b32 v1, v2, s3
// GFX12: encoding: [0x03,0x80,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]

scratch_store_b64 off, v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b64 off, v[2:3], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b64 off, v[2:3], s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b64 off, v[2:3], s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b64 v0, v[2:3], off offset:-64
// GFX12: encoding: [0x7c,0xc0,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b64 v0, v[2:3], off offset:64
// GFX12: encoding: [0x7c,0xc0,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b64 v0, v[2:3], s0 offset:-64
// GFX12: encoding: [0x00,0xc0,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b64 v0, v[2:3], s0 offset:64
// GFX12: encoding: [0x00,0xc0,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b64 v1, v[2:3], s3
// GFX12: encoding: [0x03,0xc0,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]

scratch_store_b8 off, v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b8 off, v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b8 off, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b8 off, v2, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x06,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b8 v0, v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b8 v0, v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b8 v0, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b8 v0, v2, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x06,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b8 v1, v2, s3
// GFX12: encoding: [0x03,0x00,0x06,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]

scratch_store_b96 off, v[2:4], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b96 off, v[2:4], off offset:64
// GFX12: encoding: [0x7c,0x00,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b96 off, v[2:4], s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b96 off, v[2:4], s0 offset:64
// GFX12: encoding: [0x00,0x00,0x07,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_b96 v0, v[2:4], off offset:-64
// GFX12: encoding: [0x7c,0x00,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b96 v0, v[2:4], off offset:64
// GFX12: encoding: [0x7c,0x00,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b96 v0, v[2:4], s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_b96 v0, v[2:4], s0 offset:64
// GFX12: encoding: [0x00,0x00,0x07,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_b96 v1, v[2:4], s3
// GFX12: encoding: [0x03,0x00,0x07,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]

scratch_store_d16_hi_b16 off, v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b16 off, v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b16 off, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b16 off, v2, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b16 v0, v2, off offset:-64
// GFX12: encoding: [0x7c,0x40,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b16 v0, v2, off offset:64
// GFX12: encoding: [0x7c,0x40,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b16 v0, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x40,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b16 v0, v2, s0 offset:64
// GFX12: encoding: [0x00,0x40,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b16 v1, v2, s3
// GFX12: encoding: [0x03,0x40,0x09,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]

scratch_store_d16_hi_b8 off, v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b8 off, v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b8 off, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b8 off, v2, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x09,0xed,0x00,0x00,0x00,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b8 v0, v2, off offset:-64
// GFX12: encoding: [0x7c,0x00,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b8 v0, v2, off offset:64
// GFX12: encoding: [0x7c,0x00,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b8 v0, v2, s0 offset:-64
// GFX12: encoding: [0x00,0x00,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0xc0,0xff,0xff]

scratch_store_d16_hi_b8 v0, v2, s0 offset:64
// GFX12: encoding: [0x00,0x00,0x09,0xed,0x00,0x00,0x02,0x01,0x00,0x40,0x00,0x00]

scratch_store_d16_hi_b8 v1, v2, s3
// GFX12: encoding: [0x03,0x00,0x09,0xed,0x00,0x00,0x02,0x01,0x01,0x00,0x00,0x00]
