; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S -passes=constraint-elimination < %s | FileCheck %s

declare void @use(i1)

define void @signed_iv_step_1(i64 %end) {
; CHECK-LABEL: define void @signed_iv_step_1(
; CHECK-SAME: i64 [[END:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sge i64 [[END]], -10
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ -10, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %precond = icmp sge i64 %end, -10
  br i1 %precond, label %loop, label %exit

loop:
  %iv = phi i64 [ %iv.next, %loop.latch ], [ -10, %entry ]
  %iv.next = add i64 %iv, 1
  %cmp.i.not = icmp eq i64 %iv, %end
  br i1 %cmp.i.not, label %exit, label %loop.latch

loop.latch:
  %cmp2 = icmp slt i64 %iv, %end
  call void @use(i1 %cmp2)
  %cmp3 = icmp sge i64 %iv, -10
  call void @use(i1 %cmp3)
  br label %loop

exit:
  ret void
}

define void @signed_iv_step_4(i64 %count) {
; CHECK-LABEL: define void @signed_iv_step_4(
; CHECK-SAME: i64 [[COUNT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[END:%.*]] = shl nsw i64 [[COUNT]], 2
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sgt i64 [[COUNT]], -1
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 4
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %end = shl nsw i64 %count, 2
  %precond = icmp sgt i64 %count, -1
  br i1 %precond, label %loop, label %exit

loop:
  %iv = phi i64 [ %iv.next, %loop.latch ], [ 0, %entry ]
  %iv.next = add i64 %iv, 4
  %cmp.i.not = icmp eq i64 %iv, %end
  br i1 %cmp.i.not, label %exit, label %loop.latch

loop.latch:
  %cmp2 = icmp slt i64 %iv, %end
  call void @use(i1 %cmp2)
  %cmp3 = icmp sge i64 %iv, 0
  call void @use(i1 %cmp3)
  br label %loop

exit:
  ret void
}

define void @signed_iv_step_4_missing_precond(i64 %count) {
; CHECK-LABEL: define void @signed_iv_step_4_missing_precond(
; CHECK-SAME: i64 [[COUNT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[END:%.*]] = shl i64 [[COUNT]], 2
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sgt i64 [[COUNT]], -1
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 4
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i64 [[IV]], [[END]]
; CHECK-NEXT:    call void @use(i1 [[CMP2]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sge i64 [[IV]], 0
; CHECK-NEXT:    call void @use(i1 [[CMP3]])
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %end = shl i64 %count, 2
  %precond = icmp sgt i64 %count, -1
  br i1 %precond, label %loop, label %exit

loop:
  %iv = phi i64 [ %iv.next, %loop.latch ], [ 0, %entry ]
  %iv.next = add i64 %iv, 4
  %cmp.i.not = icmp eq i64 %iv, %end
  br i1 %cmp.i.not, label %exit, label %loop.latch

loop.latch:
  %cmp2 = icmp slt i64 %iv, %end
  call void @use(i1 %cmp2)
  %cmp3 = icmp sge i64 %iv, 0
  call void @use(i1 %cmp3)
  br label %loop

exit:
  ret void
}

define void @signed_iv_step_4_start_4(i64 %count) {
; CHECK-LABEL: define void @signed_iv_step_4_start_4(
; CHECK-SAME: i64 [[COUNT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[END:%.*]] = shl nsw i64 [[COUNT]], 2
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sgt i64 [[COUNT]], 0
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 4, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 4
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %end = shl nsw i64 %count, 2
  %precond = icmp sgt i64 %count, 0
  br i1 %precond, label %loop, label %exit

loop:
  %iv = phi i64 [ %iv.next, %loop.latch ], [ 4, %entry ]
  %iv.next = add i64 %iv, 4
  %cmp.i.not = icmp eq i64 %iv, %end
  br i1 %cmp.i.not, label %exit, label %loop.latch

loop.latch:
  %cmp2 = icmp slt i64 %iv, %end
  call void @use(i1 %cmp2)
  %cmp3 = icmp sge i64 %iv, 4
  call void @use(i1 %cmp3)
  br label %loop

exit:
  ret void
}

define void @signed_iv_step_4_start_4_missing_precond(i64 %count) {
; CHECK-LABEL: define void @signed_iv_step_4_start_4_missing_precond(
; CHECK-SAME: i64 [[COUNT:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[END:%.*]] = shl nsw i64 [[COUNT]], 2
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sgt i64 [[COUNT]], -1
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 4, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 4
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i64 [[IV]], [[END]]
; CHECK-NEXT:    call void @use(i1 [[CMP2]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sge i64 [[IV]], 4
; CHECK-NEXT:    call void @use(i1 [[CMP3]])
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %end = shl nsw i64 %count, 2
  %precond = icmp sgt i64 %count, -1
  br i1 %precond, label %loop, label %exit

loop:
  %iv = phi i64 [ %iv.next, %loop.latch ], [ 4, %entry ]
  %iv.next = add i64 %iv, 4
  %cmp.i.not = icmp eq i64 %iv, %end
  br i1 %cmp.i.not, label %exit, label %loop.latch

loop.latch:
  %cmp2 = icmp slt i64 %iv, %end
  call void @use(i1 %cmp2)
  %cmp3 = icmp sge i64 %iv, 4
  call void @use(i1 %cmp3)
  br label %loop

exit:
  ret void
}

define void @signed_iv_step_minus1(i64 %end) {
; CHECK-LABEL: define void @signed_iv_step_minus1(
; CHECK-SAME: i64 [[END:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sle i64 [[END]], 10
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 10, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], -1
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %precond = icmp sle i64 %end, 10
  br i1 %precond, label %loop, label %exit

loop:
  %iv = phi i64 [ %iv.next, %loop.latch ], [ 10, %entry ]
  %iv.next = add i64 %iv, -1
  %cmp.i.not = icmp eq i64 %iv, %end
  br i1 %cmp.i.not, label %exit, label %loop.latch

loop.latch:
  %cmp2 = icmp sgt i64 %iv, %end
  call void @use(i1 %cmp2)
  %cmp3 = icmp sle i64 %iv, 10
  call void @use(i1 %cmp3)
  br label %loop

exit:
  ret void
}

define void @signed_iv_step_minus1_missing_precond(i64 %end) {
; CHECK-LABEL: define void @signed_iv_step_minus1_missing_precond(
; CHECK-SAME: i64 [[END:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[PRECOND:%.*]] = icmp sle i64 [[END]], 11
; CHECK-NEXT:    br i1 [[PRECOND]], label [[LOOP:%.*]], label [[EXIT:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ [[IV_NEXT:%.*]], [[LOOP_LATCH:%.*]] ], [ 10, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], -1
; CHECK-NEXT:    [[CMP_I_NOT:%.*]] = icmp eq i64 [[IV]], [[END]]
; CHECK-NEXT:    br i1 [[CMP_I_NOT]], label [[EXIT]], label [[LOOP_LATCH]]
; CHECK:       loop.latch:
; CHECK-NEXT:    [[CMP2:%.*]] = icmp sgt i64 [[IV]], [[END]]
; CHECK-NEXT:    call void @use(i1 [[CMP2]])
; CHECK-NEXT:    [[CMP3:%.*]] = icmp sle i64 [[IV]], 10
; CHECK-NEXT:    call void @use(i1 [[CMP3]])
; CHECK-NEXT:    br label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %precond = icmp sle i64 %end, 11
  br i1 %precond, label %loop, label %exit

loop:
  %iv = phi i64 [ %iv.next, %loop.latch ], [ 10, %entry ]
  %iv.next = add i64 %iv, -1
  %cmp.i.not = icmp eq i64 %iv, %end
  br i1 %cmp.i.not, label %exit, label %loop.latch

loop.latch:
  %cmp2 = icmp sgt i64 %iv, %end
  call void @use(i1 %cmp2)
  %cmp3 = icmp sle i64 %iv, 10
  call void @use(i1 %cmp3)
  br label %loop

exit:
  ret void
}
