; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs
; RUN: opt < %s -passes='default<O2>' -S | FileCheck %s

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-apple-macosx10.12.0"

define {ptr, i32} @f(ptr %buffer, ptr %array) {
entry:
  %id = call token @llvm.coro.id.retcon.once(i32 8, i32 8, ptr %buffer, ptr @prototype, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  %load = load i32, ptr %array
  %load.pos = icmp sgt i32 %load, 0
  br i1 %load.pos, label %pos, label %neg

pos:
  %unwind0 = call i1 (...) @llvm.coro.suspend.retcon.i1(i32 %load)
  br i1 %unwind0, label %cleanup, label %pos.cont

pos.cont:
  store i32 0, ptr %array, align 4
  br label %cleanup

neg:
  %unwind1 = call i1 (...) @llvm.coro.suspend.retcon.i1(i32 0)
  br i1 %unwind1, label %cleanup, label %neg.cont

neg.cont:
  store i32 10, ptr %array, align 4
  br label %cleanup

cleanup:
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token none)
  unreachable
}

define void @test.f(ptr %array) {
entry:
  %0 = alloca [8 x i8], align 8
  %prepare = call ptr @llvm.coro.prepare.retcon(ptr @f)
  %result = call {ptr, i32} %prepare(ptr %0, ptr %array)
  %value = extractvalue {ptr, i32} %result, 1
  call void @print(i32 %value)
  %cont = extractvalue {ptr, i32} %result, 0
  call void %cont(ptr %0, i1 zeroext 0)
  ret void
}

define {ptr, i32} @g(ptr %buffer, ptr %array, i32 %val) {
entry:
  %id = call token @llvm.coro.id.retcon.once(i32 8, i32 8, ptr %buffer, ptr @prototype2, ptr @allocate, ptr @deallocate)
  %hdl = call ptr @llvm.coro.begin(token %id, ptr null)
  %load = load i32, ptr %array
  %load.pos = icmp sgt i32 %load, 0
  br i1 %load.pos, label %pos, label %neg

pos:
  %unwind0 = call i1 (...) @llvm.coro.suspend.retcon.i1(i32 %load)
  br i1 %unwind0, label %cleanup, label %pos.cont

pos.cont:
  store i32 0, ptr %array, align 4
  br label %cleanup

neg:
  %unwind1 = call i1 (...) @llvm.coro.suspend.retcon.i1(i32 0)
  br i1 %unwind1, label %cleanup, label %neg.cont

neg.cont:
  store i32 10, ptr %array, align 4
  br label %cleanup

cleanup:
  %new.val = add i32 %val, 123
  %tok = call token (...) @llvm.coro.end.results(ptr null, i32 %new.val, ptr @deallocate)
  call i1 @llvm.coro.end(ptr %hdl, i1 0, token %tok)
  unreachable
}

define void @test.g(ptr %array) {
entry:
  %0 = alloca [8 x i8], align 8
  %prepare = call ptr @llvm.coro.prepare.retcon(ptr @f)
  %yield.result = call {ptr, i32} %prepare(ptr %0, ptr %array)
  %value = extractvalue {ptr, i32} %yield.result, 1
  call void @print(i32 %value)
  %cont = extractvalue {ptr, i32} %yield.result, 0
  %normal.result = call {ptr, i32, ptr} %cont(ptr %0, i1 zeroext 0)
  %value2 = extractvalue {ptr, i32, ptr} %normal.result, 1
  call void @print(i32 %value2)
  ret void
}

;   Unfortunately, we don't seem to fully optimize this right now due
;   to some sort of phase-ordering thing.

declare token @llvm.coro.id.retcon.once(i32, i32, ptr, ptr, ptr, ptr)
declare ptr @llvm.coro.begin(token, ptr)
declare i1 @llvm.coro.suspend.retcon.i1(...)
declare i1 @llvm.coro.end(ptr, i1, token)
declare token @llvm.coro.end.results(...)
declare ptr @llvm.coro.prepare.retcon(ptr)

declare void @prototype(ptr, i1 zeroext)
declare {ptr, i32, ptr} @prototype2(ptr, i1 zeroext)

declare noalias ptr @allocate(i32 %size)
declare void @deallocate(ptr %ptr)

declare void @print(i32)

; CHECK-LABEL: @f(
; CHECK-NEXT:  PostSpill:
; CHECK-NEXT:    store ptr [[ARRAY:%.*]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[ARRAY]], align 4
; CHECK-NEXT:    [[LOAD_POS:%.*]] = icmp sgt i32 [[LOAD]], 0
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[LOAD_POS]], ptr @f.resume.0, ptr @f.resume.1
; CHECK-NEXT:    [[SPEC_SELECT4:%.*]] = tail call i32 @llvm.smax.i32(i32 [[LOAD]], i32 0)
; CHECK-NEXT:    [[TMP0:%.*]] = insertvalue { ptr, i32 } poison, ptr [[SPEC_SELECT]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, i32 } [[TMP0]], i32 [[SPEC_SELECT4]], 1
; CHECK-NEXT:    ret { ptr, i32 } [[TMP1]]
;
;
; CHECK-LABEL: @f.resume.0(
; CHECK-NEXT:  entryresume.0:
; CHECK-NEXT:    br i1 [[TMP1:%.*]], label [[COROEND:%.*]], label [[CLEANUP_SINK_SPLIT:%.*]]
; CHECK:       cleanup.sink.split:
; CHECK-NEXT:    [[ARRAY_RELOAD:%.*]] = load ptr, ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    store i32 0, ptr [[ARRAY_RELOAD]], align 4
; CHECK-NEXT:    br label [[COROEND]]
; CHECK:       CoroEnd:
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: @f.resume.1(
; CHECK-NEXT:  entryresume.1:
; CHECK-NEXT:    br i1 [[TMP1:%.*]], label [[COROEND:%.*]], label [[CLEANUP_SINK_SPLIT:%.*]]
; CHECK:       cleanup.sink.split:
; CHECK-NEXT:    [[ARRAY_RELOAD:%.*]] = load ptr, ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    store i32 10, ptr [[ARRAY_RELOAD]], align 4
; CHECK-NEXT:    br label [[COROEND]]
; CHECK:       CoroEnd:
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: @test.f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = alloca [8 x i8], align 8
; CHECK-NEXT:    store ptr [[ARRAY:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[LOAD_I:%.*]] = load i32, ptr [[ARRAY]], align 4
; CHECK-NEXT:    [[LOAD_POS_I:%.*]] = icmp sgt i32 [[LOAD_I]], 0
; CHECK-NEXT:    [[SPEC_SELECT_I:%.*]] = select i1 [[LOAD_POS_I]], ptr @f.resume.0, ptr @f.resume.1
; CHECK-NEXT:    [[SPEC_SELECT4_I:%.*]] = tail call i32 @llvm.smax.i32(i32 [[LOAD_I]], i32 0)
; CHECK-NEXT:    tail call void @print(i32 [[SPEC_SELECT4_I]])
; CHECK-NEXT:    call void [[SPEC_SELECT_I]](ptr nonnull [[TMP0]], i1 zeroext false)
; CHECK-NEXT:    ret void
;
;
; CHECK-LABEL: @g(
; CHECK-NEXT:  PostSpill:
; CHECK-NEXT:    [[TMP0:%.*]] = tail call ptr @allocate(i32 16)
; CHECK-NEXT:    store ptr [[TMP0]], ptr [[BUFFER:%.*]], align 8
; CHECK-NEXT:    [[VAL_SPILL_ADDR:%.*]] = getelementptr inbounds [[G_FRAME:%.*]], ptr [[TMP0]], i64 0, i32 1
; CHECK-NEXT:    store i32 [[VAL:%.*]], ptr [[VAL_SPILL_ADDR]], align 4
; CHECK-NEXT:    store ptr [[ARRAY:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr [[ARRAY]], align 4
; CHECK-NEXT:    [[LOAD_POS:%.*]] = icmp sgt i32 [[LOAD]], 0
; CHECK-NEXT:    [[SPEC_SELECT:%.*]] = select i1 [[LOAD_POS]], ptr @g.resume.0, ptr @g.resume.1
; CHECK-NEXT:    [[SPEC_SELECT4:%.*]] = tail call i32 @llvm.smax.i32(i32 [[LOAD]], i32 0)
; CHECK-NEXT:    [[TMP1:%.*]] = insertvalue { ptr, i32 } poison, ptr [[SPEC_SELECT]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = insertvalue { ptr, i32 } [[TMP1]], i32 [[SPEC_SELECT4]], 1
; CHECK-NEXT:    ret { ptr, i32 } [[TMP2]]
;
;
; CHECK-LABEL: @g.resume.0(
; CHECK-NEXT:  entryresume.0:
; CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    br i1 [[TMP1:%.*]], label [[COROEND:%.*]], label [[CLEANUP_SINK_SPLIT:%.*]]
; CHECK:       cleanup.sink.split:
; CHECK-NEXT:    [[ARRAY_RELOAD:%.*]] = load ptr, ptr [[TMP2]], align 8
; CHECK-NEXT:    store i32 0, ptr [[ARRAY_RELOAD]], align 4
; CHECK-NEXT:    br label [[COROEND]]
; CHECK:       CoroEnd:
; CHECK-NEXT:    [[VAL_RELOAD_ADDR:%.*]] = getelementptr inbounds [[G_FRAME:%.*]], ptr [[TMP2]], i64 0, i32 1
; CHECK-NEXT:    [[VAL_RELOAD:%.*]] = load i32, ptr [[VAL_RELOAD_ADDR]], align 4
; CHECK-NEXT:    [[NEW_VAL:%.*]] = add i32 [[VAL_RELOAD]], 123
; CHECK-NEXT:    tail call void @deallocate(ptr [[TMP2]])
; CHECK-NEXT:    [[TMP3:%.*]] = insertvalue { ptr, i32, ptr } { ptr null, i32 undef, ptr undef }, i32 [[NEW_VAL]], 1
; CHECK-NEXT:    [[TMP4:%.*]] = insertvalue { ptr, i32, ptr } [[TMP3]], ptr @deallocate, 2
; CHECK-NEXT:    ret { ptr, i32, ptr } [[TMP4]]
;
;
; CHECK-LABEL: @g.resume.1(
; CHECK-NEXT:  entryresume.1:
; CHECK-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[TMP0:%.*]], align 8
; CHECK-NEXT:    br i1 [[TMP1:%.*]], label [[COROEND:%.*]], label [[CLEANUP_SINK_SPLIT:%.*]]
; CHECK:       cleanup.sink.split:
; CHECK-NEXT:    [[ARRAY_RELOAD:%.*]] = load ptr, ptr [[TMP2]], align 8
; CHECK-NEXT:    store i32 10, ptr [[ARRAY_RELOAD]], align 4
; CHECK-NEXT:    br label [[COROEND]]
; CHECK:       CoroEnd:
; CHECK-NEXT:    [[VAL_RELOAD_ADDR:%.*]] = getelementptr inbounds [[G_FRAME:%.*]], ptr [[TMP2]], i64 0, i32 1
; CHECK-NEXT:    [[VAL_RELOAD:%.*]] = load i32, ptr [[VAL_RELOAD_ADDR]], align 4
; CHECK-NEXT:    [[NEW_VAL:%.*]] = add i32 [[VAL_RELOAD]], 123
; CHECK-NEXT:    tail call void @deallocate(ptr [[TMP2]])
; CHECK-NEXT:    [[TMP3:%.*]] = insertvalue { ptr, i32, ptr } { ptr null, i32 undef, ptr undef }, i32 [[NEW_VAL]], 1
; CHECK-NEXT:    [[TMP4:%.*]] = insertvalue { ptr, i32, ptr } [[TMP3]], ptr @deallocate, 2
; CHECK-NEXT:    ret { ptr, i32, ptr } [[TMP4]]
;
;
; CHECK-LABEL: @test.g(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = alloca [8 x i8], align 8
; CHECK-NEXT:    store ptr [[ARRAY:%.*]], ptr [[TMP0]], align 8
; CHECK-NEXT:    [[LOAD_I:%.*]] = load i32, ptr [[ARRAY]], align 4
; CHECK-NEXT:    [[LOAD_POS_I:%.*]] = icmp sgt i32 [[LOAD_I]], 0
; CHECK-NEXT:    [[SPEC_SELECT_I:%.*]] = select i1 [[LOAD_POS_I]], ptr @f.resume.0, ptr @f.resume.1
; CHECK-NEXT:    [[SPEC_SELECT4_I:%.*]] = tail call i32 @llvm.smax.i32(i32 [[LOAD_I]], i32 0)
; CHECK-NEXT:    tail call void @print(i32 [[SPEC_SELECT4_I]])
; CHECK-NEXT:    [[NORMAL_RESULT:%.*]] = call { ptr, i32, ptr } [[SPEC_SELECT_I]](ptr nonnull [[TMP0]], i1 zeroext false)
; CHECK-NEXT:    [[VALUE2:%.*]] = extractvalue { ptr, i32, ptr } [[NORMAL_RESULT]], 1
; CHECK-NEXT:    call void @print(i32 [[VALUE2]])
; CHECK-NEXT:    ret void
;
