; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

declare void @llvm.init.trampoline(ptr, ptr, ptr)
declare ptr @llvm.adjust.trampoline(ptr)
declare i32 @f(ptr nest, i32)

; Most common case
define i32 @test0(i32 %n) !dbg !4 {
; CHECK-LABEL: define i32 @test0
; CHECK-SAME: (i32 [[N:%.*]]) !dbg [[DBG4:![0-9]+]] {
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca [10 x i8], align 16
; CHECK-NEXT:    call void @llvm.init.trampoline(ptr nonnull [[ALLOCA]], ptr nonnull @f, ptr null)
; CHECK-NEXT:    [[RET:%.*]] = call i32 @f(ptr nest null, i32 [[N]]), !dbg [[DBG10:![0-9]+]]
; CHECK-NEXT:    ret i32 [[RET]]
;
  %alloca = alloca [10 x i8], align 16
  call void @llvm.init.trampoline(ptr %alloca, ptr @f,
  ptr null)
  %tramp = call ptr @llvm.adjust.trampoline(ptr %alloca)
  %ret = call i32 %tramp(i32 %n), !dbg !10
  ret i32 %ret

}

define i32 @test1(i32 %n, ptr %trampmem) {
; CHECK-LABEL: define i32 @test1
; CHECK-SAME: (i32 [[N:%.*]], ptr [[TRAMPMEM:%.*]]) {
; CHECK-NEXT:    call void @llvm.init.trampoline(ptr [[TRAMPMEM]], ptr nonnull @f, ptr null)
; CHECK-NEXT:    [[RET:%.*]] = call i32 @f(ptr nest null, i32 [[N]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  call void @llvm.init.trampoline(ptr %trampmem,
  ptr @f,
  ptr null)
  %tramp = call ptr @llvm.adjust.trampoline(ptr %trampmem)
  %ret = call i32 %tramp(i32 %n)
  ret i32 %ret
}

define i32 @test2(i32 %n, ptr %trampmem) {
; CHECK-LABEL: define i32 @test2
; CHECK-SAME: (i32 [[N:%.*]], ptr [[TRAMPMEM:%.*]]) {
; CHECK-NEXT:    [[TRAMP:%.*]] = call ptr @llvm.adjust.trampoline(ptr [[TRAMPMEM]])
; CHECK-NEXT:    [[RET:%.*]] = call i32 [[TRAMP]](i32 [[N]])
; CHECK-NEXT:    ret i32 [[RET]]
;
  %tramp = call ptr @llvm.adjust.trampoline(ptr %trampmem)
  %ret = call i32 %tramp(i32 %n)
  ret i32 %ret
}

define i32 @test3(i32 %n, ptr %trampmem) {
; CHECK-LABEL: define i32 @test3
; CHECK-SAME: (i32 [[N:%.*]], ptr [[TRAMPMEM:%.*]]) {
; CHECK-NEXT:    call void @llvm.init.trampoline(ptr [[TRAMPMEM]], ptr nonnull @f, ptr null)
; CHECK-NEXT:    [[RET0:%.*]] = call i32 @f(ptr nest null, i32 [[N]])
; CHECK-NEXT:    [[TRAMP1:%.*]] = call ptr @llvm.adjust.trampoline(ptr [[TRAMPMEM]])
; CHECK-NEXT:    [[RET1:%.*]] = call i32 [[TRAMP1]](i32 [[N]])
; CHECK-NEXT:    ret i32 [[RET1]]
;
  call void @llvm.init.trampoline(ptr %trampmem,
  ptr @f,
  ptr null)

  %tramp0 = call ptr @llvm.adjust.trampoline(ptr %trampmem)
  %ret0 = call i32 %tramp0(i32 %n)

  ;; Not optimized since previous call could be writing.
  %tramp1 = call ptr @llvm.adjust.trampoline(ptr %trampmem)
  %ret1 = call i32 %tramp1(i32 %n)

  ret i32 %ret1
}

define i32 @test4(i32 %n) {
; CHECK-LABEL: define i32 @test4
; CHECK-SAME: (i32 [[N:%.*]]) {
; CHECK-NEXT:    [[ALLOCA:%.*]] = alloca [10 x i8], align 16
; CHECK-NEXT:    call void @llvm.init.trampoline(ptr nonnull [[ALLOCA]], ptr nonnull @f, ptr null)
; CHECK-NEXT:    [[RET0:%.*]] = call i32 @f(ptr nest null, i32 [[N]])
; CHECK-NEXT:    [[RET1:%.*]] = call i32 @f(ptr nest null, i32 [[N]])
; CHECK-NEXT:    [[RET2:%.*]] = call i32 @f(ptr nest null, i32 [[N]])
; CHECK-NEXT:    ret i32 [[RET2]]
;
  %alloca = alloca [10 x i8], align 16
  call void @llvm.init.trampoline(ptr %alloca, ptr @f,
  ptr null)

  %tramp0 = call ptr @llvm.adjust.trampoline(ptr %alloca)
  %ret0 = call i32 %tramp0(i32 %n)

  %tramp1 = call ptr @llvm.adjust.trampoline(ptr %alloca)
  %ret1 = call i32 %tramp0(i32 %n)

  %tramp2 = call ptr @llvm.adjust.trampoline(ptr %alloca)
  %ret2 = call i32 %tramp2(i32 %n)

  ret i32 %ret2

}

!llvm.dbg.cu = !{!0}
!llvm.module.flags = !{!3}

!0 = distinct !DICompileUnit(language: DW_LANG_C99, file: !1, producer: "clang version 3.0 (trunk 127710)", isOptimized: true, runtimeVersion: 0, emissionKind: FullDebug, enums: !2, retainedTypes: !2)
!1 = !DIFile(filename: "string.h", directory: "Game")
!2 = !{}
!3 = !{i32 1, !"Debug Info Version", i32 3}
!4 = distinct !DISubprogram(name: "passthru", scope: !1, file: !1, line: 79, type: !5, isLocal: true, isDefinition: true, scopeLine: 79, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: true, unit: !0, retainedNodes: !8)
!5 = !DISubroutineType(types: !6)
!6 = !{!7}
!7 = !DIDerivedType(tag: DW_TAG_pointer_type, scope: !0, baseType: null, size: 64, align: 64)
!8 = !{!9}
!9 = !DILocalVariable(name: "a", arg: 1, scope: !4, file: !1, line: 78, type: !7)
!10 = !DILocation(line: 78, column: 28, scope: !4)
