# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=atom -instruction-tables < %s | FileCheck %s

movbe  %cx, (%rax)
movbe  (%rax), %cx

movbe  %ecx, (%rax)
movbe  (%rax), %ecx

movbe  %rcx, (%rax)
movbe  (%rax), %rcx

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00           *            movbew	%cx, (%rax)
# CHECK-NEXT:  1      1     1.00    *                   movbew	(%rax), %cx
# CHECK-NEXT:  1      1     1.00           *            movbel	%ecx, (%rax)
# CHECK-NEXT:  1      1     1.00    *                   movbel	(%rax), %ecx
# CHECK-NEXT:  1      1     1.00           *            movbeq	%rcx, (%rax)
# CHECK-NEXT:  1      1     1.00    *                   movbeq	(%rax), %rcx

# CHECK:      Resources:
# CHECK-NEXT: [0]   - AtomPort0
# CHECK-NEXT: [1]   - AtomPort1

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]
# CHECK-NEXT: 6.00    -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    Instructions:
# CHECK-NEXT: 1.00    -     movbew	%cx, (%rax)
# CHECK-NEXT: 1.00    -     movbew	(%rax), %cx
# CHECK-NEXT: 1.00    -     movbel	%ecx, (%rax)
# CHECK-NEXT: 1.00    -     movbel	(%rax), %ecx
# CHECK-NEXT: 1.00    -     movbeq	%rcx, (%rax)
# CHECK-NEXT: 1.00    -     movbeq	(%rax), %rcx
