#!/bin/sh

DEBUG=$(git config --type bool --default false netbsd.debug)
if $DEBUG; then
	echo BEGIN reference-transaction $$ "$@"
	trap 'echo END reference-transaction $$ "$@"' EXIT HUP INT TERM
fi

set -Ceu
if $DEBUG; then
	set -x
fi

if $DEBUG; then
	i=0
	while [ "$i" -lt "${GIT_PUSH_OPTION_COUNT:-0}" ]; do
		eval echo [reference-transaction] \
		    GIT_PUSH_OPTION_$i=\$GIT_PUSH_OPTION_$i
		i=$((i + 1))
	done
fi

if $DEBUG; then
	awk '{ print "[reference-transaction]", $0 }'
fi
