/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.tools;

import java.io.IOException;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.tools.ClassLoaderStats;
import sun.jvm.hotspot.tools.FinalizerInfo;
import sun.jvm.hotspot.tools.HeapSummary;
import sun.jvm.hotspot.tools.ObjectHistogram;
import sun.jvm.hotspot.tools.PMap;
import sun.jvm.hotspot.tools.Tool;
import sun.jvm.hotspot.utilities.HeapGXLWriter;
import sun.jvm.hotspot.utilities.HeapHprofBinWriter;

public class JMap
extends Tool {
    public static final int MODE_HEAP_SUMMARY = 0;
    public static final int MODE_HISTOGRAM = 1;
    public static final int MODE_CLSTATS = 2;
    public static final int MODE_PMAP = 3;
    public static final int MODE_HEAP_GRAPH_HPROF_BIN = 4;
    public static final int MODE_HEAP_GRAPH_GXL = 5;
    public static final int MODE_FINALIZERINFO = 6;
    private int mode;

    public JMap(int m) {
        this.mode = m;
    }

    public JMap() {
        this(3);
    }

    public JMap(JVMDebugger d) {
        super(d);
    }

    @Override
    protected boolean needsJavaPrefix() {
        return false;
    }

    @Override
    public String getName() {
        return "jmap";
    }

    protected String getCommandFlags() {
        return "-heap|-heap:format=b|-histo|-clstats|-finalizerinfo";
    }

    @Override
    protected void printFlagsUsage() {
        System.out.println("    <no option>\tto print same info as Solaris pmap");
        System.out.println("    -heap\tto print java heap summary");
        System.out.println("    -heap:format=b\tto dump java heap in hprof binary format");
        System.out.println("    -histo\tto print histogram of java object heap");
        System.out.println("    -clstats\tto print class loader statistics");
        System.out.println("    -finalizerinfo\tto print information on objects awaiting finalization");
        super.printFlagsUsage();
    }

    @Override
    public void run() {
        Tool tool = null;
        switch (this.mode) {
            case 0: {
                tool = new HeapSummary();
                break;
            }
            case 1: {
                tool = new ObjectHistogram();
                break;
            }
            case 2: {
                tool = new ClassLoaderStats();
                break;
            }
            case 3: {
                tool = new PMap();
                break;
            }
            case 4: {
                this.writeHeapHprofBin();
                return;
            }
            case 5: {
                this.writeHeapGXL();
                return;
            }
            case 6: {
                tool = new FinalizerInfo();
                break;
            }
            default: {
                this.usage();
            }
        }
        tool.setAgent(this.getAgent());
        tool.setDebugeeType(this.getDebugeeType());
        tool.run();
    }

    public static void main(String[] args) {
        int mode = 3;
        if (args.length > 1) {
            String modeFlag = args[0];
            boolean copyArgs = true;
            if (modeFlag.equals("-heap")) {
                mode = 0;
            } else if (modeFlag.equals("-histo")) {
                mode = 1;
            } else if (modeFlag.equals("-clstats")) {
                mode = 2;
            } else if (modeFlag.equals("-finalizerinfo")) {
                mode = 6;
            } else {
                int index = modeFlag.indexOf("-heap:format=");
                if (index != -1) {
                    String format = modeFlag.substring(1 + modeFlag.indexOf(61));
                    if (format.equals("b")) {
                        mode = 4;
                    } else if (format.equals("x")) {
                        mode = 5;
                    } else {
                        System.err.println("unknown heap format:" + format);
                        System.exit(1);
                    }
                } else {
                    copyArgs = false;
                }
            }
            if (copyArgs) {
                String[] newArgs = new String[args.length - 1];
                for (int i = 0; i < newArgs.length; ++i) {
                    newArgs[i] = args[i + 1];
                }
                args = newArgs;
            }
        }
        JMap jmap = new JMap(mode);
        jmap.execute(args);
    }

    public boolean writeHeapHprofBin(String fileName) {
        try {
            HeapHprofBinWriter hgw = new HeapHprofBinWriter();
            hgw.write(fileName);
            System.out.println("heap written to " + fileName);
            return true;
        }
        catch (IOException exp) {
            System.err.println(exp.getMessage());
            return false;
        }
    }

    public boolean writeHeapHprofBin() {
        return this.writeHeapHprofBin("heap.bin");
    }

    private boolean writeHeapGXL(String fileName) {
        try {
            HeapGXLWriter hgw = new HeapGXLWriter();
            hgw.write(fileName);
            System.out.println("heap written to " + fileName);
            return true;
        }
        catch (IOException exp) {
            System.err.println(exp.getMessage());
            return false;
        }
    }

    public boolean writeHeapGXL() {
        return this.writeHeapGXL("heap.xml");
    }
}

