.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw wid-get
.na
.TH XtOffset __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtOffset, XtOffsetOf, XtNumber \- determine the byte offset or number of array elements
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
Cardinal XtOffset(Type \fIpointer_type\fP, Field \fIfield_name\fP);
.HP
Cardinal XtOffsetOf(Type \fIstructure_type\fP, Field \fIfield_name\fP);
.HP
Cardinal XtNumber(ArrayVariable \fIarray\fP);
.SH ARGUMENTS
.IP \fIarray\fP 1i
Specifies a fixed-size array.
.IP \fIfield_name\fP 1i
Specifies the name of the field for which to calculate the byte offset.
.IP \fIpointer_type\fP 1i
Specifies a type that is declared as a pointer to the structure.
.IP \fIstructure_type\fP 1i
Specifies a type that is declared as a structure.
.SH DESCRIPTION
The
.B XtOffset
macro is usually used to determine the offset of various resource fields
from the beginning of a widget and can be used at compile time in static
initializations.
.LP
The
.B XtOffsetOf
macro expands to a constant expression that gives the offset in bytes
to the specified structure member from the beginning of the structure.
It is normally used to statically initialize resource lists and is more
portable than
.BR XtOffset ,
which serves the same function.
.LP
The
.B XtNumber
macro returns the number of elements in the specified argument lists,
resources lists, and other counted arrays.
.SH "SEE ALSO"
XtGetResourceList(__libmansuffix__),
XtSetArg(__libmansuffix__)
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
