/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class CompiledICHolder
extends VMObject {
    private static long headerSize;
    private static MetadataField holderMetadata;
    private static MetadataField holderKlass;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("CompiledICHolder");
        holderMetadata = new MetadataField(type.getAddressField("_holder_metadata"), 0L);
        holderKlass = new MetadataField(type.getAddressField("_holder_klass"), 0L);
        headerSize = type.getSize();
    }

    public CompiledICHolder(Address addr) {
        super(addr);
    }

    public boolean isCompiledICHolder() {
        return true;
    }

    public Metadata getHolderMetadata() {
        return holderMetadata.getValue(this);
    }

    public Klass getHolderKlass() {
        return (Klass)holderKlass.getValue(this);
    }

    public void printValueOn(PrintStream tty) {
        tty.print("CompiledICHolder");
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                CompiledICHolder.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

