/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport.queryset;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.Nullable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

public class PostQuerySetRequest
extends ActionRequest {
    private String name;
    private String description;
    private String sampling;
    private int querySetSize;

    public PostQuerySetRequest(String name, String description, String sampling, int querySetSize) {
        this.name = Objects.requireNonNull(name, "name cannot be null.");
        this.description = description;
        this.sampling = Objects.requireNonNull(sampling, "sampling cannot be null.");
        this.querySetSize = Objects.requireNonNull(Integer.valueOf(querySetSize), "querySetSize cannot be null.");
    }

    public PostQuerySetRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.description = in.readString();
        this.sampling = in.readString();
        this.querySetSize = in.readInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.sampling);
        out.writeInt(this.querySetSize);
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public String getSampling() {
        return this.sampling;
    }

    public int getQuerySetSize() {
        return this.querySetSize;
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

