/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class DateFormat {
    private static final Map<String, String> formatMap = new HashMap<String, String>();

    private DateFormat() {
    }

    public static String getFormatString(String formatName) {
        return formatMap.get(formatName);
    }

    public static String getFormattedDate(java.util.Date date, String dateFormat) {
        Instant instant = date.toInstant();
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, ZoneId.of("Etc/UTC"));
        return zdt.format(DateTimeFormatter.ofPattern(dateFormat));
    }

    static {
        formatMap.put("date_optional_time", "");
        formatMap.put("strict_date_optional_time", "");
        formatMap.put("epoch_millis", "");
        formatMap.put("epoch_second", "");
        formatMap.put("basic_date", "yyyyMMdd");
        formatMap.put("basic_date_time", "yyyyMMdd'T'HHmmss.SSSZ");
        formatMap.put("basic_date_time_no_millis", "yyyyMMdd'T'HHmmssZ");
        formatMap.put("basic_ordinal_date", "yyyyDDD");
        formatMap.put("basic_ordinal_date_time", "yyyyDDD'T'HHmmss.SSSZ");
        formatMap.put("basic_ordinal_date_time_no_millis", "yyyyDDD'T'HHmmssZ");
        formatMap.put("basic_time", "HHmmss.SSSZ");
        formatMap.put("basic_time_no_millis", "HHmmssZ");
        formatMap.put("basic_t_time", "'T'HHmmss.SSSZ");
        formatMap.put("basic_t_time_no_millis", "'T'HHmmssZ");
        formatMap.put("basic_week_date", "YYYY'W'wwu");
        formatMap.put("basic_week_date_time", "YYYY'W'wwu'T'HHmmss.SSSZ");
        formatMap.put("basic_week_date_time_no_millis", "YYYY'W'wwu'T'HHmmssZ");
        formatMap.put("date", "yyyy-MM-dd");
        formatMap.put("date_hour", "yyyy-MM-dd'T'HH");
        formatMap.put("date_hour_minute", "yyyy-MM-dd'T'HH:mm");
        formatMap.put("date_hour_minute_second", "yyyy-MM-dd'T'HH:mm:ss");
        formatMap.put("date_hour_minute_second_fraction", "yyyy-MM-dd'T'HH:mm:ss.SSS");
        formatMap.put("date_hour_minute_second_millis", "yyyy-MM-dd'T'HH:mm:ss.SSS");
        formatMap.put("date_time", "yyyy-MM-dd'T'HH:mm:ss.SSSXX");
        formatMap.put("date_time_no_millis", "yyyy-MM-dd'T'HH:mm:ssXX");
        formatMap.put("hour", "HH");
        formatMap.put("hour_minute", "HH:mm");
        formatMap.put("hour_minute_second", "HH:mm:ss");
        formatMap.put("hour_minute_second_fraction", "HH:mm:ss.SSS");
        formatMap.put("hour_minute_second_millis", "HH:mm:ss.SSS");
        formatMap.put("ordinal_date", "yyyy-DDD");
        formatMap.put("ordinal_date_time", "yyyy-DDD'T'HH:mm:ss.SSSXX");
        formatMap.put("ordinal_date_time_no_millis", "yyyy-DDD'T'HH:mm:ssXX");
        formatMap.put("time", "HH:mm:ss.SSSXX");
        formatMap.put("time_no_millis", "HH:mm:ssXX");
        formatMap.put("t_time", "'T'HH:mm:ss.SSSXX");
        formatMap.put("t_time_no_millis", "'T'HH:mm:ssXX");
        formatMap.put("week_date", "YYYY-'W'ww-u");
        formatMap.put("week_date_time", "YYYY-'W'ww-u'T'HH:mm:ss.SSSXX");
        formatMap.put("week_date_time_no_millis", "YYYY-'W'ww-u'T'HH:mm:ssXX");
        formatMap.put("week_year", "YYYY");
        formatMap.put("weekyear_week", "YYYY-'W'ww");
        formatMap.put("weekyear_week_day", "YYYY-'W'ww-u");
        formatMap.put("year", "yyyy");
        formatMap.put("year_month", "yyyy-MM");
        formatMap.put("year_month_day", "yyyy-MM-dd");
    }

    private static class Date {
        static final String BASIC_DATE = "yyyyMMdd";
        static final String BASIC_ORDINAL_DATE = "yyyyDDD";
        static final String BASIC_WEEK_DATE = "YYYY'W'wwu";
        static final String DATE = "yyyy-MM-dd";
        static final String ORDINAL_DATE = "yyyy-DDD";
        static final String YEAR = "yyyy";
        static final String YEAR_MONTH = "yyyy-MM";
        static final String WEEK_DATE = "YYYY-'W'ww-u";
        static final String WEEKYEAR = "YYYY";
        static final String WEEKYEAR_WEEK = "YYYY-'W'ww";

        private Date() {
        }
    }

    private static class Time {
        static final String T = "'T'";
        static final String BASIC_TIME = "HHmmss";
        static final String TIME = "HH:mm:ss";
        static final String HOUR = "HH";
        static final String HOUR_MINUTE = "HH:mm";
        static final String MILLIS = ".SSS";
        static final String TZ = "Z";
        static final String TZZ = "XX";

        private Time() {
        }
    }
}

