/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.search.SearchHit;
import org.opensearch.sql.legacy.query.planner.core.ExecuteParams;
import org.opensearch.sql.legacy.query.planner.core.Plan;
import org.opensearch.sql.legacy.query.planner.core.PlanNode;
import org.opensearch.sql.legacy.query.planner.logical.LogicalPlan;
import org.opensearch.sql.legacy.query.planner.physical.PhysicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.Row;
import org.opensearch.sql.legacy.query.planner.physical.estimation.Estimation;
import org.opensearch.sql.legacy.query.planner.resource.ResourceManager;

public class PhysicalPlan
implements Plan {
    private static final Logger LOG = LogManager.getLogger();
    private final LogicalPlan logicalPlan;
    private PhysicalOperator<SearchHit> root;

    public PhysicalPlan(LogicalPlan logicalPlan) {
        this.logicalPlan = logicalPlan;
    }

    @Override
    public void traverse(PlanNode.Visitor visitor) {
        if (this.root != null) {
            this.root.accept(visitor);
        }
    }

    @Override
    public void optimize() {
        Estimation estimation = new Estimation();
        this.logicalPlan.traverse(estimation);
        this.root = estimation.optimalPlan();
    }

    public List<SearchHit> execute(ExecuteParams params) {
        if (this.shouldReject(params)) {
            throw new IllegalStateException("Query request rejected due to insufficient resource");
        }
        PhysicalOperator<SearchHit> op = this.root;
        try {
            List<SearchHit> list = this.doExecutePlan(op, params);
            if (op != null) {
                op.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (op != null) {
                    try {
                        op.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                LOG.error("Error happened during execution", (Throwable)e);
                throw new IllegalStateException("Error happened during execution", e);
            }
        }
    }

    private boolean shouldReject(ExecuteParams params) {
        return !((ResourceManager)params.get(ExecuteParams.ExecuteParamType.RESOURCE_MANAGER)).isHealthy();
    }

    private List<SearchHit> doExecutePlan(PhysicalOperator<SearchHit> op, ExecuteParams params) throws Exception {
        ArrayList<SearchHit> hits = new ArrayList<SearchHit>();
        op.open(params);
        while (op.hasNext()) {
            hits.add((SearchHit)((Row)op.next()).data());
        }
        if (LOG.isTraceEnabled()) {
            hits.forEach(hit -> LOG.trace("Final result row: {}", (Object)hit.getSourceAsMap()));
        }
        return hits;
    }
}

