/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.flint;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.dispatcher.model.FlintIndexOptions;
import org.opensearch.sql.spark.flint.FlintIndexMetadata;
import org.opensearch.sql.spark.flint.FlintIndexMetadataService;
import org.opensearch.sql.spark.flint.FlintIndexMetadataValidator;
import org.opensearch.transport.client.Client;

public class FlintIndexMetadataServiceImpl
implements FlintIndexMetadataService {
    private static final Logger LOGGER = LogManager.getLogger(FlintIndexMetadataServiceImpl.class);
    private final Client client;

    @Override
    public Map<String, FlintIndexMetadata> getFlintIndexMetadata(String indexPattern, AsyncQueryRequestContext asyncQueryRequestContext) {
        GetMappingsResponse mappingsResponse = (GetMappingsResponse)((GetMappingsRequestBuilder)this.client.admin().indices().prepareGetMappings(new String[0]).setIndices(new String[]{indexPattern})).get();
        HashMap<String, FlintIndexMetadata> indexMetadataMap = new HashMap<String, FlintIndexMetadata>();
        mappingsResponse.getMappings().forEach((indexName, mappingMetadata) -> {
            try {
                Map mappingSourceMap = mappingMetadata.getSourceAsMap();
                FlintIndexMetadata metadata = this.fromMetadata((String)indexName, (Map)mappingSourceMap.get("_meta"));
                indexMetadataMap.put((String)indexName, metadata);
            }
            catch (Exception exception) {
                LOGGER.error("Exception while building index details for index: {} due to: {}", indexName, (Object)exception.getMessage());
            }
        });
        return indexMetadataMap;
    }

    @Override
    public void updateIndexToManualRefresh(String indexName, FlintIndexOptions flintIndexOptions, AsyncQueryRequestContext asyncQueryRequestContext) {
        GetMappingsResponse mappingsResponse = (GetMappingsResponse)((GetMappingsRequestBuilder)this.client.admin().indices().prepareGetMappings(new String[0]).setIndices(new String[]{indexName})).get();
        Map flintMetadataMap = ((MappingMetadata)mappingsResponse.getMappings().get(indexName)).getSourceAsMap();
        Map meta = (Map)flintMetadataMap.get("_meta");
        String kind = (String)meta.get("kind");
        Map options = (Map)meta.get("options");
        Map<String, String> newOptions = flintIndexOptions.getProvidedOptions();
        FlintIndexMetadataValidator.validateFlintIndexOptions(kind, options, newOptions);
        options.putAll(newOptions);
        this.client.admin().indices().preparePutMapping(new String[]{indexName}).setSource(flintMetadataMap).get();
    }

    private FlintIndexMetadata fromMetadata(String indexName, Map<String, Object> metaMap) {
        FlintIndexMetadata.FlintIndexMetadataBuilder flintIndexMetadataBuilder = FlintIndexMetadata.builder();
        Map propertiesMap = (Map)metaMap.get("properties");
        Map envMap = (Map)propertiesMap.get("env");
        Map options = (Map)metaMap.get("options");
        FlintIndexOptions flintIndexOptions = new FlintIndexOptions();
        for (String key : options.keySet()) {
            flintIndexOptions.setOption(key, (String)options.get(key));
        }
        String jobId = (String)envMap.get("SERVERLESS_EMR_JOB_ID");
        String appId = envMap.getOrDefault("SERVERLESS_EMR_VIRTUAL_CLUSTER_ID", null);
        String latestId = metaMap.getOrDefault("latestId", null);
        String kind = metaMap.getOrDefault("kind", null);
        String name = metaMap.getOrDefault("name", null);
        String source = metaMap.getOrDefault("source", null);
        flintIndexMetadataBuilder.jobId(jobId);
        flintIndexMetadataBuilder.appId(appId);
        flintIndexMetadataBuilder.latestId(latestId);
        flintIndexMetadataBuilder.name(name);
        flintIndexMetadataBuilder.kind(kind);
        flintIndexMetadataBuilder.source(source);
        flintIndexMetadataBuilder.opensearchIndexName(indexName);
        flintIndexMetadataBuilder.flintIndexOptions(flintIndexOptions);
        return flintIndexMetadataBuilder.build();
    }

    @Generated
    public FlintIndexMetadataServiceImpl(Client client) {
        this.client = client;
    }
}

