/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.provenance.primitives;

import com.oracle.labs.mlrg.olcut.provenance.PrimitiveProvenance;
import com.oracle.labs.mlrg.olcut.provenance.ProvenanceUtil;
import java.util.Objects;

public final class HashProvenance
implements PrimitiveProvenance<String> {
    private static final long serialVersionUID = 1L;
    private final ProvenanceUtil.HashType type;
    private final String key;
    private final String value;

    public HashProvenance(ProvenanceUtil.HashType type, String key, String value) {
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public HashProvenance(ProvenanceUtil.HashType type, String key, byte[] value) {
        this.type = type;
        this.key = key;
        this.value = ProvenanceUtil.bytesToHexString(value);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public ProvenanceUtil.HashType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HashProvenance)) {
            return false;
        }
        HashProvenance that = (HashProvenance)o;
        return this.type == that.type && this.key.equals(that.key) && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.value});
    }

    public String toString() {
        return this.type.name + "[" + this.value + "]";
    }
}

