/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.transport;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.forecast.transport.ForecastRunOnceProfileNodeResponse;

public class ForecastRunOnceProfileResponse
extends BaseNodesResponse<ForecastRunOnceProfileNodeResponse>
implements ToXContentFragment {
    private final boolean answer;
    private final String exceptionMsg;

    public ForecastRunOnceProfileResponse(StreamInput in) throws IOException {
        super(in);
        this.answer = in.readBoolean();
        this.exceptionMsg = in.readOptionalString();
    }

    public ForecastRunOnceProfileResponse(ClusterName clusterName, List<ForecastRunOnceProfileNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
        this.answer = nodes.stream().anyMatch(response -> response.isAnswerTrue());
        this.exceptionMsg = nodes.stream().map(ForecastRunOnceProfileNodeResponse::getExceptionMsg).filter(Objects::nonNull).filter(msg -> !msg.isEmpty()).collect(Collectors.joining("\n"));
    }

    public boolean isAnswerTrue() {
        return this.answer;
    }

    public String getExceptionMsg() {
        return this.exceptionMsg;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.answer);
        out.writeOptionalString(this.exceptionMsg);
    }

    protected List<ForecastRunOnceProfileNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(ForecastRunOnceProfileNodeResponse::new);
    }

    protected void writeNodesTo(StreamOutput out, List<ForecastRunOnceProfileNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("answer", this.answer);
        builder.field("error", this.exceptionMsg);
        return builder;
    }
}

