/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar;

import com.oracle.labs.mlrg.olcut.util.IOSpliterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.logging.Logger;

public abstract class ColumnarIterator
extends IOSpliterator<Row>
implements Iterator<Row> {
    private static final Logger logger = Logger.getLogger(ColumnarIterator.class.getName());
    protected List<String> fields;
    protected Optional<Row> currentRow = Optional.empty();

    protected ColumnarIterator() {
    }

    protected ColumnarIterator(int characteristics, int batchsize, long estimatedSize) {
        super(characteristics, batchsize, estimatedSize);
    }

    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public boolean hasNext() {
        if (this.currentRow.isPresent()) {
            return true;
        }
        this.currentRow = this.getRow();
        return this.currentRow.isPresent();
    }

    @Override
    public Row next() {
        if (this.hasNext()) {
            Row r = this.currentRow.get();
            this.currentRow = Optional.empty();
            return r;
        }
        throw new NoSuchElementException();
    }

    public boolean tryAdvance(Consumer<? super Row> action) {
        if (this.hasNext()) {
            action.accept(this.next());
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super Row> action) {
        while (this.hasNext()) {
            action.accept(this.next());
        }
    }

    protected abstract Optional<Row> getRow();

    public static class Row {
        private final long index;
        private final List<String> fields;
        private final Map<String, String> rowData;

        public Row(long index, List<String> fields, Map<String, String> rowData) {
            this.index = index;
            this.fields = fields;
            this.rowData = Collections.unmodifiableMap(rowData);
        }

        public List<String> getFields() {
            return this.fields;
        }

        public long getIndex() {
            return this.index;
        }

        public Map<String, String> getRowData() {
            return this.rowData;
        }

        public String toString() {
            return "Row(index=" + this.index + ", fields=" + this.fields.toString() + ", rowData=" + this.rowData.toString() + ")";
        }
    }
}

