/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tribuo.data.columnar.ColumnarIterator;

public class ResultSetIterator
extends ColumnarIterator {
    private static final Logger logger = Logger.getLogger(ResultSetIterator.class.getName());
    private final ResultSet resultSet;
    private int rowNum = 0;

    public ResultSetIterator(ResultSet rs) throws SQLException {
        this.resultSet = rs;
        ResultSetMetaData rsm = this.resultSet.getMetaData();
        this.fields = new ArrayList();
        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
            this.fields.add(rsm.getColumnName(i));
        }
    }

    public ResultSetIterator(ResultSet rs, int fetchSize) throws SQLException {
        super(1296, fetchSize, Long.MAX_VALUE);
        this.resultSet = rs;
        ResultSetMetaData rsm = this.resultSet.getMetaData();
        this.fields = new ArrayList();
        for (int i = 1; i <= rsm.getColumnCount(); ++i) {
            this.fields.add(rsm.getColumnName(i));
        }
    }

    @Override
    protected Optional<ColumnarIterator.Row> getRow() {
        try {
            if (!this.resultSet.isClosed() && this.resultSet.next()) {
                HashMap<String, String> rowMap = new HashMap<String, String>();
                for (int i = 0; i < this.fields.size(); ++i) {
                    Object obj = null;
                    try {
                        obj = this.resultSet.getObject(i + 1);
                    }
                    catch (SQLException e) {
                        logger.log(Level.SEVERE, "Missing object at index: " + (i + 1), e);
                    }
                    rowMap.put((String)this.fields.get(i), obj == null ? "" : obj.toString());
                }
                ++this.rowNum;
                if (this.rowNum % 50000 == 0) {
                    logger.info(String.format("Iterated over %d rows", this.rowNum));
                }
                return Optional.of(new ColumnarIterator.Row(this.rowNum, this.fields, rowMap));
            }
            if (!this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            return Optional.empty();
        }
        catch (SQLException e) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e2) {
                logger.log(Level.WARNING, "Error closing ResultSet inside another error", e2);
            }
            throw new IllegalStateException("Error while reading from SQL at row " + this.rowNum, e);
        }
    }
}

