/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.codec.customcodecs;

import com.github.luben.zstd.Zstd;
import java.io.IOException;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.Decompressor;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.codec.customcodecs.backward_codecs.lucene99.Lucene99CustomCodec;

public class ZstdNoDictCompressionMode
extends CompressionMode {
    private static final int NUM_SUB_BLOCKS = 10;
    private final int compressionLevel;

    protected ZstdNoDictCompressionMode() {
        this.compressionLevel = Lucene99CustomCodec.DEFAULT_COMPRESSION_LEVEL;
    }

    protected ZstdNoDictCompressionMode(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public Compressor newCompressor() {
        return new ZstdCompressor(this.compressionLevel);
    }

    public Decompressor newDecompressor() {
        return new ZstdDecompressor();
    }

    private static final class ZstdCompressor
    extends Compressor {
        private final int compressionLevel;
        private byte[] compressedBuffer;

        public ZstdCompressor(int compressionLevel) {
            this.compressionLevel = compressionLevel;
            this.compressedBuffer = BytesRef.EMPTY_BYTES;
        }

        private void compress(byte[] bytes, int offset, int length, DataOutput out) throws IOException {
            assert (offset >= 0) : "offset value must be greater than 0";
            int blockLength = (length + 10 - 1) / 10;
            out.writeVInt(blockLength);
            int end = offset + length;
            assert (end >= 0) : "buffer read size must be greater than 0";
            for (int start = offset; start < end; start += blockLength) {
                int l = Math.min(blockLength, end - start);
                if (l == 0) {
                    out.writeVInt(0);
                    return;
                }
                int maxCompressedLength = (int)Zstd.compressBound((long)l);
                this.compressedBuffer = ArrayUtil.growNoCopy((byte[])this.compressedBuffer, (int)maxCompressedLength);
                int compressedSize = (int)Zstd.compressByteArray((byte[])this.compressedBuffer, (int)0, (int)this.compressedBuffer.length, (byte[])bytes, (int)start, (int)l, (int)this.compressionLevel);
                out.writeVInt(compressedSize);
                out.writeBytes(this.compressedBuffer, compressedSize);
            }
        }

        public void compress(ByteBuffersDataInput buffersInput, DataOutput out) throws IOException {
            int length = (int)buffersInput.length();
            byte[] bytes = new byte[length];
            buffersInput.readBytes(bytes, 0, length);
            this.compress(bytes, 0, length, out);
        }

        public void close() throws IOException {
        }
    }

    private static final class ZstdDecompressor
    extends Decompressor {
        private byte[] compressed = BytesRef.EMPTY_BYTES;

        public void decompress(DataInput in, int originalLength, int offset, int length, BytesRef bytes) throws IOException {
            int compressedLength;
            assert (offset + length <= originalLength) : "buffer read size must be within limit";
            if (length == 0) {
                bytes.length = 0;
                return;
            }
            int blockLength = in.readVInt();
            bytes.length = 0;
            bytes.offset = 0;
            int offsetInBlock = 0;
            int offsetInBytesRef = offset;
            while (offsetInBlock + blockLength < offset) {
                compressedLength = in.readVInt();
                in.skipBytes((long)compressedLength);
                offsetInBlock += blockLength;
                offsetInBytesRef -= blockLength;
            }
            while (offsetInBlock < offset + length) {
                compressedLength = in.readVInt();
                if (compressedLength == 0) {
                    return;
                }
                this.compressed = ArrayUtil.growNoCopy((byte[])this.compressed, (int)compressedLength);
                in.readBytes(this.compressed, 0, compressedLength);
                int l = Math.min(blockLength, originalLength - offsetInBlock);
                bytes.bytes = ArrayUtil.grow((byte[])bytes.bytes, (int)(bytes.length + l));
                int uncompressed = (int)Zstd.decompressByteArray((byte[])bytes.bytes, (int)bytes.length, (int)l, (byte[])this.compressed, (int)0, (int)compressedLength);
                bytes.length += uncompressed;
                offsetInBlock += blockLength;
            }
            bytes.offset = offsetInBytesRef;
            bytes.length = length;
            assert (bytes.isValid()) : "decompression output is corrupted.";
        }

        public Decompressor clone() {
            return new ZstdDecompressor();
        }
    }
}

