/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.output.model.ModelTensor;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.output.model.ModelTensors;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.connector.MLConnectorSearchAction;
import org.opensearch.ml.common.transport.model.MLModelSearchAction;
import org.opensearch.ml.common.transport.model_group.MLModelGroupSearchAction;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="SearchIndexTool")
public class SearchIndexTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchIndexTool.class);
    public static final String INPUT_FIELD = "input";
    public static final String INDEX_FIELD = "index";
    public static final String QUERY_FIELD = "query";
    public static final String INPUT_SCHEMA_FIELD = "input_schema";
    public static final String STRICT_FIELD = "strict";
    public static final String TYPE = "SearchIndexTool";
    private static final String DEFAULT_DESCRIPTION = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available. Returns documents matching the query in the provided index.";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"string\",\"description\":\"OpenSearch index name. for example: index1\"},\"query\":{\"type\":\"object\",\"description\":\"OpenSearch search index query. You need to get index mapping to write correct search query. It must be a valid OpenSearch query. Valid value:\\n{\\\"query\\\":{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}},\\\"size\\\":2,\\\"_source\\\":\\\"population_description\\\"}\\nInvalid value: \\n{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}}\\nThe value is invalid because the match not wrapped by \\\"query\\\".\",\"additionalProperties\":false}},\"required\":[\"index\",\"query\"],\"additionalProperties\":false}";
    private static final Gson GSON = new GsonBuilder().serializeSpecialFloatingPointValues().create();
    public static final Map<String, Object> DEFAULT_ATTRIBUTES = Map.of("input_schema", "{\"type\":\"object\",\"properties\":{\"index\":{\"type\":\"string\",\"description\":\"OpenSearch index name. for example: index1\"},\"query\":{\"type\":\"object\",\"description\":\"OpenSearch search index query. You need to get index mapping to write correct search query. It must be a valid OpenSearch query. Valid value:\\n{\\\"query\\\":{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}},\\\"size\\\":2,\\\"_source\\\":\\\"population_description\\\"}\\nInvalid value: \\n{\\\"match\\\":{\\\"population_description\\\":\\\"seattle 2023 population\\\"}}\\nThe value is invalid because the match not wrapped by \\\"query\\\".\",\"additionalProperties\":false}},\"required\":[\"index\",\"query\"],\"additionalProperties\":false}", "strict", false);
    public static final String RETURN_RAW_RESPONSE = "return_raw_response";
    private String name = "SearchIndexTool";
    private Map<String, Object> attributes;
    private String description = "Use this tool to search an index by providing two parameters: 'index' for the index name, and 'query' for the OpenSearch DSL formatted query. Only use this tool when both index name and DSL query is available. Returns documents matching the query in the provided index.";
    private Client client;
    private NamedXContentRegistry xContentRegistry;

    public SearchIndexTool(Client client, NamedXContentRegistry xContentRegistry) {
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.attributes = new HashMap<String, Object>();
        this.attributes.put(INPUT_SCHEMA_FIELD, DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, false);
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public boolean validate(Map<String, String> parameters) {
        boolean validRequest;
        if (parameters == null || parameters.isEmpty()) {
            return false;
        }
        boolean argumentsFromInput = parameters.containsKey(INPUT_FIELD) && !StringUtils.isEmpty((CharSequence)parameters.get(INPUT_FIELD));
        boolean argumentsFromParameters = parameters.containsKey(INDEX_FIELD) && parameters.containsKey(QUERY_FIELD) && !StringUtils.isEmpty((CharSequence)parameters.get(INDEX_FIELD)) && !StringUtils.isEmpty((CharSequence)parameters.get(QUERY_FIELD));
        boolean bl = validRequest = argumentsFromInput || argumentsFromParameters;
        if (!validRequest) {
            log.error("SearchIndexTool's two parameter: index and query are required!");
            return false;
        }
        return true;
    }

    private SearchRequest getSearchRequest(String index, String query) throws IOException {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        XContentParser queryParser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, query);
        searchSourceBuilder.parseXContent(queryParser);
        return new SearchRequest().source(searchSourceBuilder).indices(new String[]{index});
    }

    private static Map<String, Object> processResponse(SearchHit hit) {
        HashMap<String, Object> docContent = new HashMap<String, Object>();
        docContent.put("_index", hit.getIndex());
        docContent.put("_id", hit.getId());
        docContent.put("_score", Float.valueOf(hit.getScore()));
        docContent.put("_source", hit.getSourceAsMap());
        return docContent;
    }

    public Map<String, Object> convertSearchResponseToMap(SearchResponse searchResponse) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder();
        searchResponse.toXContent(builder, ToXContent.EMPTY_PARAMS);
        BytesReference bytes = BytesReference.bytes((XContentBuilder)builder);
        try (XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, BytesReference.toBytes((BytesReference)bytes));){
            Map map = parser.map();
            return map;
        }
    }

    public <T> void run(Map<String, String> originalParameters, ActionListener<T> listener) {
        try {
            Map parameters = ToolUtils.extractInputParameters(originalParameters, this.attributes);
            String input = (String)parameters.get(INPUT_FIELD);
            String index = null;
            String query = null;
            boolean returnFullResponse = Boolean.parseBoolean(parameters.getOrDefault(RETURN_RAW_RESPONSE, "false"));
            if (!StringUtils.isEmpty((CharSequence)input)) {
                try {
                    JsonObject jsonObject = (JsonObject)GSON.fromJson(input, JsonObject.class);
                    if (jsonObject != null && jsonObject.has(INDEX_FIELD) && jsonObject.has(QUERY_FIELD)) {
                        index = jsonObject.get(INDEX_FIELD).getAsString();
                        JsonElement queryElement = jsonObject.get(QUERY_FIELD);
                        query = queryElement == null ? null : queryElement.toString();
                    }
                }
                catch (JsonSyntaxException e2) {
                    log.error("Invalid JSON input: {}", (Object)input, (Object)e2);
                }
            }
            if (StringUtils.isEmpty(index)) {
                index = (String)parameters.get(INDEX_FIELD);
            }
            if (StringUtils.isEmpty(query)) {
                query = (String)parameters.get(QUERY_FIELD);
            }
            if (StringUtils.isEmpty((CharSequence)index) || StringUtils.isEmpty((CharSequence)query)) {
                listener.onFailure((Exception)new IllegalArgumentException("SearchIndexTool's two parameters: index and query are required and should be in valid format"));
                return;
            }
            SearchRequest searchRequest = this.getSearchRequest(index, query);
            ActionListener actionListener = ActionListener.wrap(r -> {
                SearchHit[] hits = r.getHits().getHits();
                if (returnFullResponse) {
                    ArrayList<ModelTensors> outputs = new ArrayList<ModelTensors>();
                    ArrayList<ModelTensor> tensors = new ArrayList<ModelTensor>();
                    tensors.add(ModelTensor.builder().name(this.name).dataAsMap(this.convertSearchResponseToMap((SearchResponse)r)).build());
                    outputs.add(ModelTensors.builder().mlModelTensors(tensors).build());
                    ModelTensorOutput output = ModelTensorOutput.builder().mlModelOutputs(outputs).build();
                    listener.onResponse((Object)output);
                    return;
                }
                if (hits != null && hits.length > 0) {
                    StringBuilder contextBuilder = new StringBuilder();
                    for (SearchHit hit : hits) {
                        Map<String, Object> docContent = SearchIndexTool.processResponse(hit);
                        String doc = GSON.toJson(docContent);
                        contextBuilder.append(doc).append("\n");
                    }
                    listener.onResponse((Object)contextBuilder.toString());
                } else {
                    listener.onResponse((Object)"");
                }
            }, e -> {
                log.error("Failed to search index", (Throwable)e);
                listener.onFailure(e);
            });
            if (Objects.equals(index, ".plugins-ml-connector")) {
                this.client.execute((ActionType)MLConnectorSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model")) {
                this.client.execute((ActionType)MLModelSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else if (Objects.equals(index, ".plugins-ml-model-group")) {
                this.client.execute((ActionType)MLModelGroupSearchAction.INSTANCE, (ActionRequest)searchRequest, actionListener);
            } else {
                this.client.search(searchRequest, actionListener);
            }
        }
        catch (Exception e3) {
            log.error("Failed to run SearchIndexTool", (Throwable)e3);
            listener.onFailure(e3);
        }
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setXContentRegistry(NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public static class Factory
    implements Tool.Factory<SearchIndexTool> {
        private Client client;
        private static Factory INSTANCE;
        private NamedXContentRegistry xContentRegistry;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<SearchIndexTool> clazz = SearchIndexTool.class;
            synchronized (SearchIndexTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client, NamedXContentRegistry xContentRegistry) {
            this.client = client;
            this.xContentRegistry = xContentRegistry;
        }

        public SearchIndexTool create(Map<String, Object> params) {
            return new SearchIndexTool(this.client, this.xContentRegistry);
        }

        public String getDefaultDescription() {
            return SearchIndexTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return SearchIndexTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public Map<String, Object> getDefaultAttributes() {
            return DEFAULT_ATTRIBUTES;
        }
    }
}

