/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.BadCiphertextException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.annotation.concurrent.NotThreadSafe;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

@NotThreadSafe
class CipherHandler {
    private final int cipherMode_;
    private final SecretKey key_;
    private final CryptoAlgorithm cryptoAlgorithm_;
    private final Cipher cipher_;

    public byte[] cipherData(byte[] nonce, byte[] contentAad, byte[] content, int off, int len) {
        if (nonce.length != this.cryptoAlgorithm_.getNonceLen()) {
            throw new IllegalArgumentException("Invalid nonce length: " + nonce.length);
        }
        GCMParameterSpec spec = new GCMParameterSpec(this.cryptoAlgorithm_.getTagLen() * 8, nonce, 0, nonce.length);
        try {
            this.cipher_.init(this.cipherMode_, (Key)this.key_, spec);
            if (contentAad != null) {
                this.cipher_.updateAAD(contentAad);
            }
        }
        catch (GeneralSecurityException gsx) {
            throw new AwsCryptoException(gsx);
        }
        try {
            return this.cipher_.doFinal(content, off, len);
        }
        catch (GeneralSecurityException gsx) {
            throw new BadCiphertextException(gsx);
        }
    }

    CipherHandler(SecretKey key, int cipherMode, CryptoAlgorithm cryptoAlgorithm) {
        this.cipherMode_ = cipherMode;
        this.key_ = key;
        this.cryptoAlgorithm_ = cryptoAlgorithm;
        this.cipher_ = CipherHandler.buildCipherObject(cryptoAlgorithm);
    }

    private static Cipher buildCipherObject(CryptoAlgorithm alg) {
        try {
            return Cipher.getInstance("AES/GCM/NoPadding");
        }
        catch (GeneralSecurityException ex) {
            throw new IllegalStateException("Java does not support the requested algorithm", ex);
        }
    }
}

