/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.NormalizeMethod;
import org.opensearch.client.opensearch._types.aggregations.PipelineAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NormalizeAggregation
extends PipelineAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, NormalizeAggregation> {
    @Nullable
    private final NormalizeMethod method;
    public static final JsonpDeserializer<NormalizeAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NormalizeAggregation::setupNormalizeAggregationDeserializer);

    private NormalizeAggregation(Builder builder) {
        super(builder);
        this.method = builder.method;
    }

    public static NormalizeAggregation of(Function<Builder, ObjectBuilder<NormalizeAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Normalize;
    }

    @Nullable
    public final NormalizeMethod method() {
        return this.method;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.method != null) {
            generator.writeKey("method");
            this.method.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNormalizeAggregationDeserializer(ObjectDeserializer<Builder> op) {
        NormalizeAggregation.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::method, NormalizeMethod._DESERIALIZER, "method");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.method);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NormalizeAggregation other = (NormalizeAggregation)o;
        return Objects.equals(this.method, other.method);
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NormalizeAggregation> {
        @Nullable
        private NormalizeMethod method;

        public Builder() {
        }

        private Builder(NormalizeAggregation o) {
            super(o);
            this.method = o.method;
        }

        private Builder(Builder o) {
            super(o);
            this.method = o.method;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder method(@Nullable NormalizeMethod value) {
            this.method = value;
            return this;
        }

        @Override
        @Nonnull
        public NormalizeAggregation build() {
            this._checkSingleUse();
            return new NormalizeAggregation(this);
        }
    }
}

