/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBase;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.ValueType;
import org.opensearch.client.opensearch._types.aggregations.WeightedAverageValue;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class WeightedAverageAggregation
extends AggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, WeightedAverageAggregation> {
    @Nullable
    private final String format;
    @Nullable
    private final WeightedAverageValue value;
    @Nullable
    private final ValueType valueType;
    @Nullable
    private final WeightedAverageValue weight;
    public static final JsonpDeserializer<WeightedAverageAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WeightedAverageAggregation::setupWeightedAverageAggregationDeserializer);

    private WeightedAverageAggregation(Builder builder) {
        super(builder);
        this.format = builder.format;
        this.value = builder.value;
        this.valueType = builder.valueType;
        this.weight = builder.weight;
    }

    public static WeightedAverageAggregation of(Function<Builder, ObjectBuilder<WeightedAverageAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.WeightedAvg;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final WeightedAverageValue value() {
        return this.value;
    }

    @Nullable
    public final ValueType valueType() {
        return this.valueType;
    }

    @Nullable
    public final WeightedAverageValue weight() {
        return this.weight;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.value != null) {
            generator.writeKey("value");
            this.value.serialize(generator, mapper);
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            this.valueType.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            this.weight.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupWeightedAverageAggregationDeserializer(ObjectDeserializer<Builder> op) {
        WeightedAverageAggregation.setupAggregationBaseDeserializer(op);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::value, WeightedAverageValue._DESERIALIZER, "value");
        op.add(Builder::valueType, ValueType._DESERIALIZER, "value_type");
        op.add(Builder::weight, WeightedAverageValue._DESERIALIZER, "weight");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.format);
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.valueType);
        result = 31 * result + Objects.hashCode(this.weight);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedAverageAggregation other = (WeightedAverageAggregation)o;
        return Objects.equals(this.format, other.format) && Objects.equals(this.value, other.value) && Objects.equals(this.valueType, other.valueType) && Objects.equals(this.weight, other.weight);
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, WeightedAverageAggregation> {
        @Nullable
        private String format;
        @Nullable
        private WeightedAverageValue value;
        @Nullable
        private ValueType valueType;
        @Nullable
        private WeightedAverageValue weight;

        public Builder() {
        }

        private Builder(WeightedAverageAggregation o) {
            super(o);
            this.format = o.format;
            this.value = o.value;
            this.valueType = o.valueType;
            this.weight = o.weight;
        }

        private Builder(Builder o) {
            super(o);
            this.format = o.format;
            this.value = o.value;
            this.valueType = o.valueType;
            this.weight = o.weight;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        @Nonnull
        public final Builder value(@Nullable WeightedAverageValue value) {
            this.value = value;
            return this;
        }

        @Nonnull
        public final Builder value(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.value(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        @Nonnull
        public final Builder valueType(@Nullable ValueType value) {
            this.valueType = value;
            return this;
        }

        @Nonnull
        public final Builder weight(@Nullable WeightedAverageValue value) {
            this.weight = value;
            return this;
        }

        @Nonnull
        public final Builder weight(Function<WeightedAverageValue.Builder, ObjectBuilder<WeightedAverageValue>> fn) {
            return this.weight(fn.apply(new WeightedAverageValue.Builder()).build());
        }

        @Override
        @Nonnull
        public WeightedAverageAggregation build() {
            this._checkSingleUse();
            return new WeightedAverageAggregation(this);
        }
    }
}

