/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.IndexRoutingAllocation;
import org.opensearch.client.opensearch.indices.IndexRoutingRebalance;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexRouting
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexRouting> {
    @Nullable
    private final IndexRoutingAllocation allocation;
    @Nullable
    private final IndexRoutingRebalance rebalance;
    public static final JsonpDeserializer<IndexRouting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexRouting::setupIndexRoutingDeserializer);

    private IndexRouting(Builder builder) {
        this.allocation = builder.allocation;
        this.rebalance = builder.rebalance;
    }

    public static IndexRouting of(Function<Builder, ObjectBuilder<IndexRouting>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final IndexRoutingAllocation allocation() {
        return this.allocation;
    }

    @Nullable
    public final IndexRoutingRebalance rebalance() {
        return this.rebalance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allocation != null) {
            generator.writeKey("allocation");
            this.allocation.serialize(generator, mapper);
        }
        if (this.rebalance != null) {
            generator.writeKey("rebalance");
            this.rebalance.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexRoutingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocation, IndexRoutingAllocation._DESERIALIZER, "allocation");
        op.add(Builder::rebalance, IndexRoutingRebalance._DESERIALIZER, "rebalance");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allocation);
        result = 31 * result + Objects.hashCode(this.rebalance);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRouting other = (IndexRouting)o;
        return Objects.equals(this.allocation, other.allocation) && Objects.equals(this.rebalance, other.rebalance);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexRouting> {
        @Nullable
        private IndexRoutingAllocation allocation;
        @Nullable
        private IndexRoutingRebalance rebalance;

        public Builder() {
        }

        private Builder(IndexRouting o) {
            this.allocation = o.allocation;
            this.rebalance = o.rebalance;
        }

        private Builder(Builder o) {
            this.allocation = o.allocation;
            this.rebalance = o.rebalance;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder allocation(@Nullable IndexRoutingAllocation value) {
            this.allocation = value;
            return this;
        }

        @Nonnull
        public final Builder allocation(Function<IndexRoutingAllocation.Builder, ObjectBuilder<IndexRoutingAllocation>> fn) {
            return this.allocation(fn.apply(new IndexRoutingAllocation.Builder()).build());
        }

        @Nonnull
        public final Builder rebalance(@Nullable IndexRoutingRebalance value) {
            this.rebalance = value;
            return this;
        }

        @Nonnull
        public final Builder rebalance(Function<IndexRoutingRebalance.Builder, ObjectBuilder<IndexRoutingRebalance>> fn) {
            return this.rebalance(fn.apply(new IndexRoutingRebalance.Builder()).build());
        }

        @Override
        @Nonnull
        public IndexRouting build() {
            this._checkSingleUse();
            return new IndexRouting(this);
        }
    }
}

