/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.resolve_index.ResolveIndexAliasItem;
import org.opensearch.client.opensearch.indices.resolve_index.ResolveIndexDataStreamsItem;
import org.opensearch.client.opensearch.indices.resolve_index.ResolveIndexItem;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ResolveIndexResponse
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ResolveIndexResponse> {
    @Nonnull
    private final List<ResolveIndexAliasItem> aliases;
    @Nonnull
    private final List<ResolveIndexDataStreamsItem> dataStreams;
    @Nonnull
    private final List<ResolveIndexItem> indices;
    public static final JsonpDeserializer<ResolveIndexResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResolveIndexResponse::setupResolveIndexResponseDeserializer);

    private ResolveIndexResponse(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiableRequired(builder.aliases, (Object)this, "aliases");
        this.dataStreams = ApiTypeHelper.unmodifiableRequired(builder.dataStreams, (Object)this, "dataStreams");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static ResolveIndexResponse of(Function<Builder, ObjectBuilder<ResolveIndexResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<ResolveIndexAliasItem> aliases() {
        return this.aliases;
    }

    @Nonnull
    public final List<ResolveIndexDataStreamsItem> dataStreams() {
        return this.dataStreams;
    }

    @Nonnull
    public final List<ResolveIndexItem> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("aliases");
        generator.writeStartArray();
        for (ResolveIndexAliasItem resolveIndexAliasItem : this.aliases) {
            resolveIndexAliasItem.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("data_streams");
        generator.writeStartArray();
        for (ResolveIndexDataStreamsItem resolveIndexDataStreamsItem : this.dataStreams) {
            resolveIndexDataStreamsItem.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("indices");
        generator.writeStartArray();
        for (ResolveIndexItem resolveIndexItem : this.indices) {
            resolveIndexItem.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupResolveIndexResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.arrayDeserializer(ResolveIndexAliasItem._DESERIALIZER), "aliases");
        op.add(Builder::dataStreams, JsonpDeserializer.arrayDeserializer(ResolveIndexDataStreamsItem._DESERIALIZER), "data_streams");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(ResolveIndexItem._DESERIALIZER), "indices");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.aliases.hashCode();
        result = 31 * result + this.dataStreams.hashCode();
        result = 31 * result + this.indices.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResolveIndexResponse other = (ResolveIndexResponse)o;
        return this.aliases.equals(other.aliases) && this.dataStreams.equals(other.dataStreams) && this.indices.equals(other.indices);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ResolveIndexResponse> {
        private List<ResolveIndexAliasItem> aliases;
        private List<ResolveIndexDataStreamsItem> dataStreams;
        private List<ResolveIndexItem> indices;

        public Builder() {
        }

        private Builder(ResolveIndexResponse o) {
            this.aliases = Builder._listCopy(o.aliases);
            this.dataStreams = Builder._listCopy(o.dataStreams);
            this.indices = Builder._listCopy(o.indices);
        }

        private Builder(Builder o) {
            this.aliases = Builder._listCopy(o.aliases);
            this.dataStreams = Builder._listCopy(o.dataStreams);
            this.indices = Builder._listCopy(o.indices);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aliases(List<ResolveIndexAliasItem> list) {
            this.aliases = Builder._listAddAll(this.aliases, list);
            return this;
        }

        @Nonnull
        public final Builder aliases(ResolveIndexAliasItem value, ResolveIndexAliasItem ... values) {
            this.aliases = Builder._listAdd(this.aliases, value, values);
            return this;
        }

        @Nonnull
        public final Builder aliases(Function<ResolveIndexAliasItem.Builder, ObjectBuilder<ResolveIndexAliasItem>> fn) {
            return this.aliases(fn.apply(new ResolveIndexAliasItem.Builder()).build(), new ResolveIndexAliasItem[0]);
        }

        @Nonnull
        public final Builder dataStreams(List<ResolveIndexDataStreamsItem> list) {
            this.dataStreams = Builder._listAddAll(this.dataStreams, list);
            return this;
        }

        @Nonnull
        public final Builder dataStreams(ResolveIndexDataStreamsItem value, ResolveIndexDataStreamsItem ... values) {
            this.dataStreams = Builder._listAdd(this.dataStreams, value, values);
            return this;
        }

        @Nonnull
        public final Builder dataStreams(Function<ResolveIndexDataStreamsItem.Builder, ObjectBuilder<ResolveIndexDataStreamsItem>> fn) {
            return this.dataStreams(fn.apply(new ResolveIndexDataStreamsItem.Builder()).build(), new ResolveIndexDataStreamsItem[0]);
        }

        @Nonnull
        public final Builder indices(List<ResolveIndexItem> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        @Nonnull
        public final Builder indices(ResolveIndexItem value, ResolveIndexItem ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        @Nonnull
        public final Builder indices(Function<ResolveIndexItem.Builder, ObjectBuilder<ResolveIndexItem>> fn) {
            return this.indices(fn.apply(new ResolveIndexItem.Builder()).build(), new ResolveIndexItem[0]);
        }

        @Override
        @Nonnull
        public ResolveIndexResponse build() {
            this._checkSingleUse();
            return new ResolveIndexResponse(this);
        }
    }
}

