/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CgroupCpuStat
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CgroupCpuStat> {
    @Nullable
    private final Long numberOfElapsedPeriods;
    @Nullable
    private final Long numberOfTimesThrottled;
    @Nullable
    private final Long timeThrottledNanos;
    public static final JsonpDeserializer<CgroupCpuStat> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CgroupCpuStat::setupCgroupCpuStatDeserializer);

    private CgroupCpuStat(Builder builder) {
        this.numberOfElapsedPeriods = builder.numberOfElapsedPeriods;
        this.numberOfTimesThrottled = builder.numberOfTimesThrottled;
        this.timeThrottledNanos = builder.timeThrottledNanos;
    }

    public static CgroupCpuStat of(Function<Builder, ObjectBuilder<CgroupCpuStat>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long numberOfElapsedPeriods() {
        return this.numberOfElapsedPeriods;
    }

    @Nullable
    public final Long numberOfTimesThrottled() {
        return this.numberOfTimesThrottled;
    }

    @Nullable
    public final Long timeThrottledNanos() {
        return this.timeThrottledNanos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numberOfElapsedPeriods != null) {
            generator.writeKey("number_of_elapsed_periods");
            generator.write(this.numberOfElapsedPeriods.longValue());
        }
        if (this.numberOfTimesThrottled != null) {
            generator.writeKey("number_of_times_throttled");
            generator.write(this.numberOfTimesThrottled.longValue());
        }
        if (this.timeThrottledNanos != null) {
            generator.writeKey("time_throttled_nanos");
            generator.write(this.timeThrottledNanos.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCgroupCpuStatDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numberOfElapsedPeriods, JsonpDeserializer.longDeserializer(), "number_of_elapsed_periods");
        op.add(Builder::numberOfTimesThrottled, JsonpDeserializer.longDeserializer(), "number_of_times_throttled");
        op.add(Builder::timeThrottledNanos, JsonpDeserializer.longDeserializer(), "time_throttled_nanos");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.numberOfElapsedPeriods);
        result = 31 * result + Objects.hashCode(this.numberOfTimesThrottled);
        result = 31 * result + Objects.hashCode(this.timeThrottledNanos);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CgroupCpuStat other = (CgroupCpuStat)o;
        return Objects.equals(this.numberOfElapsedPeriods, other.numberOfElapsedPeriods) && Objects.equals(this.numberOfTimesThrottled, other.numberOfTimesThrottled) && Objects.equals(this.timeThrottledNanos, other.timeThrottledNanos);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CgroupCpuStat> {
        @Nullable
        private Long numberOfElapsedPeriods;
        @Nullable
        private Long numberOfTimesThrottled;
        @Nullable
        private Long timeThrottledNanos;

        public Builder() {
        }

        private Builder(CgroupCpuStat o) {
            this.numberOfElapsedPeriods = o.numberOfElapsedPeriods;
            this.numberOfTimesThrottled = o.numberOfTimesThrottled;
            this.timeThrottledNanos = o.timeThrottledNanos;
        }

        private Builder(Builder o) {
            this.numberOfElapsedPeriods = o.numberOfElapsedPeriods;
            this.numberOfTimesThrottled = o.numberOfTimesThrottled;
            this.timeThrottledNanos = o.timeThrottledNanos;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder numberOfElapsedPeriods(@Nullable Long value) {
            this.numberOfElapsedPeriods = value;
            return this;
        }

        @Nonnull
        public final Builder numberOfTimesThrottled(@Nullable Long value) {
            this.numberOfTimesThrottled = value;
            return this;
        }

        @Nonnull
        public final Builder timeThrottledNanos(@Nullable Long value) {
            this.timeThrottledNanos = value;
            return this;
        }

        @Override
        @Nonnull
        public CgroupCpuStat build() {
            this._checkSingleUse();
            return new CgroupCpuStat(this);
        }
    }
}

