/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.SecurityAnalyticsPlugin;
import org.opensearch.securityanalytics.action.TestS3ConnectionAction;
import org.opensearch.securityanalytics.action.TestS3ConnectionRequest;
import org.opensearch.transport.client.node.NodeClient;

public class RestTestS3ConnectionAction
extends BaseRestHandler {
    private static final Logger log = LogManager.getLogger(RestTestS3ConnectionAction.class);

    public String getName() {
        return "test_connection_s3";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, SecurityAnalyticsPlugin.TEST_S3_CONNECTION_URI));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        log.debug(String.format(Locale.getDefault(), "%s %s", request.method(), SecurityAnalyticsPlugin.TEST_S3_CONNECTION_URI));
        XContentParser xcp = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        TestS3ConnectionRequest testRequest = TestS3ConnectionRequest.parse(xcp);
        return channel -> client.execute((ActionType)TestS3ConnectionAction.INSTANCE, (ActionRequest)testRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

