/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.rules.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.securityanalytics.rules.condition.ConditionAND;
import org.opensearch.securityanalytics.rules.condition.ConditionFieldEqualsValueExpression;
import org.opensearch.securityanalytics.rules.condition.ConditionItem;
import org.opensearch.securityanalytics.rules.condition.ConditionOR;
import org.opensearch.securityanalytics.rules.condition.ConditionValueExpression;
import org.opensearch.securityanalytics.rules.exceptions.SigmaConditionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaModifierError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaRegularExpressionError;
import org.opensearch.securityanalytics.rules.exceptions.SigmaValueError;
import org.opensearch.securityanalytics.rules.modifiers.SigmaListModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaModifier;
import org.opensearch.securityanalytics.rules.modifiers.SigmaModifierFacade;
import org.opensearch.securityanalytics.rules.modifiers.SigmaValueModifier;
import org.opensearch.securityanalytics.rules.objects.SigmaDetection;
import org.opensearch.securityanalytics.rules.objects.SigmaDetections;
import org.opensearch.securityanalytics.rules.types.SigmaNull;
import org.opensearch.securityanalytics.rules.types.SigmaString;
import org.opensearch.securityanalytics.rules.types.SigmaType;
import org.opensearch.securityanalytics.rules.types.SigmaTypeFacade;
import org.opensearch.securityanalytics.rules.utils.AnyOneOf;
import org.opensearch.securityanalytics.rules.utils.Either;

public class SigmaDetectionItem {
    private String field;
    private List<Class<? extends SigmaModifier>> modifiers;
    private List<SigmaType> value;
    private Either<Class<ConditionAND>, Class<ConditionOR>> valueLinking;
    private SigmaType originalValue;
    private boolean autoModifiers;
    private SigmaDetection parent;

    public SigmaDetectionItem(String field, List<Class<? extends SigmaModifier>> modifiers, List<SigmaType> value, Either<Class<ConditionAND>, Class<ConditionOR>> valueLinking, SigmaType originalValue, boolean autoModifiers) throws SigmaModifierError, SigmaValueError, SigmaRegularExpressionError {
        this.field = field;
        this.modifiers = modifiers;
        this.value = value;
        this.valueLinking = valueLinking != null ? valueLinking : Either.right(ConditionOR.class);
        this.originalValue = originalValue;
        this.autoModifiers = autoModifiers;
        if (autoModifiers) {
            this.applyModifiers();
        }
    }

    private void applyModifiers() throws SigmaModifierError, SigmaValueError, SigmaRegularExpressionError {
        ArrayList<Class<? extends SigmaModifier>> appliedModifiers = new ArrayList<Class<? extends SigmaModifier>>();
        for (Class<? extends SigmaModifier> modifier : this.modifiers) {
            SigmaModifier modifierInstance = SigmaModifierFacade.sigmaModifier(modifier, this, appliedModifiers);
            if (modifierInstance instanceof SigmaValueModifier) {
                ArrayList<SigmaType> appliedValue = new ArrayList<SigmaType>();
                for (SigmaType val : this.value) {
                    appliedValue.addAll(modifierInstance.apply(Either.left(val)));
                }
                this.value = appliedValue;
            } else if (modifierInstance instanceof SigmaListModifier) {
                this.value = modifierInstance.apply(Either.right(this.value));
            } else {
                throw new IllegalArgumentException("Instance of SigmaValueModifier or SigmaListModifier was expected");
            }
            appliedModifiers.add(modifier);
        }
    }

    public static <T> SigmaDetectionItem fromMapping(String key, Either<T, List<T>> val) throws SigmaModifierError, SigmaValueError, SigmaRegularExpressionError {
        String[] tokens;
        String field = null;
        List<Object> modifierIds = new ArrayList();
        if (key != null && (tokens = key.split("\\|")).length > 0) {
            field = tokens[0].isEmpty() ? null : tokens[0];
            modifierIds = Arrays.stream(tokens).skip(1L).collect(Collectors.toList());
        }
        ArrayList<Class<? extends SigmaModifier>> modifiers = new ArrayList<Class<? extends SigmaModifier>>();
        for (String string : modifierIds) {
            Class<? extends SigmaModifier> modifier = SigmaModifierFacade.getModifier(string);
            if (modifier != null) {
                modifiers.add(modifier);
                continue;
            }
            throw new SigmaModifierError("Unknown modifier " + string);
        }
        ArrayList<T> values = new ArrayList<T>();
        if (val != null && val.isLeft()) {
            values.add(val.getLeft());
        } else if (val != null && val.isRight()) {
            values.addAll((Collection)val.get());
        } else {
            values.add(null);
        }
        ArrayList<SigmaType> arrayList = new ArrayList<SigmaType>();
        for (Object v : values) {
            boolean invalidModifierWithEmptyString;
            SigmaType sigmaType = SigmaTypeFacade.sigmaType(v);
            boolean bl = invalidModifierWithEmptyString = modifierIds.contains("contains") || modifierIds.contains("startswith") || modifierIds.contains("endswith");
            if (sigmaType.getClass().equals(SigmaString.class) && v.toString().isEmpty() && invalidModifierWithEmptyString) {
                throw new SigmaValueError("Cannot create rule with empty string and given modifier(s): " + String.valueOf(modifierIds));
            }
            arrayList.add(sigmaType);
        }
        return new SigmaDetectionItem(field, modifiers, arrayList, null, null, true);
    }

    public static <T> SigmaDetectionItem fromValue(Either<T, List<T>> val) throws SigmaModifierError, SigmaValueError, SigmaRegularExpressionError {
        return SigmaDetectionItem.fromMapping(null, val);
    }

    public Either<Either<ConditionAND, ConditionOR>, Either<ConditionFieldEqualsValueExpression, ConditionValueExpression>> postProcess(SigmaDetections detections, Object parent) throws SigmaConditionError {
        this.parent = (SigmaDetection)parent;
        if (this.value.size() == 0) {
            if (this.field == null) {
                throw new SigmaConditionError("Null value must be bound to a field");
            }
            return Either.right(Either.left(new ConditionFieldEqualsValueExpression(this.field, new SigmaNull()).postProcess(detections, this)));
        }
        if (this.value.size() == 1) {
            if (this.field == null) {
                return Either.right(Either.right(new ConditionValueExpression(this.value.get(0)).postProcess(detections, this)));
            }
            return Either.right(Either.left(new ConditionFieldEqualsValueExpression(this.field, this.value.get(0)).postProcess(detections, this)));
        }
        ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>> valueExpressions = new ArrayList<Either<AnyOneOf<ConditionItem, ConditionFieldEqualsValueExpression, ConditionValueExpression>, String>>();
        if (this.field == null) {
            for (SigmaType v : this.value) {
                valueExpressions.add(Either.left(AnyOneOf.rightVal(new ConditionValueExpression(v))));
            }
            if (this.valueLinking.isLeft()) {
                ConditionAND conditionAND = new ConditionAND(false, valueExpressions);
                conditionAND = (ConditionAND)conditionAND.postProcess(detections, this);
                return Either.left(Either.left(conditionAND));
            }
            if (this.valueLinking.isRight()) {
                ConditionOR conditionOR = new ConditionOR(false, valueExpressions);
                conditionOR = (ConditionOR)conditionOR.postProcess(detections, this);
                return Either.left(Either.right(conditionOR));
            }
        } else {
            for (SigmaType v : this.value) {
                valueExpressions.add(Either.left(AnyOneOf.middleVal(new ConditionFieldEqualsValueExpression(this.field, v))));
            }
            if (this.valueLinking.isLeft()) {
                ConditionAND conditionAND = new ConditionAND(false, valueExpressions);
                conditionAND = (ConditionAND)conditionAND.postProcess(detections, this);
                return Either.left(Either.left(conditionAND));
            }
            if (this.valueLinking.isRight()) {
                Object conditionOR = new ConditionOR(false, valueExpressions);
                conditionOR = (ConditionOR)((ConditionItem)conditionOR).postProcess(detections, this);
                return Either.left(Either.right(conditionOR));
            }
        }
        return null;
    }

    public boolean isKeyword() {
        return this.field == null;
    }

    public String getField() {
        return this.field;
    }

    public List<SigmaType> getValue() {
        return this.value;
    }

    public List<Class<? extends SigmaModifier>> getModifiers() {
        return this.modifiers;
    }

    public Either<Class<ConditionAND>, Class<ConditionOR>> getValueLinking() {
        return this.valueLinking;
    }

    public void setValueLinking(Either<Class<ConditionAND>, Class<ConditionOR>> valueLinking) {
        this.valueLinking = valueLinking;
    }
}

