/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.AutoScalingPolicyUpdate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoScalingSettingsUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoScalingSettingsUpdate> {
    private static final SdkField<Long> MINIMUM_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinimumUnits").getter(AutoScalingSettingsUpdate.getter(AutoScalingSettingsUpdate::minimumUnits)).setter(AutoScalingSettingsUpdate.setter(Builder::minimumUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumUnits").build()}).build();
    private static final SdkField<Long> MAXIMUM_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaximumUnits").getter(AutoScalingSettingsUpdate.getter(AutoScalingSettingsUpdate::maximumUnits)).setter(AutoScalingSettingsUpdate.setter(Builder::maximumUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumUnits").build()}).build();
    private static final SdkField<Boolean> AUTO_SCALING_DISABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoScalingDisabled").getter(AutoScalingSettingsUpdate.getter(AutoScalingSettingsUpdate::autoScalingDisabled)).setter(AutoScalingSettingsUpdate.setter(Builder::autoScalingDisabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingDisabled").build()}).build();
    private static final SdkField<String> AUTO_SCALING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoScalingRoleArn").getter(AutoScalingSettingsUpdate.getter(AutoScalingSettingsUpdate::autoScalingRoleArn)).setter(AutoScalingSettingsUpdate.setter(Builder::autoScalingRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingRoleArn").build()}).build();
    private static final SdkField<AutoScalingPolicyUpdate> SCALING_POLICY_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingPolicyUpdate").getter(AutoScalingSettingsUpdate.getter(AutoScalingSettingsUpdate::scalingPolicyUpdate)).setter(AutoScalingSettingsUpdate.setter(Builder::scalingPolicyUpdate)).constructor(AutoScalingPolicyUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicyUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MINIMUM_UNITS_FIELD, MAXIMUM_UNITS_FIELD, AUTO_SCALING_DISABLED_FIELD, AUTO_SCALING_ROLE_ARN_FIELD, SCALING_POLICY_UPDATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutoScalingSettingsUpdate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long minimumUnits;
    private final Long maximumUnits;
    private final Boolean autoScalingDisabled;
    private final String autoScalingRoleArn;
    private final AutoScalingPolicyUpdate scalingPolicyUpdate;

    private AutoScalingSettingsUpdate(BuilderImpl builder) {
        this.minimumUnits = builder.minimumUnits;
        this.maximumUnits = builder.maximumUnits;
        this.autoScalingDisabled = builder.autoScalingDisabled;
        this.autoScalingRoleArn = builder.autoScalingRoleArn;
        this.scalingPolicyUpdate = builder.scalingPolicyUpdate;
    }

    public final Long minimumUnits() {
        return this.minimumUnits;
    }

    public final Long maximumUnits() {
        return this.maximumUnits;
    }

    public final Boolean autoScalingDisabled() {
        return this.autoScalingDisabled;
    }

    public final String autoScalingRoleArn() {
        return this.autoScalingRoleArn;
    }

    public final AutoScalingPolicyUpdate scalingPolicyUpdate() {
        return this.scalingPolicyUpdate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingPolicyUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingSettingsUpdate)) {
            return false;
        }
        AutoScalingSettingsUpdate other = (AutoScalingSettingsUpdate)obj;
        return Objects.equals(this.minimumUnits(), other.minimumUnits()) && Objects.equals(this.maximumUnits(), other.maximumUnits()) && Objects.equals(this.autoScalingDisabled(), other.autoScalingDisabled()) && Objects.equals(this.autoScalingRoleArn(), other.autoScalingRoleArn()) && Objects.equals(this.scalingPolicyUpdate(), other.scalingPolicyUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"AutoScalingSettingsUpdate").add("MinimumUnits", (Object)this.minimumUnits()).add("MaximumUnits", (Object)this.maximumUnits()).add("AutoScalingDisabled", (Object)this.autoScalingDisabled()).add("AutoScalingRoleArn", (Object)this.autoScalingRoleArn()).add("ScalingPolicyUpdate", (Object)this.scalingPolicyUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinimumUnits": {
                return Optional.ofNullable(clazz.cast(this.minimumUnits()));
            }
            case "MaximumUnits": {
                return Optional.ofNullable(clazz.cast(this.maximumUnits()));
            }
            case "AutoScalingDisabled": {
                return Optional.ofNullable(clazz.cast(this.autoScalingDisabled()));
            }
            case "AutoScalingRoleArn": {
                return Optional.ofNullable(clazz.cast(this.autoScalingRoleArn()));
            }
            case "ScalingPolicyUpdate": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicyUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MinimumUnits", MINIMUM_UNITS_FIELD);
        map.put("MaximumUnits", MAXIMUM_UNITS_FIELD);
        map.put("AutoScalingDisabled", AUTO_SCALING_DISABLED_FIELD);
        map.put("AutoScalingRoleArn", AUTO_SCALING_ROLE_ARN_FIELD);
        map.put("ScalingPolicyUpdate", SCALING_POLICY_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingSettingsUpdate, T> g) {
        return obj -> g.apply((AutoScalingSettingsUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long minimumUnits;
        private Long maximumUnits;
        private Boolean autoScalingDisabled;
        private String autoScalingRoleArn;
        private AutoScalingPolicyUpdate scalingPolicyUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingSettingsUpdate model) {
            this.minimumUnits(model.minimumUnits);
            this.maximumUnits(model.maximumUnits);
            this.autoScalingDisabled(model.autoScalingDisabled);
            this.autoScalingRoleArn(model.autoScalingRoleArn);
            this.scalingPolicyUpdate(model.scalingPolicyUpdate);
        }

        public final Long getMinimumUnits() {
            return this.minimumUnits;
        }

        public final void setMinimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
        }

        @Override
        public final Builder minimumUnits(Long minimumUnits) {
            this.minimumUnits = minimumUnits;
            return this;
        }

        public final Long getMaximumUnits() {
            return this.maximumUnits;
        }

        public final void setMaximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
        }

        @Override
        public final Builder maximumUnits(Long maximumUnits) {
            this.maximumUnits = maximumUnits;
            return this;
        }

        public final Boolean getAutoScalingDisabled() {
            return this.autoScalingDisabled;
        }

        public final void setAutoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
        }

        @Override
        public final Builder autoScalingDisabled(Boolean autoScalingDisabled) {
            this.autoScalingDisabled = autoScalingDisabled;
            return this;
        }

        public final String getAutoScalingRoleArn() {
            return this.autoScalingRoleArn;
        }

        public final void setAutoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
        }

        @Override
        public final Builder autoScalingRoleArn(String autoScalingRoleArn) {
            this.autoScalingRoleArn = autoScalingRoleArn;
            return this;
        }

        public final AutoScalingPolicyUpdate.Builder getScalingPolicyUpdate() {
            return this.scalingPolicyUpdate != null ? this.scalingPolicyUpdate.toBuilder() : null;
        }

        public final void setScalingPolicyUpdate(AutoScalingPolicyUpdate.BuilderImpl scalingPolicyUpdate) {
            this.scalingPolicyUpdate = scalingPolicyUpdate != null ? scalingPolicyUpdate.build() : null;
        }

        @Override
        public final Builder scalingPolicyUpdate(AutoScalingPolicyUpdate scalingPolicyUpdate) {
            this.scalingPolicyUpdate = scalingPolicyUpdate;
            return this;
        }

        public AutoScalingSettingsUpdate build() {
            return new AutoScalingSettingsUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoScalingSettingsUpdate> {
        public Builder minimumUnits(Long var1);

        public Builder maximumUnits(Long var1);

        public Builder autoScalingDisabled(Boolean var1);

        public Builder autoScalingRoleArn(String var1);

        public Builder scalingPolicyUpdate(AutoScalingPolicyUpdate var1);

        default public Builder scalingPolicyUpdate(Consumer<AutoScalingPolicyUpdate.Builder> scalingPolicyUpdate) {
            return this.scalingPolicyUpdate((AutoScalingPolicyUpdate)((AutoScalingPolicyUpdate.Builder)AutoScalingPolicyUpdate.builder().applyMutation(scalingPolicyUpdate)).build());
        }
    }
}

