/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenFilterFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.TokenizerFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;
import org.apache.lucene.util.ResourceLoader;
import org.apache.lucene.util.ResourceLoaderAware;

@Deprecated
public class SynonymFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "synonym";
    private final boolean ignoreCase;
    private final String tokenizerFactory;
    private final String synonyms;
    private final String format;
    private final boolean expand;
    private final String analyzerName;
    private final Map<String, String> tokArgs = new HashMap<String, String>();
    private SynonymMap map;

    public SynonymFilterFactory(Map<String, String> args) {
        super(args);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        this.synonyms = this.require(args, "synonyms");
        this.format = this.get(args, "format");
        this.expand = this.getBoolean(args, "expand", true);
        this.analyzerName = this.get(args, "analyzer");
        this.tokenizerFactory = this.get(args, "tokenizerFactory");
        if (this.analyzerName != null && this.tokenizerFactory != null) {
            throw new IllegalArgumentException("Analyzer and TokenizerFactory can't be specified both: " + this.analyzerName + " and " + this.tokenizerFactory);
        }
        if (this.tokenizerFactory != null) {
            this.tokArgs.put("luceneMatchVersion", this.getLuceneMatchVersion().toString());
            Iterator<String> itr = args.keySet().iterator();
            while (itr.hasNext()) {
                String key = itr.next();
                this.tokArgs.put(key.replaceAll("^tokenizerFactory\\.", ""), args.get(key));
                itr.remove();
            }
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + String.valueOf(args));
        }
    }

    public SynonymFilterFactory() {
        throw SynonymFilterFactory.defaultCtorException();
    }

    public TokenStream create(TokenStream input) {
        return this.map.fst == null ? input : new SynonymFilter(input, this.map, this.ignoreCase);
    }

    public void inform(ResourceLoader loader) throws IOException {
        final TokenizerFactory factory = this.tokenizerFactory == null ? null : this.loadTokenizerFactory(loader, this.tokenizerFactory);
        Analyzer analyzer = this.analyzerName != null ? this.loadAnalyzer(loader, this.analyzerName) : new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                WhitespaceTokenizer tokenizer = factory == null ? new WhitespaceTokenizer() : factory.create();
                WhitespaceTokenizer stream = SynonymFilterFactory.this.ignoreCase ? new LowerCaseFilter((TokenStream)tokenizer) : tokenizer;
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)stream);
            }
        };
        try (Analyzer a = analyzer;){
            String formatClass = this.format;
            if (this.format == null || this.format.equals("solr")) {
                formatClass = SolrSynonymParser.class.getName();
            } else if (this.format.equals("wordnet")) {
                formatClass = WordnetSynonymParser.class.getName();
            }
            this.map = this.loadSynonyms(loader, formatClass, true, a);
        }
        catch (ParseException e) {
            throw new IOException("Error parsing synonyms file:", e);
        }
    }

    protected SynonymMap loadSynonyms(ResourceLoader loader, String cname, boolean dedup, Analyzer analyzer) throws IOException, ParseException {
        SynonymMap.Parser parser;
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        Class clazz = loader.findClass(cname, SynonymMap.Parser.class);
        try {
            parser = (SynonymMap.Parser)clazz.getConstructor(Boolean.TYPE, Boolean.TYPE, Analyzer.class).newInstance(dedup, this.expand, analyzer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List files = this.splitFileNames(this.synonyms);
        for (String file : files) {
            decoder.reset();
            try (InputStreamReader isr = new InputStreamReader(loader.openResource(file), decoder);){
                parser.parse(isr);
            }
        }
        return parser.build();
    }

    private TokenizerFactory loadTokenizerFactory(ResourceLoader loader, String cname) throws IOException {
        Class clazz = loader.findClass(cname, TokenizerFactory.class);
        try {
            TokenizerFactory tokFactory = (TokenizerFactory)clazz.getConstructor(Map.class).newInstance(this.tokArgs);
            if (tokFactory instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)tokFactory).inform(loader);
            }
            return tokFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Analyzer loadAnalyzer(ResourceLoader loader, String cname) throws IOException {
        Class clazz = loader.findClass(cname, Analyzer.class);
        try {
            Analyzer analyzer = (Analyzer)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (analyzer instanceof ResourceLoaderAware) {
                ((ResourceLoaderAware)analyzer).inform(loader);
            }
            return analyzer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

