/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.action.IndicesRequest;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.index.Index;

public class NeuralSearchClusterUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(NeuralSearchClusterUtil.class);
    private ClusterService clusterService;
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private static NeuralSearchClusterUtil instance;

    public static synchronized NeuralSearchClusterUtil instance() {
        if (instance == null) {
            instance = new NeuralSearchClusterUtil();
        }
        return instance;
    }

    public void initialize(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public Version getClusterMinVersion() {
        return this.clusterService.state().getNodes().getMinNodeVersion();
    }

    public List<IndexMetadata> getIndexMetadataList(@NonNull IndicesRequest searchRequest) {
        Objects.requireNonNull(searchRequest, "searchRequest is marked non-null but is null");
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(this.clusterService.state(), searchRequest);
        return Arrays.stream(concreteIndices).map(concreteIndex -> this.clusterService.state().metadata().index(concreteIndex)).collect(Collectors.toList());
    }

    public Map<String, String> getIndexMapping(String[] indices) {
        try {
            if (indices != null && indices.length > 0) {
                return Arrays.stream(indices).filter(indexName -> {
                    IndexMetadata indexMetadata = this.clusterService.state().metadata().index(indexName);
                    return indexMetadata != null && indexMetadata.mapping() != null;
                }).collect(Collectors.toMap(indexName -> indexName, indexName -> {
                    IndexMetadata indexMetadata = this.clusterService.state().metadata().index(indexName);
                    return indexMetadata.mapping().source().toString();
                }));
            }
        }
        catch (Exception e) {
            log.warn("Failed to extract index mapping", (Throwable)e);
            throw new IllegalStateException("Failed to extract index mapping", e);
        }
        throw new IllegalStateException("No valid index found to extract mapping");
    }

    @Generated
    private NeuralSearchClusterUtil() {
    }
}

