/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) * 0l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(165l, 133l, 193l, 76l) * 3l) => i64vec4(495l, 399l, 579l, 228l)
 * (i64vec4(165l, 133l, 193l, 76l) * -1192l) => i64vec4(-196680l, -158536l, -230056l, -90592l)
 * (i64vec4(165l, 133l, 193l, 76l) * 1048576l) => i64vec4(173015040l, 139460608l, 202375168l, 79691776l)
 * (i64vec4(165l, 133l, 193l, 76l) * 4251475l) => i64vec4(701493375l, 565446175l, 820534675l, 323112100l)
 * (i64vec4(165l, 133l, 193l, 76l) * 29852643761l) => i64vec4(4925686220565l, 3970401620213l, 5761560245873l, 2268800925836l)
 * (i64vec4(165l, 133l, 193l, 76l) * -4398046511104l) => i64vec4(-725677674332160l, -584940185976832l, -848822976643072l, -334251534843904l)
 * (i64vec4(165l, 133l, 193l, 76l) * -3948976685146l) => i64vec4(-651581153049090l, -525213899124418l, -762152500233178l, -300122228071096l)
 * (i64vec4(165l, 133l, 193l, 76l) * -135763469567146206l) => i64vec4(-3954228404869572374l, 390202621279106218l, -7755605552749666142l, 8128720386606439960l)
 * (i64vec4(80l, -15l, -51l, 0l) * 0l) => i64vec4(0l, 0l, 0l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * 3l) => i64vec4(240l, -45l, -153l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * -1192l) => i64vec4(-95360l, 17880l, 60792l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * 1048576l) => i64vec4(83886080l, -15728640l, -53477376l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * 4251475l) => i64vec4(340118000l, -63772125l, -216825225l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * 29852643761l) => i64vec4(2388211500880l, -447789656415l, -1522484831811l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * -4398046511104l) => i64vec4(-351843720888320l, 65970697666560l, 224300372066304l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * -3948976685146l) => i64vec4(-315918134811680l, 59234650277190l, 201397810942446l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) * -135763469567146206l) => i64vec4(7585666508337855136l, 2036452043507193090l, 6923936947924456506l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * 0l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * 3l), i64vec4(495l, 399l, 579l, 228l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * -1192l), i64vec4(-196680l, -158536l, -230056l, -90592l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * 1048576l), i64vec4(173015040l, 139460608l, 202375168l, 79691776l))) ? 1 : -1] array3;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * 4251475l), i64vec4(701493375l, 565446175l, 820534675l, 323112100l))) ? 1 : -1] array4;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * 29852643761l), i64vec4(4925686220565l, 3970401620213l, 5761560245873l, 2268800925836l))) ? 1 : -1] array5;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * -4398046511104l), i64vec4(-725677674332160l, -584940185976832l, -848822976643072l, -334251534843904l))) ? 1 : -1] array6;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * -3948976685146l), i64vec4(-651581153049090l, -525213899124418l, -762152500233178l, -300122228071096l))) ? 1 : -1] array7;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) * -135763469567146206l), i64vec4(-3954228404869572374l, 390202621279106218l, -7755605552749666142l, 8128720386606439960l))) ? 1 : -1] array8;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * 0l), i64vec4(0l, 0l, 0l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * 3l), i64vec4(240l, -45l, -153l, 0l))) ? 1 : -1] array10;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * -1192l), i64vec4(-95360l, 17880l, 60792l, 0l))) ? 1 : -1] array11;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * 1048576l), i64vec4(83886080l, -15728640l, -53477376l, 0l))) ? 1 : -1] array12;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * 4251475l), i64vec4(340118000l, -63772125l, -216825225l, 0l))) ? 1 : -1] array13;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * 29852643761l), i64vec4(2388211500880l, -447789656415l, -1522484831811l, 0l))) ? 1 : -1] array14;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * -4398046511104l), i64vec4(-351843720888320l, 65970697666560l, 224300372066304l, 0l))) ? 1 : -1] array15;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * -3948976685146l), i64vec4(-315918134811680l, 59234650277190l, 201397810942446l, 0l))) ? 1 : -1] array16;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) * -135763469567146206l), i64vec4(7585666508337855136l, 2036452043507193090l, 6923936947924456506l, 0l))) ? 1 : -1] array17;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
