/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.stream.Stream;

@Provider
@Produces(value={"application/json"})
public class StreamWriter
implements MessageBodyWriter<Stream<?>> {
    private final ObjectMapper objectMapper;

    @Inject
    public StreamWriter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Stream.class.isAssignableFrom(type);
    }

    public void writeTo(Stream<?> stream, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (Stream<?> stream2 = stream;
             JsonGenerator generator = this.objectMapper.createGenerator(entityStream);){
            generator.writeStartArray();
            Iterator it = stream.iterator();
            while (it.hasNext()) {
                this.objectMapper.writeValue(generator, it.next());
            }
            generator.writeEndArray();
        }
    }
}

