/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.internal;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.ast.AbstractRestrictedTableMutation;
import org.hibernate.sql.model.ast.AbstractTableUpdate;
import org.hibernate.sql.model.ast.ColumnValueBinding;
import org.hibernate.sql.model.ast.ColumnValueParameter;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.RestrictedTableMutation;
import org.hibernate.sql.model.jdbc.JdbcUpdateMutation;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;

public class OptionalTableUpdate
extends AbstractRestrictedTableMutation<MutationOperation>
implements RestrictedTableMutation<MutationOperation> {
    private final List<ColumnValueBinding> valueBindings;

    public OptionalTableUpdate(MutatingTableReference mutatingTable, MutationTarget<?> mutationTarget, List<ColumnValueBinding> valueBindings, List<ColumnValueBinding> keyRestrictionBindings, List<ColumnValueBinding> optLockRestrictionBindings) {
        this(mutatingTable, mutationTarget, "upsert for " + mutationTarget.getRolePath(), valueBindings, keyRestrictionBindings, optLockRestrictionBindings);
    }

    public OptionalTableUpdate(MutatingTableReference mutatingTable, MutationTarget<?> mutationTarget, String comment, List<ColumnValueBinding> valueBindings, List<ColumnValueBinding> keyRestrictionBindings, List<ColumnValueBinding> optLockRestrictionBindings) {
        super(mutatingTable, mutationTarget, comment, keyRestrictionBindings, optLockRestrictionBindings, AbstractTableUpdate.collectParameters(valueBindings, keyRestrictionBindings, optLockRestrictionBindings));
        this.valueBindings = valueBindings;
    }

    @Override
    protected String getLoggableName() {
        return "OptionalTableUpdate";
    }

    @Override
    public boolean isCustomSql() {
        return false;
    }

    public EntityMutationTarget getMutationTarget() {
        return (EntityMutationTarget)super.getMutationTarget();
    }

    @Override
    public boolean isCallable() {
        return false;
    }

    @Override
    public Expectation getExpectation() {
        return this.getMutatingTable().getTableMapping().getUpdateDetails().getExpectation();
    }

    @Override
    public void forEachParameter(Consumer<ColumnValueParameter> consumer) {
        BiConsumer<Integer, ColumnValueBinding> intermediateConsumer = (index, binding) -> {
            for (ColumnValueParameter parameter : binding.getValueExpression().getParameters()) {
                consumer.accept(parameter);
            }
        };
        OptionalTableUpdate.forEachThing(this.getValueBindings(), intermediateConsumer);
        OptionalTableUpdate.forEachThing(this.getKeyBindings(), intermediateConsumer);
        OptionalTableUpdate.forEachThing(this.getOptimisticLockBindings(), intermediateConsumer);
    }

    public List<ColumnValueBinding> getValueBindings() {
        return this.valueBindings;
    }

    @Override
    public void forEachValueBinding(BiConsumer<Integer, ColumnValueBinding> consumer) {
        OptionalTableUpdate.forEachThing(this.valueBindings, consumer);
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitOptionalTableUpdate(this);
    }

    @Override
    public MutationOperation createMutationOperation(ValuesAnalysis valuesAnalysis, SessionFactoryImplementor factory) {
        if (this.getMutatingTable().getTableMapping().getInsertDetails().getCustomSql() != null || this.getMutatingTable().getTableMapping().getDeleteDetails().getCustomSql() != null) {
            return new OptionalTableUpdateOperation(this.getMutationTarget(), this, factory);
        }
        return factory.getJdbcServices().getDialect().createOptionalTableUpdateOperation(this.getMutationTarget(), this, factory);
    }

    @Override
    protected MutationOperation createMutationOperation(TableMapping tableDetails, String updateSql, List<JdbcParameterBinder> effectiveBinders) {
        return new JdbcUpdateMutation(tableDetails, this.getMutationTarget(), updateSql, this.isCallable(), this.getExpectation(), effectiveBinders);
    }
}

