/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.credential.store;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import java.util.Random;
import org.apache.custos.core.model.credential.store.CredentialEntity;
import org.apache.custos.core.repo.credential.store.CredentialRepository;
import org.apache.custos.service.credential.store.Credential;
import org.apache.custos.service.credential.store.CredentialTypes;
import org.apache.custos.service.exceptions.credential.store.CredentialGenerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class CredentialManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialManager.class);
    @Value(value="${custos.credential.prefix:custos-}")
    private String credentialPrefix;
    private static final Random RANDOM = new SecureRandom();
    private static final String ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final int ID_LENGTH = 20;
    private static final int SECRET_LENGTH = 40;
    @Autowired
    private CredentialRepository repository;

    public Credential generateCredential(long ownerId, CredentialTypes type, long validTime) {
        try {
            String clientId = this.credentialPrefix + this.generateRandomClientId().toLowerCase() + "-" + ownerId;
            String secret = this.generateSecret();
            Credential credential = new Credential();
            CredentialEntity entity = new CredentialEntity();
            entity.setClientId(clientId);
            entity.setClientSecretExpiredAt(0L);
            entity.setOwnerId(ownerId);
            entity.setType(type.name());
            credential.setId(clientId);
            credential.setSecret(secret);
            this.repository.save((Object)entity);
            return credential;
        }
        catch (Exception exception) {
            LOGGER.error("Error occurred while generating credentials for {}", (Object)ownerId);
            throw new CredentialGenerationException("Error occurred while generating credentials for " + ownerId, exception);
        }
    }

    public static Credential decodeToken(String token) {
        try {
            String decodeString;
            String[] idSecretPair;
            byte[] array = Base64.getDecoder().decode(token);
            if (array != null && array.length > 0 && (idSecretPair = (decodeString = new String(array)).split(":")).length == 2) {
                Credential credential = new Credential();
                credential.setId(idSecretPair[0]);
                credential.setSecret(idSecretPair[1]);
                return credential;
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred while decoding token");
            throw new CredentialGenerationException("Error occurred while decoding token", ex);
        }
        return null;
    }

    public Credential decodeJWTToken(String token) {
        try {
            JsonNode jsonArray;
            ObjectMapper reader;
            JsonNode node;
            JsonNode realmAccess;
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String[] parts = token.split("\\.");
            String headerJson = new String(decoder.decode(parts[0]));
            String payloadJson = new String(decoder.decode(parts[1]));
            String signatureJson = new String(decoder.decode(parts[2]));
            ObjectMapper mapper = new ObjectMapper();
            Map jsonMap = (Map)mapper.readValue(payloadJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Credential credential = new Credential();
            credential.setId(jsonMap.get("azp").toString());
            credential.setEmail(jsonMap.get("email").toString());
            credential.setUsername(jsonMap.get("preferred_username").toString());
            if (jsonMap.get("realm_access") != null && (realmAccess = (node = (JsonNode)(reader = new ObjectMapper()).readValue(payloadJson, JsonNode.class)).get("realm_access")) != null && (jsonArray = realmAccess.get("roles")) != null && jsonArray.isArray()) {
                jsonArray.forEach(json -> {
                    if (json.asText().equals("admin")) {
                        credential.setAdmin(true);
                    }
                });
            }
            return credential;
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred while decoding token");
            throw new CredentialGenerationException("Error occurred while decoding token ", ex);
        }
    }

    public Credential decodeAgentJWTToken(String token) {
        try {
            Base64.Decoder decoder = Base64.getUrlDecoder();
            String[] parts = token.split("\\.");
            String headerJson = new String(decoder.decode(parts[0]));
            String payloadJson = new String(decoder.decode(parts[1]));
            String signatureJson = new String(decoder.decode(parts[2]));
            ObjectMapper mapper = new ObjectMapper();
            Map jsonMap = (Map)mapper.readValue(payloadJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
            Credential credential = new Credential();
            credential.setId(jsonMap.get("agent-id").toString());
            credential.setParentId(jsonMap.get("agent-parent-id").toString());
            return credential;
        }
        catch (Exception ex) {
            LOGGER.error("Error occurred while decoding token");
            throw new CredentialGenerationException("Error occurred while decoding token", ex);
        }
    }

    private String generateRandomClientId() {
        StringBuilder returnValue = new StringBuilder(20);
        for (int i = 0; i < 20; ++i) {
            returnValue.append(ALPHABET.charAt(RANDOM.nextInt(ALPHABET.length())));
        }
        return new String(returnValue);
    }

    private String generateSecret() {
        StringBuilder returnValue = new StringBuilder(40);
        for (int i = 0; i < 40; ++i) {
            returnValue.append(ALPHABET.charAt(RANDOM.nextInt(ALPHABET.length())));
        }
        return new String(returnValue);
    }
}

