/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.model.tenant;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.util.Date;
import java.util.Set;
import org.apache.custos.core.model.tenant.Contact;
import org.apache.custos.core.model.tenant.RedirectURI;
import org.apache.custos.core.model.tenant.TenantAttributeUpdateMetadata;
import org.apache.custos.core.model.tenant.TenantStatusUpdateMetadata;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="tenant")
@EntityListeners(value={AuditingEntityListener.class})
public class Tenant {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="tenant_id_generator")
    @SequenceGenerator(name="tenant_id_generator", sequenceName="tenant_sequence", initialValue=10000000, allocationSize=100)
    private Long id;
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private String domain;
    @Column(nullable=false)
    private String requesterEmail;
    @Column(nullable=false)
    private String status;
    @Column(nullable=false)
    private String adminFirstName;
    @Column(nullable=false)
    private String adminLastName;
    @Column(nullable=false)
    private String adminEmail;
    @Column(nullable=false)
    private String adminUsername;
    @Column(name="tenant_uri")
    private String logoURI;
    @Column(nullable=false)
    private String scope;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @CreatedDate
    private Date createdAt;
    private String uri;
    private String comment;
    private long parentId;
    @Column(nullable=false)
    private String applicationType;
    private String jwksUri;
    private String example_extension_parameter;
    private String tosUri;
    private String policyUri;
    private String jwks;
    private String softwareId;
    private String softwareVersion;
    private long refreshTokenLifetime = 0L;
    @OneToMany(mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<Contact> contacts;
    @OneToMany(mappedBy="tenant", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<RedirectURI> redirectURIS;
    @OneToMany(mappedBy="tenant", cascade={CascadeType.ALL})
    private Set<TenantAttributeUpdateMetadata> attributeUpdateMetadata;
    @OneToMany(mappedBy="tenant", cascade={CascadeType.ALL})
    private Set<TenantStatusUpdateMetadata> statusUpdateMetadata;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getRequesterEmail() {
        return this.requesterEmail;
    }

    public void setRequesterEmail(String requesterEmail) {
        this.requesterEmail = requesterEmail;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getAdminFirstName() {
        return this.adminFirstName;
    }

    public void setAdminFirstName(String adminFirstName) {
        this.adminFirstName = adminFirstName;
    }

    public String getAdminLastName() {
        return this.adminLastName;
    }

    public void setAdminLastName(String adminLastName) {
        this.adminLastName = adminLastName;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public String getLogoURI() {
        return this.logoURI;
    }

    public void setLogoURI(String logoURI) {
        this.logoURI = logoURI;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Set<Contact> getContacts() {
        return this.contacts;
    }

    public void setContacts(Set<Contact> contacts) {
        this.contacts = contacts;
    }

    public Set<RedirectURI> getRedirectURIS() {
        return this.redirectURIS;
    }

    public void setRedirectURIS(Set<RedirectURI> redirectURIS) {
        this.redirectURIS = redirectURIS;
    }

    public Set<TenantAttributeUpdateMetadata> getAttributeUpdateMetadata() {
        return this.attributeUpdateMetadata;
    }

    public void setAttributeUpdateMetadata(Set<TenantAttributeUpdateMetadata> attributeUpdateMetadata) {
        this.attributeUpdateMetadata = attributeUpdateMetadata;
    }

    public Set<TenantStatusUpdateMetadata> getStatusUpdateMetadata() {
        return this.statusUpdateMetadata;
    }

    public void setStatusUpdateMetadata(Set<TenantStatusUpdateMetadata> statusUpdateMetadata) {
        this.statusUpdateMetadata = statusUpdateMetadata;
    }

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getExample_extension_parameter() {
        return this.example_extension_parameter;
    }

    public void setExample_extension_parameter(String example_extension_parameter) {
        this.example_extension_parameter = example_extension_parameter;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getJwks() {
        return this.jwks;
    }

    public void setJwks(String jwks) {
        this.jwks = jwks;
    }

    public String getSoftwareId() {
        return this.softwareId;
    }

    public void setSoftwareId(String softwareId) {
        this.softwareId = softwareId;
    }

    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String softwareVersion) {
        this.softwareVersion = softwareVersion;
    }

    public long getRefreshTokenLifetime() {
        return this.refreshTokenLifetime;
    }

    public void setRefreshTokenLifetime(long refreshTokenLifetime) {
        this.refreshTokenLifetime = refreshTokenLifetime;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
}

