/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.vault.VaultException;
import org.springframework.vault.core.VaultKeyValueOperations;
import org.springframework.vault.core.VaultKeyValueOperationsSupport;
import org.springframework.vault.core.VaultOperations;
import org.springframework.vault.core.VaultVersionedKeyValueOperations;
import org.springframework.vault.core.util.KeyValueDelegate;
import org.springframework.vault.repository.convert.MappingVaultConverter;
import org.springframework.vault.repository.convert.SecretDocument;
import org.springframework.vault.repository.convert.VaultConverter;
import org.springframework.vault.repository.core.VaultQueryEngine;
import org.springframework.vault.repository.mapping.VaultMappingContext;
import org.springframework.vault.repository.mapping.VaultPersistentEntity;
import org.springframework.vault.repository.mapping.VaultPersistentProperty;
import org.springframework.vault.support.VaultResponse;
import org.springframework.vault.support.Versioned;

public class VaultKeyValueAdapter
extends AbstractKeyValueAdapter {
    private final VaultOperations vaultOperations;
    private final VaultConverter vaultConverter;
    private final KeyValueDelegate keyValueDelegate;
    private final Map<String, VaultKeyValueKeyspaceAccessor> accessors = new ConcurrentHashMap<String, VaultKeyValueKeyspaceAccessor>();

    public VaultKeyValueAdapter(VaultOperations vaultOperations) {
        this(vaultOperations, new MappingVaultConverter((MappingContext<? extends VaultPersistentEntity<?>, VaultPersistentProperty>)new VaultMappingContext()));
    }

    public VaultKeyValueAdapter(VaultOperations vaultOperations, VaultConverter vaultConverter) {
        super((QueryEngine)new VaultQueryEngine());
        Assert.notNull((Object)vaultOperations, (String)"VaultOperations must not be null");
        Assert.notNull((Object)vaultConverter, (String)"VaultConverter must not be null");
        this.vaultOperations = vaultOperations;
        this.vaultConverter = vaultConverter;
        this.keyValueDelegate = new KeyValueDelegate(vaultOperations);
    }

    public Object put(Object id, Object item, String keyspace) {
        SecretDocument secretDocument = new SecretDocument(id.toString());
        this.vaultConverter.write(item, secretDocument);
        SecretDocument saved = this.getAccessor(keyspace).put(secretDocument);
        return this.vaultConverter.read(item.getClass(), saved);
    }

    public boolean contains(Object id, String keyspace) {
        return this.doList(keyspace).contains(id.toString());
    }

    @Nullable
    public Object get(Object id, String keyspace) {
        return this.get(id, keyspace, Object.class);
    }

    @Nullable
    public <T> T get(Object id, String keyspace, Class<T> type) {
        VaultKeyValueKeyspaceAccessor accessor = this.getAccessor(keyspace);
        SecretDocument document = accessor.get(id.toString());
        if (document == null) {
            return null;
        }
        return (T)this.vaultConverter.read(type, document);
    }

    @Nullable
    public Object delete(Object id, String keyspace) {
        return this.delete(id, keyspace, Object.class);
    }

    @Nullable
    public <T> T delete(Object id, String keyspace, Class<T> type) {
        T entity = this.get(id, keyspace, type);
        if (entity == null) {
            return null;
        }
        return this.deleteEntity(entity, keyspace);
    }

    public <T> T deleteEntity(T entity, String keyspace) {
        SecretDocument document = new SecretDocument();
        this.vaultConverter.write(entity, document);
        this.getAccessor(keyspace).delete(document);
        return entity;
    }

    public Iterable<?> getAllOf(String keyspace) {
        List<String> list = this.doList(keyspace);
        ArrayList<Object> items = new ArrayList<Object>(list.size());
        for (String id : list) {
            Object object = this.get(id, keyspace);
            if (object == null) continue;
            items.add(object);
        }
        return items;
    }

    public CloseableIterator<Map.Entry<Object, Object>> entries(final String keyspace) {
        List<String> list = this.doList(keyspace);
        final Iterator<String> iterator = list.iterator();
        return new CloseableIterator<Map.Entry<Object, Object>>(){

            public void close() {
            }

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Map.Entry<Object, Object> next() {
                final String key = (String)iterator.next();
                return new Map.Entry<Object, Object>(){

                    @Override
                    public Object getKey() {
                        return key;
                    }

                    @Override
                    @Nullable
                    public Object getValue() {
                        return VaultKeyValueAdapter.this.get(key, keyspace);
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void deleteAllOf(String keyspace) {
        List<String> ids = this.doList(keyspace);
        VaultKeyValueKeyspaceAccessor accessor = this.getAccessor(keyspace);
        for (String id : ids) {
            accessor.delete(id);
        }
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public long count(String keyspace) {
        List<String> list = this.doList(keyspace);
        return list.size();
    }

    public void destroy() throws Exception {
    }

    List<String> doList(String keyspace) {
        VaultKeyValueKeyspaceAccessor accessor = this.getAccessor(keyspace);
        List<String> list = accessor.list(keyspace);
        return list == null ? Collections.emptyList() : list;
    }

    private VaultKeyValueKeyspaceAccessor getAccessor(String keyspace) {
        KeyValueDelegate.MountInfo mountInfo = this.keyValueDelegate.getMountInfo(keyspace);
        return this.accessors.computeIfAbsent(keyspace, it -> {
            if (this.keyValueDelegate.isVersioned((String)it)) {
                return new VaultKeyValue2KeyspaceAccessor(mountInfo, (String)it, this.vaultOperations.opsForVersionedKeyValue(mountInfo.getPath()));
            }
            return new VaultKeyValue1KeyspaceAccessor(mountInfo, (String)it, this.vaultOperations.opsForKeyValue(mountInfo.getPath(), VaultKeyValueOperationsSupport.KeyValueBackend.KV_1));
        });
    }

    public VaultConverter getConverter() {
        return this.vaultConverter;
    }

    public VaultOperations getVaultOperations() {
        return this.vaultOperations;
    }

    static abstract class VaultKeyValueKeyspaceAccessor {
        private final KeyValueDelegate.MountInfo mountInfo;
        private final String keyspace;
        private final String pathPrefix;

        protected VaultKeyValueKeyspaceAccessor(KeyValueDelegate.MountInfo mountInfo, String keyspace) {
            this.mountInfo = mountInfo;
            this.keyspace = keyspace;
            this.pathPrefix = this.getPathInMount(keyspace);
        }

        @Nullable
        abstract List<String> list(String var1);

        String getPathInMount(String keyspace) {
            if (!keyspace.startsWith(this.mountInfo.getPath())) {
                return keyspace;
            }
            return keyspace.substring(this.mountInfo.getPath().length());
        }

        String createPath(String id) {
            return this.pathPrefix + "/" + id;
        }

        @Nullable
        abstract SecretDocument get(String var1);

        abstract SecretDocument put(SecretDocument var1);

        abstract void delete(String var1);

        abstract void delete(SecretDocument var1);
    }

    static class VaultKeyValue2KeyspaceAccessor
    extends VaultKeyValueKeyspaceAccessor {
        private final VaultVersionedKeyValueOperations operations;

        public VaultKeyValue2KeyspaceAccessor(KeyValueDelegate.MountInfo mountInfo, String keyspace, VaultVersionedKeyValueOperations operations) {
            super(mountInfo, keyspace);
            this.operations = operations;
        }

        @Override
        @Nullable
        public List<String> list(String pattern) {
            return this.operations.list(this.getPathInMount(pattern));
        }

        @Override
        @Nullable
        SecretDocument get(String id) {
            Object versioned = this.operations.get(this.createPath(id));
            if (versioned == null || !((Versioned)versioned).hasData()) {
                return null;
            }
            return new SecretDocument(id, ((Versioned)versioned).getVersion().getVersion(), (Map)((Versioned)versioned).getRequiredData());
        }

        @Override
        SecretDocument put(SecretDocument secretDocument) {
            try {
                Versioned.Metadata metadata = secretDocument.getVersion() != null ? this.operations.put(this.createPath(secretDocument.getRequiredId()), Versioned.create(secretDocument.getBody(), Versioned.Version.from(secretDocument.getVersion()))) : this.operations.put(this.createPath(secretDocument.getRequiredId()), secretDocument.getBody());
                return new SecretDocument(secretDocument.getRequiredId(), metadata.getVersion().getVersion(), secretDocument.getBody());
            }
            catch (VaultException e) {
                if (e.getMessage() != null && e.getMessage().contains("check-and-set parameter did not match the current version")) {
                    throw new OptimisticLockingFailureException(e.getMessage(), (Throwable)((Object)e));
                }
                throw e;
            }
        }

        @Override
        void delete(String id) {
            this.operations.delete(this.createPath(id));
        }

        @Override
        void delete(SecretDocument document) {
            if (document.getVersion() != null) {
                this.operations.delete(this.createPath(document.getRequiredId()), Versioned.Version.from(document.getVersion()));
            } else {
                this.delete(document.getRequiredId());
            }
        }
    }

    static class VaultKeyValue1KeyspaceAccessor
    extends VaultKeyValueKeyspaceAccessor {
        private final VaultKeyValueOperations operations;

        public VaultKeyValue1KeyspaceAccessor(KeyValueDelegate.MountInfo mountInfo, String keyspace, VaultKeyValueOperations operations) {
            super(mountInfo, keyspace);
            this.operations = operations;
        }

        @Override
        @Nullable
        public List<String> list(String pattern) {
            return this.operations.list(this.getPathInMount(pattern));
        }

        @Override
        @Nullable
        SecretDocument get(String id) {
            VaultResponse vaultResponse = this.operations.get(this.createPath(id));
            if (vaultResponse == null) {
                return null;
            }
            return new SecretDocument(id, (Map)vaultResponse.getRequiredData());
        }

        @Override
        SecretDocument put(SecretDocument secretDocument) {
            this.operations.put(this.createPath(secretDocument.getRequiredId()), secretDocument.getBody());
            return secretDocument;
        }

        @Override
        void delete(String id) {
            this.operations.delete(this.createPath(id));
        }

        @Override
        void delete(SecretDocument document) {
            this.delete(document.getRequiredId());
        }
    }
}

