/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.watcher;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.watcher.FileClassifier;
import net.openhft.chronicle.core.watcher.FileManager;
import net.openhft.chronicle.core.watcher.WatcherListener;

public class ClassifyingWatcherListener
implements WatcherListener {
    final Set<FileClassifier> classifiers = new CopyOnWriteArraySet<FileClassifier>();
    final Map<Path, FileManager> fileManagerMap = new TreeMap<Path, FileManager>();

    @Override
    public void onExists(String base, String filename, Boolean modified) {
        Path path = Paths.get(base, filename);
        if (this.fileManagerMap.containsKey(path)) {
            return;
        }
        for (FileClassifier classifier : this.classifiers) {
            FileManager manager = classifier.classify(base, filename);
            if (manager == null) continue;
            Jvm.warn().on(this.getClass(), "File " + base + " " + filename + " classified as " + manager);
            this.fileManagerMap.put(path, manager);
            manager.start();
        }
    }

    @Override
    public void onRemoved(String base, String filename) {
        Path path = Paths.get(base, filename);
        FileManager info = this.fileManagerMap.remove(path);
        if (info != null) {
            info.stop();
        }
    }

    public void addClassifier(FileClassifier fileClassifier) {
        this.classifiers.add(fileClassifier);
    }
}

