/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.commitlog;

import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class IntervalSet<T extends Comparable<T>> {
    private static final IntervalSet EMPTY = new IntervalSet(ImmutableSortedMap.of());
    private final NavigableMap<T, T> ranges;

    private IntervalSet(ImmutableSortedMap<T, T> ranges) {
        this.ranges = ranges;
    }

    public IntervalSet(T start, T end) {
        this(ImmutableSortedMap.of(start, end));
    }

    public static <T extends Comparable<T>> IntervalSet<T> empty() {
        return EMPTY;
    }

    public boolean contains(T position) {
        Map.Entry<T, T> range = this.ranges.floorEntry(position);
        return range != null && position.compareTo((Comparable)((Comparable)range.getValue())) <= 0;
    }

    public boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    public Optional<T> lowerBound() {
        return this.isEmpty() ? Optional.empty() : Optional.of((Comparable)this.ranges.firstKey());
    }

    public Optional<T> upperBound() {
        return this.isEmpty() ? Optional.empty() : Optional.of((Comparable)this.ranges.lastEntry().getValue());
    }

    public Collection<T> starts() {
        return this.ranges.keySet();
    }

    public Collection<T> ends() {
        return this.ranges.values();
    }

    public String toString() {
        return this.ranges.toString();
    }

    public int hashCode() {
        return this.ranges.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof IntervalSet && this.ranges.equals(((IntervalSet)obj).ranges);
    }

    public static final <T extends Comparable<T>> ISerializer<IntervalSet<T>> serializer(final ISerializer<T> pointSerializer) {
        return new ISerializer<IntervalSet<T>>(){

            @Override
            public void serialize(IntervalSet<T> intervals, DataOutputPlus out) throws IOException {
                out.writeInt(intervals.ranges.size());
                for (Map.Entry en : intervals.ranges.entrySet()) {
                    pointSerializer.serialize((Comparable)en.getKey(), out);
                    pointSerializer.serialize((Comparable)en.getValue(), out);
                }
            }

            @Override
            public IntervalSet<T> deserialize(DataInputPlus in) throws IOException {
                int count = in.readInt();
                TreeMap<Comparable, Comparable> ranges = new TreeMap<Comparable, Comparable>();
                for (int i = 0; i < count; ++i) {
                    ranges.put((Comparable)pointSerializer.deserialize(in), (Comparable)pointSerializer.deserialize(in));
                }
                return new IntervalSet(ImmutableSortedMap.copyOfSorted(ranges));
            }

            @Override
            public long serializedSize(IntervalSet<T> intervals) {
                long size = TypeSizes.sizeof(intervals.ranges.size());
                for (Map.Entry en : intervals.ranges.entrySet()) {
                    size += pointSerializer.serializedSize((Comparable)en.getKey());
                    size += pointSerializer.serializedSize((Comparable)en.getValue());
                }
                return size;
            }
        };
    }

    public static class Builder<T extends Comparable<T>> {
        final NavigableMap<T, T> ranges = new TreeMap<T, T>();

        public Builder() {
        }

        public Builder(T start, T end) {
            this();
            assert (start.compareTo(end) <= 0);
            this.ranges.put(start, end);
        }

        public void add(T start, T end) {
            assert (start.compareTo(end) <= 0);
            Map.Entry<T, T> extend = this.ranges.floorEntry(end);
            if (extend != null && ((Comparable)extend.getValue()).compareTo(end) > 0) {
                end = (Comparable)extend.getValue();
            }
            if ((extend = this.ranges.lowerEntry(start)) != null && ((Comparable)extend.getValue()).compareTo(start) >= 0) {
                start = (Comparable)extend.getKey();
            }
            this.ranges.subMap(start, end).clear();
            this.ranges.put(start, end);
        }

        public void addAll(IntervalSet<T> otherSet) {
            for (Map.Entry en : otherSet.ranges.entrySet()) {
                this.add((Comparable)en.getKey(), (Comparable)en.getValue());
            }
        }

        public IntervalSet<T> build() {
            return new IntervalSet(ImmutableSortedMap.copyOfSorted(this.ranges));
        }
    }
}

